/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.expressions.functions;

import net.sf.jasperreports.expressions.annotations.JRExprFunction;
import net.sf.jasperreports.expressions.annotations.JRExprFunctionCategories;
import net.sf.jasperreports.expressions.annotations.JRExprFunctionParameter;
import net.sf.jasperreports.expressions.annotations.JRExprFunctionParameters;
import net.sf.jasperreports.expressions.functions.errors.JRExpressionFunctionException;

public final class MathFunctions {
    @JRExprFunction(name="ABS", description="Returns the absolute value of a number.")
    @JRExprFunctionParameters(value={@JRExprFunctionParameter(name="Number", description="The number to check.")})
    @JRExprFunctionCategories(value={"MATH"})
    public static Number ABS(Number number) {
        if (number == null) {
            return null;
        }
        if (number instanceof Integer) {
            return Math.abs((Integer)number);
        }
        if (number instanceof Double) {
            return Math.abs((Double)number);
        }
        if (number instanceof Float) {
            return Float.valueOf(Math.abs(((Float)number).floatValue()));
        }
        if (number instanceof Long) {
            return Math.abs((Long)number);
        }
        return Math.abs(number.doubleValue());
    }

    @JRExprFunction(name="FACT", description="Returns the factorial of a number")
    @JRExprFunctionParameters(value={@JRExprFunctionParameter(name="Integer number", description="The argument.")})
    @JRExprFunctionCategories(value={"MATH"})
    public static Long FACT(Integer number) {
        if (number == null) {
            return null;
        }
        if (number < 0) {
            throw new JRExpressionFunctionException("Unable to calculate the factorial number of a negative number.");
        }
        Long result = 1L;
        for (int i = 1; i <= number; ++i) {
            result = result * (long)i;
        }
        return result;
    }

    @JRExprFunction(name="ISEVEN", description="Checks if a number is even. If a non-integer number is specified, any digits after the decimal point are ignored.")
    @JRExprFunctionParameters(value={@JRExprFunctionParameter(name="Number", description="The number to check.")})
    @JRExprFunctionCategories(value={"MATH"})
    public static Boolean ISEVEN(Number number) {
        if (number == null) {
            return null;
        }
        return number.intValue() % 2 == 0;
    }

    @JRExprFunction(name="ISODD", description="Checks if a number is odd. If a non-integer number is specified, any digits after the decimal point are ignored.")
    @JRExprFunctionParameters(value={@JRExprFunctionParameter(name="Number", description="The number to check.")})
    @JRExprFunctionCategories(value={"MATH"})
    public static Boolean ISODD(Number number) {
        if (number == null) {
            return null;
        }
        return number.intValue() % 2 == 1;
    }

    @JRExprFunction(name="PRODUCT", description="Returns the product of a list of numbers")
    @JRExprFunctionParameters(value={@JRExprFunctionParameter(name="Number", description="Argument")})
    @JRExprFunctionCategories(value={"MATH"})
    public static Number PRODUCT(Number ... numbers) {
        if (numbers.length == 0) {
            return null;
        }
        double result = 1.0;
        for (int i = 0; i < numbers.length; ++i) {
            result *= numbers[i].doubleValue();
        }
        return result;
    }

    @JRExprFunction(name="RAND", description="Returns a random number between 0.0 and 1.0.")
    @JRExprFunctionCategories(value={"MATH"})
    public static Double RAND() {
        return Math.random();
    }

    @JRExprFunction(name="RANDBETWEEN", description="Returns an Integer random number between bottom and top range (both inclusive).")
    @JRExprFunctionCategories(value={"MATH"})
    @JRExprFunctionParameters(value={@JRExprFunctionParameter(name="Bottom range", description="Integer number for the bottom range"), @JRExprFunctionParameter(name="Top range", description="Integer number for the top range")})
    public static Integer RANDBETWEEN(Integer bottomRange, Integer topRange) {
        int min = bottomRange;
        int max = topRange;
        return min + (int)(Math.random() * (double)(max - min + 1));
    }

    @JRExprFunction(name="SIGN", description="Returns the sign of a number.")
    @JRExprFunctionParameters(value={@JRExprFunctionParameter(name="Number", description="The number to check.")})
    @JRExprFunctionCategories(value={"MATH"})
    public static Integer SIGN(Number number) {
        if (number == null) {
            return null;
        }
        return (int)Math.signum(number.doubleValue());
    }

    @JRExprFunction(name="SQRT", description="Returns the positive square root of a number. The number must be positive")
    @JRExprFunctionParameters(value={@JRExprFunctionParameter(name="Positive number", description="Argument.")})
    @JRExprFunctionCategories(value={"MATH"})
    public static Number SQRT(Number number) {
        if (number == null) {
            return null;
        }
        return Math.sqrt(number.doubleValue());
    }

    @JRExprFunction(name="SUM", description="Returns the sum of a list of numbers")
    @JRExprFunctionParameters(value={@JRExprFunctionParameter(name="Number", description="Addendum")})
    @JRExprFunctionCategories(value={"MATH"})
    public static Number SUM(Number ... numbers) {
        if (numbers.length == 0) {
            return null;
        }
        double result = 0.0;
        for (int i = 0; i < numbers.length; ++i) {
            result += numbers[i].doubleValue();
        }
        return result;
    }
}

