/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.querybuilder.dnd;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import nickyb.sqleonardo.querybuilder.DiagramEntity;
import nickyb.sqleonardo.querybuilder.DiagramField;
import nickyb.sqleonardo.querybuilder.ViewDiagram;
import nickyb.sqleonardo.querybuilder.beans.EntityField;

public class RelationDropTargetListener
implements DropTargetListener {
    private ViewDiagram viewDiagram = null;
    private static final DataFlavor entityFieldDataFlavor = new DataFlavor(EntityField.class, EntityField.class.getName());

    public RelationDropTargetListener(ViewDiagram viewdiagram) {
        this.setViewDiagram(viewdiagram);
    }

    public void dragEnter(DropTargetDragEvent event) {
        if (!this.isDragAcceptable(event)) {
            event.rejectDrag();
            return;
        }
    }

    public void dragExit(DropTargetEvent event) {
    }

    public void dragOver(DropTargetDragEvent event) {
    }

    public void dropActionChanged(DropTargetDragEvent event) {
        if (!this.isDragAcceptable(event)) {
            event.rejectDrag();
            return;
        }
    }

    public void drop(DropTargetDropEvent event) {
        if (!this.isDropAcceptable(event)) {
            event.rejectDrop();
            return;
        }
        event.acceptDrop(1);
        Transferable transferable = event.getTransferable();
        try {
            EntityField entityField = (EntityField)transferable.getTransferData(entityFieldDataFlavor);
            DiagramEntity deF = this.getViewDiagram().getEntity(entityField.getTable());
            DiagramField dfF = deF.getField(entityField.getFieldName());
            DiagramField dfP = (DiagramField)event.getDropTargetContext().getDropTarget().getComponent().getParent();
            this.getViewDiagram().join(dfP.getOwner(), dfP, deF, dfF);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        event.dropComplete(true);
    }

    public boolean isDropAcceptable(DropTargetDropEvent event) {
        DataFlavor[] dataFlavors = event.getCurrentDataFlavors();
        for (int i = 0; i < dataFlavors.length; ++i) {
            DataFlavor dataFlavor = dataFlavors[i];
            if (!dataFlavor.equals(entityFieldDataFlavor)) continue;
            return true;
        }
        return false;
    }

    public boolean isDragAcceptable(DropTargetDragEvent event) {
        return event.getCurrentDataFlavorsAsList().contains(entityFieldDataFlavor);
    }

    public ViewDiagram getViewDiagram() {
        return this.viewDiagram;
    }

    public void setViewDiagram(ViewDiagram viewDiagram) {
        this.viewDiagram = viewDiagram;
    }
}

