/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.impl.code128;

import org.krysalis.barcode4j.BarGroup;
import org.krysalis.barcode4j.ClassicBarcodeLogicHandler;
import org.krysalis.barcode4j.impl.code128.Code128Encoder;
import org.krysalis.barcode4j.impl.code128.DefaultCode128Encoder;
import org.krysalis.barcode4j.tools.MessageUtil;

public class Code128LogicImpl {
    public static final char FNC_1 = '\u00f1';
    public static final char FNC_2 = '\u00f2';
    public static final char FNC_3 = '\u00f3';
    public static final char FNC_4 = '\u00f4';
    private static final byte[][] CHARSET = new byte[][]{{2, 1, 2, 2, 2, 2}, {2, 2, 2, 1, 2, 2}, {2, 2, 2, 2, 2, 1}, {1, 2, 1, 2, 2, 3}, {1, 2, 1, 3, 2, 2}, {1, 3, 1, 2, 2, 2}, {1, 2, 2, 2, 1, 3}, {1, 2, 2, 3, 1, 2}, {1, 3, 2, 2, 1, 2}, {2, 2, 1, 2, 1, 3}, {2, 2, 1, 3, 1, 2}, {2, 3, 1, 2, 1, 2}, {1, 1, 2, 2, 3, 2}, {1, 2, 2, 1, 3, 2}, {1, 2, 2, 2, 3, 1}, {1, 1, 3, 2, 2, 2}, {1, 2, 3, 1, 2, 2}, {1, 2, 3, 2, 2, 1}, {2, 2, 3, 2, 1, 1}, {2, 2, 1, 1, 3, 2}, {2, 2, 1, 2, 3, 1}, {2, 1, 3, 2, 1, 2}, {2, 2, 3, 1, 1, 2}, {3, 1, 2, 1, 3, 1}, {3, 1, 1, 2, 2, 2}, {3, 2, 1, 1, 2, 2}, {3, 2, 1, 2, 2, 1}, {3, 1, 2, 2, 1, 2}, {3, 2, 2, 1, 1, 2}, {3, 2, 2, 2, 1, 1}, {2, 1, 2, 1, 2, 3}, {2, 1, 2, 3, 2, 1}, {2, 3, 2, 1, 2, 1}, {1, 1, 1, 3, 2, 3}, {1, 3, 1, 1, 2, 3}, {1, 3, 1, 3, 2, 1}, {1, 1, 2, 3, 1, 3}, {1, 3, 2, 1, 1, 3}, {1, 3, 2, 3, 1, 1}, {2, 1, 1, 3, 1, 3}, {2, 3, 1, 1, 1, 3}, {2, 3, 1, 3, 1, 1}, {1, 1, 2, 1, 3, 3}, {1, 1, 2, 3, 3, 1}, {1, 3, 2, 1, 3, 1}, {1, 1, 3, 1, 2, 3}, {1, 1, 3, 3, 2, 1}, {1, 3, 3, 1, 2, 1}, {3, 1, 3, 1, 2, 1}, {2, 1, 1, 3, 3, 1}, {2, 3, 1, 1, 3, 1}, {2, 1, 3, 1, 1, 3}, {2, 1, 3, 3, 1, 1}, {2, 1, 3, 1, 3, 1}, {3, 1, 1, 1, 2, 3}, {3, 1, 1, 3, 2, 1}, {3, 3, 1, 1, 2, 1}, {3, 1, 2, 1, 1, 3}, {3, 1, 2, 3, 1, 1}, {3, 3, 2, 1, 1, 1}, {3, 1, 4, 1, 1, 1}, {2, 2, 1, 4, 1, 1}, {4, 3, 1, 1, 1, 1}, {1, 1, 1, 2, 2, 4}, {1, 1, 1, 4, 2, 2}, {1, 2, 1, 1, 2, 4}, {1, 2, 1, 4, 2, 1}, {1, 4, 1, 1, 2, 2}, {1, 4, 1, 2, 2, 1}, {1, 1, 2, 2, 1, 4}, {1, 1, 2, 4, 1, 2}, {1, 2, 2, 1, 1, 4}, {1, 2, 2, 4, 1, 1}, {1, 4, 2, 1, 1, 2}, {1, 4, 2, 2, 1, 1}, {2, 4, 1, 2, 1, 1}, {2, 2, 1, 1, 1, 4}, {4, 1, 3, 1, 1, 1}, {2, 4, 1, 1, 1, 2}, {1, 3, 4, 1, 1, 1}, {1, 1, 1, 2, 4, 2}, {1, 2, 1, 1, 4, 2}, {1, 2, 1, 2, 4, 1}, {1, 1, 4, 2, 1, 2}, {1, 2, 4, 1, 1, 2}, {1, 2, 4, 2, 1, 1}, {4, 1, 1, 2, 1, 2}, {4, 2, 1, 1, 1, 2}, {4, 2, 1, 2, 1, 1}, {2, 1, 2, 1, 4, 1}, {2, 1, 4, 1, 2, 1}, {4, 1, 2, 1, 2, 1}, {1, 1, 1, 1, 4, 3}, {1, 1, 1, 3, 4, 1}, {1, 3, 1, 1, 4, 1}, {1, 1, 4, 1, 1, 3}, {1, 1, 4, 3, 1, 1}, {4, 1, 1, 1, 1, 3}, {4, 1, 1, 3, 1, 1}, {1, 1, 3, 1, 4, 1}, {1, 1, 4, 1, 3, 1}, {3, 1, 1, 1, 4, 1}, {4, 1, 1, 1, 3, 1}, {2, 1, 1, 4, 1, 2}, {2, 1, 1, 2, 1, 4}, {2, 1, 1, 2, 3, 2}};
    private static final byte[] STOP = new byte[]{2, 3, 3, 1, 1, 1, 2};
    private int codeset;

    public Code128LogicImpl() {
        this(7);
    }

    public Code128LogicImpl(int codeset) {
        this.codeset = codeset;
    }

    public static boolean isValidChar(char ch) {
        return ch >= '\u0000' && ch <= '\u007f' || ch >= '\u00f1' && ch <= '\u00f4';
    }

    public static boolean isInCodeSetA(char ch) {
        return ch >= '\u0000' && ch <= '_' || ch >= '\u00f1' && ch <= '\u00f4';
    }

    public static boolean isInCodeSetB(char ch) {
        return ch >= ' ' && ch <= '\u007f' || ch >= '\u00f1' && ch <= '\u00f4';
    }

    public static boolean canBeInCodeSetC(char ch, boolean second) {
        if (second) {
            return ch >= '0' && ch <= '9';
        }
        return ch >= '0' && ch <= '9' || ch == '\u00f1';
    }

    public static String symbolCharToString(int index) {
        switch (index) {
            case 96: {
                return "FNC3/96";
            }
            case 97: {
                return "FNC2/97";
            }
            case 98: {
                return "Shift/98";
            }
            case 99: {
                return "CodeC/99";
            }
            case 100: {
                return "CodeB/FNC4";
            }
            case 101: {
                return "CodeA/FNC4";
            }
            case 102: {
                return "FNC1";
            }
            case 103: {
                return "StartA";
            }
            case 104: {
                return "StartB";
            }
            case 105: {
                return "StartC";
            }
        }
        return "idx" + Integer.toString(index);
    }

    public static String toString(int[] encodedMsg) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < encodedMsg.length; ++i) {
            if (i > 0) {
                sb.append("|");
            }
            sb.append(Code128LogicImpl.symbolCharToString(encodedMsg[i]));
        }
        return sb.toString();
    }

    protected void encodeChar(ClassicBarcodeLogicHandler logic, int index) {
        logic.startBarGroup(BarGroup.MSG_CHARACTER, Code128LogicImpl.symbolCharToString(index));
        for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
            byte width = CHARSET[index][i];
            boolean black = i % 2 == 0;
            logic.addBar(black, width);
        }
        logic.endBarGroup();
    }

    protected void encodeStop(ClassicBarcodeLogicHandler logic) {
        logic.startBarGroup(BarGroup.STOP_CHARACTER, null);
        for (int i = 0; i < 7; i = (int)((byte)(i + 1))) {
            byte width = STOP[i];
            boolean black = i % 2 == 0;
            logic.addBar(black, width);
        }
        logic.endBarGroup();
    }

    protected Code128Encoder getEncoder() {
        return new DefaultCode128Encoder(this.codeset);
    }

    int[] createEncodedMessage(String msg) {
        return this.getEncoder().encode(msg);
    }

    public void generateBarcodeLogic(ClassicBarcodeLogicHandler logic, String msg) {
        logic.startBarcode(msg, MessageUtil.filterNonPrintableCharacters(msg));
        int[] encodedMsg = this.createEncodedMessage(msg);
        for (int i = 0; i < encodedMsg.length; ++i) {
            this.encodeChar(logic, encodedMsg[i]);
        }
        int checksum = encodedMsg[0];
        for (int i = 1; i < encodedMsg.length; ++i) {
            checksum += i * encodedMsg[i];
        }
        this.encodeChar(logic, checksum %= 103);
        this.encodeStop(logic);
        logic.endBarcode();
    }
}

