/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.UnionDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;

public class UnionOperator
extends Operator<UnionDesc>
implements Serializable {
    private static final long serialVersionUID = 1L;
    StructObjectInspector[] parentObjInspectors;
    List<? extends StructField>[] parentFields;
    GenericUDFUtils.ReturnObjectInspectorResolver[] columnTypeResolvers;
    boolean[] needsTransform;
    ArrayList<Object> outputRow;

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        int c;
        int c2;
        int parents = this.parentOperators.size();
        this.parentObjInspectors = new StructObjectInspector[parents];
        this.parentFields = new List[parents];
        for (int p = 0; p < parents; ++p) {
            this.parentObjInspectors[p] = (StructObjectInspector)this.inputObjInspectors[p];
            this.parentFields[p] = this.parentObjInspectors[p].getAllStructFieldRefs();
        }
        int columns = this.parentFields[0].size();
        ArrayList<String> columnNames = new ArrayList<String>(columns);
        for (c2 = 0; c2 < columns; ++c2) {
            columnNames.add(this.parentFields[0].get(c2).getFieldName());
        }
        this.columnTypeResolvers = new GenericUDFUtils.ReturnObjectInspectorResolver[columns];
        for (c2 = 0; c2 < columns; ++c2) {
            this.columnTypeResolvers[c2] = new GenericUDFUtils.ReturnObjectInspectorResolver(true);
        }
        for (int p = 0; p < parents; ++p) {
            assert (this.parentFields[p].size() == columns);
            for (c = 0; c < columns; ++c) {
                this.columnTypeResolvers[c].update(this.parentFields[p].get(c).getFieldObjectInspector());
            }
        }
        ArrayList<ObjectInspector> outputFieldOIs = new ArrayList<ObjectInspector>(columns);
        for (c = 0; c < columns; ++c) {
            outputFieldOIs.add(this.columnTypeResolvers[c].get());
        }
        this.outputObjInspector = ObjectInspectorFactory.getStandardStructObjectInspector(columnNames, outputFieldOIs);
        this.outputRow = new ArrayList(columns);
        for (c = 0; c < columns; ++c) {
            this.outputRow.add(null);
        }
        this.needsTransform = new boolean[parents];
        for (int p = 0; p < parents; ++p) {
            boolean bl = this.needsTransform[p] = this.inputObjInspectors[p] != this.outputObjInspector;
            if (!this.needsTransform[p]) continue;
            this.LOG.info((Object)("Union Operator needs to transform row from parent[" + p + "] from " + this.inputObjInspectors[p] + " to " + this.outputObjInspector));
        }
        this.initializeChildren(hconf);
    }

    @Override
    public synchronized void processOp(Object row, int tag) throws HiveException {
        StructObjectInspector soi = this.parentObjInspectors[tag];
        List<? extends StructField> fields = this.parentFields[tag];
        if (this.needsTransform[tag]) {
            for (int c = 0; c < fields.size(); ++c) {
                this.outputRow.set(c, this.columnTypeResolvers[c].convertIfNecessary(soi.getStructFieldData(row, fields.get(c)), fields.get(c).getFieldObjectInspector()));
            }
            this.forward(this.outputRow, this.outputObjInspector);
        } else {
            this.forward(row, this.inputObjInspectors[tag]);
        }
    }

    @Override
    public String getName() {
        return "UNION";
    }

    @Override
    public OperatorType getType() {
        return OperatorType.UNION;
    }
}

