/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.hadoop.hive.ql.plan.AggregationDesc;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;

@Explain(displayName="Group By Operator")
public class GroupByDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Mode mode;
    private boolean groupKeyNotReductionKey;
    private boolean bucketGroup;
    private ArrayList<ExprNodeDesc> keys;
    private ArrayList<AggregationDesc> aggregators;
    private ArrayList<String> outputColumnNames;
    private float groupByMemoryUsage;
    private float memoryThreshold;

    public GroupByDesc() {
    }

    public GroupByDesc(Mode mode, ArrayList<String> outputColumnNames, ArrayList<ExprNodeDesc> keys, ArrayList<AggregationDesc> aggregators, boolean groupKeyNotReductionKey, float groupByMemoryUsage, float memoryThreshold) {
        this(mode, outputColumnNames, keys, aggregators, groupKeyNotReductionKey, false, groupByMemoryUsage, memoryThreshold);
    }

    public GroupByDesc(Mode mode, ArrayList<String> outputColumnNames, ArrayList<ExprNodeDesc> keys, ArrayList<AggregationDesc> aggregators, boolean groupKeyNotReductionKey, boolean bucketGroup, float groupByMemoryUsage, float memoryThreshold) {
        this.mode = mode;
        this.outputColumnNames = outputColumnNames;
        this.keys = keys;
        this.aggregators = aggregators;
        this.groupKeyNotReductionKey = groupKeyNotReductionKey;
        this.bucketGroup = bucketGroup;
        this.groupByMemoryUsage = groupByMemoryUsage;
        this.memoryThreshold = memoryThreshold;
    }

    public Mode getMode() {
        return this.mode;
    }

    @Explain(displayName="mode")
    public String getModeString() {
        switch (this.mode) {
            case COMPLETE: {
                return "complete";
            }
            case PARTIAL1: {
                return "partial1";
            }
            case PARTIAL2: {
                return "partial2";
            }
            case PARTIALS: {
                return "partials";
            }
            case HASH: {
                return "hash";
            }
            case FINAL: {
                return "final";
            }
            case MERGEPARTIAL: {
                return "mergepartial";
            }
        }
        return "unknown";
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    @Explain(displayName="keys")
    public ArrayList<ExprNodeDesc> getKeys() {
        return this.keys;
    }

    public void setKeys(ArrayList<ExprNodeDesc> keys) {
        this.keys = keys;
    }

    @Explain(displayName="outputColumnNames")
    public ArrayList<String> getOutputColumnNames() {
        return this.outputColumnNames;
    }

    public void setOutputColumnNames(ArrayList<String> outputColumnNames) {
        this.outputColumnNames = outputColumnNames;
    }

    public float getGroupByMemoryUsage() {
        return this.groupByMemoryUsage;
    }

    public void setGroupByMemoryUsage(float groupByMemoryUsage) {
        this.groupByMemoryUsage = groupByMemoryUsage;
    }

    public float getMemoryThreshold() {
        return this.memoryThreshold;
    }

    public void setMemoryThreshold(float memoryThreshold) {
        this.memoryThreshold = memoryThreshold;
    }

    @Explain(displayName="aggregations")
    public ArrayList<AggregationDesc> getAggregators() {
        return this.aggregators;
    }

    public void setAggregators(ArrayList<AggregationDesc> aggregators) {
        this.aggregators = aggregators;
    }

    public boolean getGroupKeyNotReductionKey() {
        return this.groupKeyNotReductionKey;
    }

    public void setGroupKeyNotReductionKey(boolean groupKeyNotReductionKey) {
        this.groupKeyNotReductionKey = groupKeyNotReductionKey;
    }

    @Explain(displayName="bucketGroup")
    public boolean getBucketGroup() {
        return this.bucketGroup;
    }

    public void setBucketGroup(boolean dataSorted) {
        this.bucketGroup = dataSorted;
    }

    public boolean isDistinctLike() {
        ArrayList<AggregationDesc> aggregators = this.getAggregators();
        for (AggregationDesc ad : aggregators) {
            GenericUDAFEvaluator udafEval;
            UDFType annot;
            if (ad.getDistinct() || (annot = (udafEval = ad.getGenericUDAFEvaluator()).getClass().getAnnotation(UDFType.class)) != null && annot.distinctLike()) continue;
            return false;
        }
        return true;
    }

    public static enum Mode {
        COMPLETE,
        PARTIAL1,
        PARTIAL2,
        PARTIALS,
        FINAL,
        HASH,
        MERGEPARTIAL;

    }
}

