/*
 * Decompiled with CFR 0.152.
 */
package rex.graphics.filtertree.elements;

import javax.swing.ImageIcon;
import rex.graphics.dimensiontree.elements.DimensionElement;
import rex.graphics.dimensiontree.elements.DimensionTreeElement;
import rex.graphics.dimensiontree.elements.HierarchyElement;
import rex.graphics.dimensiontree.elements.LevelElement;
import rex.graphics.filtertree.elements.FilterTreePopUpActions;
import rex.metadata.ServerMetadata;
import rex.metadata.UniqueNameElement;
import rex.utils.I18n;
import rex.utils.LanguageChangedEvent;
import rex.utils.LanguageChangedListener;
import rex.utils.S;
import rex.xmla.XMLADiscoverProperties;
import rex.xmla.XMLADiscoverRestrictions;

public class FilterTreeRootElement
implements DimensionTreeElement,
UniqueNameElement,
LanguageChangedListener {
    private boolean flattenDimensions;
    private DimensionTreeElement filterElement;
    private boolean displayInTab;
    static ImageIcon icon = S.getAppIcon("FilterTreeRootElement.gif");

    public FilterTreeRootElement(DimensionTreeElement _filterElement) {
        I18n.addOnLanguageChangedListener(this);
        this.filterElement = _filterElement;
        this.displayInTab = false;
    }

    @Override
    public DimensionTreeElement[] getChildren(boolean noMatterWhat) {
        this.filterElement.getRestrictions().setDimensionUniqueName(this.filterElement.getDimensionUniqueName());
        if (this.filterElement instanceof DimensionElement) {
            S.out("instanceof DimensionElement setting NULL");
            this.filterElement.getRestrictions().setHierarchyUniqueName(null);
        } else if (this.filterElement instanceof HierarchyElement) {
            this.filterElement.getRestrictions().setHierarchyUniqueName(((HierarchyElement)this.filterElement).getUniqueName());
            S.out("instanceof HierarchyElement setting " + ((HierarchyElement)this.filterElement).getUniqueName());
        } else if (this.filterElement instanceof LevelElement) {
            S.out("instanceof LevelElement setting " + ((LevelElement)this.filterElement).getHierarchyUniqueName());
            this.filterElement.getRestrictions().setHierarchyUniqueName(((LevelElement)this.filterElement).getHierarchyUniqueName());
        }
        return this.filterElement.getServerMetadata().getFilterLevelList(this.filterElement.getRestrictions(), this.filterElement.getProperties());
    }

    @Override
    public String toString() {
        return "<HTML><B>" + I18n.getString("toolTip.filterOn") + this.filterElement.getCaption() + "</B></HTML>";
    }

    @Override
    public ImageIcon getIcon() {
        return icon;
    }

    public static ImageIcon getFilterIcon() {
        return icon;
    }

    @Override
    public String getToolTip() {
        return I18n.getString("toolTip.filterDimensions");
    }

    public void setFlattenDimensions(boolean _flattenDimensions) {
        this.flattenDimensions = _flattenDimensions;
    }

    @Override
    public String[] getPopUpActionList() {
        if (this.displayInTab) {
            return new String[]{FilterTreePopUpActions.LOSE_FILTER, FilterTreePopUpActions.APPLY_FILTER, FilterTreePopUpActions.MOVE_TO_SPLIT_PANE};
        }
        return new String[]{FilterTreePopUpActions.LOSE_FILTER, FilterTreePopUpActions.APPLY_FILTER, FilterTreePopUpActions.MOVE_TO_TAB};
    }

    @Override
    public String getUniqueName() {
        return I18n.getString("toolTip.filteTree");
    }

    @Override
    public String getCaption() {
        return null;
    }

    public String getQueryMembersExpression() {
        return null;
    }

    @Override
    public boolean isEnabled() {
        return false;
    }

    @Override
    public void setEnabled(boolean newValue) {
    }

    @Override
    public int getChildrenCount() {
        return 1;
    }

    @Override
    public ServerMetadata getServerMetadata() {
        return this.filterElement.getServerMetadata();
    }

    @Override
    public XMLADiscoverRestrictions getRestrictions() {
        return this.filterElement.getRestrictions();
    }

    @Override
    public XMLADiscoverProperties getProperties() {
        return this.filterElement.getProperties();
    }

    @Override
    public String getDimensionUniqueName() {
        return this.filterElement.getDimensionUniqueName();
    }

    public boolean isDisplayInTab() {
        return this.displayInTab;
    }

    public void setDisplayInTab(boolean _displayInTab) {
        this.displayInTab = _displayInTab;
    }

    @Override
    public void languageChanged(LanguageChangedEvent evt) {
        FilterTreePopUpActions.popUpCaptions.put(FilterTreePopUpActions.LOSE_FILTER, I18n.getString("menu.loseFilter"));
        FilterTreePopUpActions.popUpCaptions.put(FilterTreePopUpActions.APPLY_FILTER, I18n.getString("menu.applyFilter"));
        FilterTreePopUpActions.popUpCaptions.put(FilterTreePopUpActions.MOVE_TO_TAB, I18n.getString("menu.moveToTab"));
    }

    @Override
    public void removeLanguageListener() {
        I18n.removeOnLanguageChangedListener(this);
    }
}

