/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.sheet.editors;

import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.sheet.editors.ComboBoxEditor;
import com.jaspersoft.ireport.designer.sheet.editors.ComboBoxRenderer;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import net.sf.jasperreports.engine.TabStop;
import net.sf.jasperreports.engine.type.TabStopAlignEnum;
import org.jdesktop.layout.GroupLayout;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRTabStopsPropertyCustomEditor
extends JPanel
implements PropertyChangeListener {
    private PropertyEnv env;
    private PropertyEditor editor;
    private JButton jButtonDeleteProperty;
    private JButton jButtonNewProperty;
    private JPanel jPanel1;
    private JPanel jPanelButtons2;
    private JPanel jPanelFields;
    private JScrollPane jScrollPane3;
    private JTable jTableProperties;

    public JRTabStopsPropertyCustomEditor(Object value, PropertyEditor editor, PropertyEnv env) {
        this.env = env;
        this.editor = editor;
        this.env.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
        this.env.addPropertyChangeListener((PropertyChangeListener)this);
        this.initComponents();
        Tag[] tags = new Tag[]{new Tag(TabStopAlignEnum.LEFT.getValueByte(), I18n.getString("AbstractStyleNode.Property.Left")), new Tag(TabStopAlignEnum.CENTER.getValueByte(), I18n.getString("AbstractStyleNode.Property.Center")), new Tag(TabStopAlignEnum.RIGHT.getValueByte(), I18n.getString("AbstractStyleNode.Property.Right"))};
        this.jTableProperties.getColumnModel().getColumn(1).setCellEditor(new ComboBoxEditor(tags));
        this.jTableProperties.getColumnModel().getColumn(1).setCellRenderer(new ComboBoxRenderer(tags));
        DefaultListSelectionModel dlsm = (DefaultListSelectionModel)this.jTableProperties.getSelectionModel();
        dlsm.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                JRTabStopsPropertyCustomEditor.this.jTablePropertiesListSelectionValueChanged(e);
            }
        });
        if (value instanceof List && value != null) {
            this.setTabStops((List)value);
        }
    }

    private void initComponents() {
        this.jPanelFields = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.jTableProperties = new JTable();
        this.jPanelButtons2 = new JPanel();
        this.jButtonNewProperty = new JButton();
        this.jButtonDeleteProperty = new JButton();
        this.jPanel1 = new JPanel();
        this.jPanelFields.setLayout(new BorderLayout());
        this.jScrollPane3.setBackground(new Color(255, 255, 255));
        this.jScrollPane3.setPreferredSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.jScrollPane3.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                JRTabStopsPropertyCustomEditor.this.jScrollPane3MouseClicked(evt);
            }
        });
        this.jTableProperties.setModel(new DefaultTableModel(new Object[0][], new String[]{"Position", "Alignment"}){
            Class[] types;
            {
                this.types = new Class[]{Integer.class, Byte.class};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }
        });
        this.jTableProperties.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                JRTabStopsPropertyCustomEditor.this.jTablePropertiesMouseClicked(evt);
            }
        });
        this.jScrollPane3.setViewportView(this.jTableProperties);
        this.jPanelFields.add((Component)this.jScrollPane3, "Center");
        this.jPanelButtons2.setMinimumSize(new Dimension(100, 10));
        this.jPanelButtons2.setPreferredSize(new Dimension(100, 100));
        this.jPanelButtons2.setLayout(new GridBagLayout());
        this.jButtonNewProperty.setText(NbBundle.getMessage(JRTabStopsPropertyCustomEditor.class, (String)"JRTabStopsPropertyCustomEditor.jButtonNewProperty.text"));
        this.jButtonNewProperty.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRTabStopsPropertyCustomEditor.this.jButtonNewPropertyActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 4, 0, 4);
        this.jPanelButtons2.add((Component)this.jButtonNewProperty, gridBagConstraints);
        this.jButtonDeleteProperty.setText(NbBundle.getMessage(JRTabStopsPropertyCustomEditor.class, (String)"JRTabStopsPropertyCustomEditor.jButtonDeleteProperty.text"));
        this.jButtonDeleteProperty.setEnabled(false);
        this.jButtonDeleteProperty.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRTabStopsPropertyCustomEditor.this.jButtonDeletePropertyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanelButtons2.add((Component)this.jButtonDeleteProperty, gridBagConstraints);
        this.jPanel1.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weighty = 1.0;
        this.jPanelButtons2.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanelFields.add((Component)this.jPanelButtons2, "East");
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(0, 440, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(4, 4, 4).add((Component)this.jPanelFields, -1, 432, Short.MAX_VALUE).add(4, 4, 4))));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(0, 344, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(4, 4, 4).add((Component)this.jPanelFields, -1, 336, Short.MAX_VALUE).add(4, 4, 4))));
    }

    private void jTablePropertiesMouseClicked(MouseEvent evt) {
    }

    private void jScrollPane3MouseClicked(MouseEvent evt) {
    }

    private void jButtonNewPropertyActionPerformed(ActionEvent evt) {
        DefaultTableModel dtm = (DefaultTableModel)this.jTableProperties.getModel();
        Vector<Number> row = new Vector<Number>();
        row.addElement(0);
        row.addElement(TabStopAlignEnum.LEFT.getValue());
        dtm.addRow(row);
    }

    private void jButtonDeletePropertyActionPerformed(ActionEvent evt) {
        int[] rows = this.jTableProperties.getSelectedRows();
        DefaultTableModel dtm = (DefaultTableModel)this.jTableProperties.getModel();
        for (int i = rows.length - 1; i >= 0; --i) {
            dtm.removeRow(rows[i]);
        }
    }

    public void setTabStops(List<TabStop> tabStops) {
        DefaultTableModel dtm = (DefaultTableModel)this.jTableProperties.getModel();
        dtm.setRowCount(0);
        for (TabStop tabStop : tabStops) {
            Vector<Number> row = new Vector<Number>();
            row.addElement(tabStop.getPosition());
            row.addElement(tabStop.getAlignment().getValueByte());
            dtm.addRow(row);
        }
    }

    public List getTabStops() {
        ArrayList<TabStop> tabStops = new ArrayList<TabStop>();
        DefaultTableModel dtm = (DefaultTableModel)this.jTableProperties.getModel();
        for (int i = 0; i < dtm.getRowCount(); ++i) {
            if (dtm.getValueAt(i, 0) == null) continue;
            tabStops.add(new TabStop(((Integer)dtm.getValueAt(i, 0)).intValue(), TabStopAlignEnum.getByValue((Byte)((Byte)dtm.getValueAt(i, 1)))));
        }
        return tabStops;
    }

    private Object getPropertyValue() throws IllegalStateException {
        return this.getTabStops();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("state".equals(evt.getPropertyName()) && evt.getNewValue() == PropertyEnv.STATE_VALID) {
            this.editor.setValue(this.getPropertyValue());
        }
    }

    public void jTablePropertiesListSelectionValueChanged(ListSelectionEvent e) {
        if (this.jTableProperties.getSelectedRowCount() > 0) {
            this.jButtonDeleteProperty.setEnabled(true);
        } else {
            this.jButtonDeleteProperty.setEnabled(false);
        }
    }
}

