/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.oasis;

import java.text.AttributedCharacterIterator;
import java.util.Locale;
import java.util.Map;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.JRPrintGraphicElement;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.base.JRBaseLineBox;
import net.sf.jasperreports.engine.base.JRBoxPen;
import net.sf.jasperreports.engine.export.HyperlinkUtil;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.LengthUtil;
import net.sf.jasperreports.engine.export.oasis.DocumentBuilder;
import net.sf.jasperreports.engine.export.oasis.StyleCache;
import net.sf.jasperreports.engine.export.oasis.Utility;
import net.sf.jasperreports.engine.export.oasis.WriterHelper;
import net.sf.jasperreports.engine.type.LineDirectionEnum;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRTextAttribute;

public class TableBuilder {
    private final DocumentBuilder documentBuilder;
    private String tableName;
    private final JasperPrint jasperPrint;
    private int reportIndex;
    private final WriterHelper bodyWriter;
    private final WriterHelper styleWriter;
    private final StyleCache styleCache;
    private boolean isFrame;
    private boolean isPageBreak;

    protected TableBuilder(DocumentBuilder documentBuilder, JasperPrint jasperPrint, String name, WriterHelper bodyWriter, WriterHelper styleWriter, StyleCache styleCache) {
        this.documentBuilder = documentBuilder;
        this.jasperPrint = jasperPrint;
        this.isFrame = true;
        this.isPageBreak = false;
        this.bodyWriter = bodyWriter;
        this.styleWriter = styleWriter;
        this.styleCache = styleCache;
        this.tableName = "TBL_" + name;
    }

    protected TableBuilder(DocumentBuilder documentBuilder, JasperPrint jasperPrint, int reportIndex, int pageIndex, WriterHelper bodyWriter, WriterHelper styleWriter, StyleCache styleCache) {
        this.documentBuilder = documentBuilder;
        this.jasperPrint = jasperPrint;
        this.isFrame = false;
        this.isPageBreak = reportIndex != 0 || pageIndex != 0;
        this.reportIndex = reportIndex;
        this.bodyWriter = bodyWriter;
        this.styleWriter = styleWriter;
        this.styleCache = styleCache;
        this.tableName = "TBL_" + reportIndex + "_" + pageIndex;
    }

    public void buildTableStyle(int width) {
        this.styleWriter.write(" <style:style style:name=\"" + this.tableName + "\"");
        if (!this.isFrame) {
            this.styleWriter.write(" style:master-page-name=\"master_" + this.reportIndex + "\"");
        }
        this.styleWriter.write(" style:family=\"table\">\n");
        this.styleWriter.write("   <style:table-properties");
        this.styleWriter.write(" table:align=\"left\" style:width=\"" + LengthUtil.inch(width) + "in\"");
        if (this.isPageBreak) {
            this.styleWriter.write(" fo:break-before=\"page\"");
        }
        this.styleWriter.write("/>\n");
        this.styleWriter.write(" </style:style>\n");
    }

    public void buildTableHeader() {
        this.bodyWriter.write("<table:table");
        if (this.isFrame) {
            this.bodyWriter.write(" is-subtable=\"true\"");
        }
        this.bodyWriter.write(" table:name=\"");
        this.bodyWriter.write(this.tableName);
        this.bodyWriter.write("\"");
        this.bodyWriter.write(" table:style-name=\"");
        this.bodyWriter.write(this.tableName);
        this.bodyWriter.write("\"");
        this.bodyWriter.write(">\n");
    }

    public void buildTableFooter() {
        this.bodyWriter.write("</table:table>\n");
    }

    public void buildRowStyle(int rowIndex, int rowHeight) {
        String rowName = this.tableName + "_row_" + rowIndex;
        this.styleWriter.write(" <style:style style:name=\"" + rowName + "\"");
        this.styleWriter.write(" style:family=\"table-row\">\n");
        this.styleWriter.write("   <style:table-row-properties");
        if (rowHeight < 0) {
            this.styleWriter.write(" style:use-optimal-row-height=\"true\"");
        } else {
            this.styleWriter.write(" style:use-optimal-row-height=\"false\"");
            this.styleWriter.write(" style:row-height=\"" + LengthUtil.inch(rowHeight) + "in\"");
        }
        this.styleWriter.write("/>\n");
        this.styleWriter.write(" </style:style>\n");
    }

    public void buildRowHeader(int rowIndex) {
        String rowName = this.tableName + "_row_" + rowIndex;
        this.bodyWriter.write("<table:table-row");
        this.bodyWriter.write(" table:style-name=\"" + rowName + "\"");
        this.bodyWriter.write(">\n");
    }

    public void buildRowFooter() {
        this.bodyWriter.write("</table:table-row>\n");
    }

    public void buildRow(int rowIndex) {
        if (rowIndex > 0) {
            this.buildRowFooter();
        }
        this.buildRowHeader(rowIndex);
    }

    public void buildColumnStyle(int colIndex, int colWidth) {
        String columnName = this.tableName + "_col_" + colIndex;
        this.styleWriter.write(" <style:style style:name=\"" + columnName + "\"");
        this.styleWriter.write(" style:family=\"table-column\">\n");
        this.styleWriter.write("   <style:table-column-properties");
        this.styleWriter.write(" style:column-width=\"" + LengthUtil.inch(colWidth) + "in\"");
        this.styleWriter.write("/>\n");
        this.styleWriter.write(" </style:style>\n");
    }

    public void buildColumnHeader(int colIndex) {
        String columnName = this.tableName + "_col_" + colIndex;
        this.bodyWriter.write("<table:table-column");
        this.bodyWriter.write(" table:style-name=\"" + columnName + "\"");
        this.bodyWriter.write(">\n");
    }

    public void buildColumnFooter() {
        this.bodyWriter.write("</table:table-column>\n");
    }

    public void buildCellHeader(String cellStyleName, int colSpan, int rowSpan) {
        this.bodyWriter.write("<table:table-cell");
        if (cellStyleName != null) {
            this.bodyWriter.write(" table:style-name=\"" + cellStyleName + "\"");
        }
        if (colSpan > 1) {
            this.bodyWriter.write(" table:number-columns-spanned=\"" + colSpan + "\"");
        }
        if (rowSpan > 1) {
            this.bodyWriter.write(" table:number-rows-spanned=\"" + rowSpan + "\"");
        }
        this.bodyWriter.write(">\n");
    }

    public void buildCellFooter() {
        this.bodyWriter.write("</table:table-cell>\n");
    }

    public void exportRectangle(JRPrintGraphicElement rectangle, JRExporterGridCell gridCell) {
        JRBaseLineBox box = new JRBaseLineBox(null);
        JRBoxPen pen = box.getPen();
        pen.setLineColor(rectangle.getLinePen().getLineColor());
        pen.setLineStyle(rectangle.getLinePen().getLineStyleValue());
        pen.setLineWidth(rectangle.getLinePen().getLineWidth());
        gridCell.setBox(box);
        this.buildCellHeader(this.styleCache.getCellStyle(gridCell), gridCell.getColSpan(), gridCell.getRowSpan());
        this.buildCellFooter();
    }

    public void exportLine(JRPrintLine line, JRExporterGridCell gridCell) {
        double y2;
        double x2;
        double y1;
        double x1;
        this.buildCellHeader(null, gridCell.getColSpan(), gridCell.getRowSpan());
        if (line.getDirectionValue() == LineDirectionEnum.TOP_DOWN) {
            x1 = LengthUtil.inch(0.0);
            y1 = LengthUtil.inch(0.0);
            x2 = LengthUtil.inch(line.getWidth() - 1);
            y2 = LengthUtil.inch(line.getHeight() - 1);
        } else {
            x1 = LengthUtil.inch(0.0);
            y1 = LengthUtil.inch(line.getHeight() - 1);
            x2 = LengthUtil.inch(line.getWidth() - 1);
            y2 = LengthUtil.inch(0.0);
        }
        this.bodyWriter.write("<text:p>");
        this.documentBuilder.insertPageAnchor(this);
        this.bodyWriter.write("<draw:line text:anchor-type=\"paragraph\" draw:style-name=\"" + this.styleCache.getGraphicStyle(line) + "\" " + "svg:x1=\"" + x1 + "in\" " + "svg:y1=\"" + y1 + "in\" " + "svg:x2=\"" + x2 + "in\" " + "svg:y2=\"" + y2 + "in\">" + "<text:p/></draw:line>" + "</text:p>");
        this.buildCellFooter();
    }

    public void exportEllipse(JRPrintEllipse ellipse, JRExporterGridCell gridCell) {
        this.buildCellHeader(null, gridCell.getColSpan(), gridCell.getRowSpan());
        this.bodyWriter.write("<text:p>");
        this.documentBuilder.insertPageAnchor(this);
        this.bodyWriter.write("<draw:ellipse text:anchor-type=\"paragraph\" draw:style-name=\"" + this.styleCache.getGraphicStyle(ellipse) + "\" " + "svg:width=\"" + LengthUtil.inch(ellipse.getWidth()) + "in\" " + "svg:height=\"" + LengthUtil.inch(ellipse.getHeight()) + "in\" " + "svg:x=\"0in\" " + "svg:y=\"0in\">" + "<text:p/></draw:ellipse></text:p>");
        this.buildCellFooter();
    }

    public void exportText(JRPrintText text, JRExporterGridCell gridCell) {
        this.buildCellHeader(this.styleCache.getCellStyle(gridCell), gridCell.getColSpan(), gridCell.getRowSpan());
        this.bodyWriter.write("<text:p text:style-name=\"");
        this.bodyWriter.write(this.styleCache.getParagraphStyle(text));
        this.bodyWriter.write("\">");
        this.documentBuilder.insertPageAnchor(this);
        if (text.getAnchorName() != null) {
            this.exportAnchor(JRStringUtil.xmlEncode(text.getAnchorName()));
        }
        this.exportTextContents(text);
        this.bodyWriter.write("</text:p>\n");
        this.buildCellFooter();
    }

    protected void exportTextContents(JRPrintText text) {
        boolean startedHyperlink = this.startHyperlink(text, true);
        this.exportStyledText(text, startedHyperlink);
        if (startedHyperlink) {
            this.endHyperlink(true);
        }
    }

    protected void exportStyledText(JRPrintText text, boolean startedHyperlink) {
        JRStyledText styledText = this.documentBuilder.getStyledText(text);
        if (styledText != null && styledText.length() > 0) {
            this.exportStyledText(styledText, this.documentBuilder.getTextLocale(text), startedHyperlink);
        }
    }

    protected void exportStyledText(JRStyledText styledText, Locale locale, boolean startedHyperlink) {
        String text = styledText.getText();
        int runLimit = 0;
        AttributedCharacterIterator iterator = styledText.getAttributedString().getIterator();
        while (runLimit < styledText.length() && (runLimit = iterator.getRunLimit()) <= styledText.length()) {
            this.exportStyledTextRun(iterator.getAttributes(), text.substring(iterator.getIndex(), runLimit), locale, startedHyperlink);
            iterator.setIndex(runLimit);
        }
    }

    protected void exportStyledTextRun(Map<AttributedCharacterIterator.Attribute, Object> attributes, String text, Locale locale, boolean startedHyperlink) {
        JRPrintHyperlink hyperlink;
        this.startTextSpan(attributes, text, locale);
        boolean localHyperlink = false;
        if (!startedHyperlink && (hyperlink = (JRPrintHyperlink)attributes.get(JRTextAttribute.HYPERLINK)) != null) {
            localHyperlink = this.startHyperlink(hyperlink, true);
        }
        this.writeText(text);
        if (localHyperlink) {
            this.endHyperlink(true);
        }
        this.endTextSpan();
    }

    protected void startTextSpan(Map<AttributedCharacterIterator.Attribute, Object> attributes, String text, Locale locale) {
        String textSpanStyleName = this.styleCache.getTextSpanStyle(attributes, text, locale);
        this.bodyWriter.write("<text:span");
        this.bodyWriter.write(" text:style-name=\"" + textSpanStyleName + "\"");
        this.bodyWriter.write(">");
    }

    protected void endTextSpan() {
        this.bodyWriter.write("</text:span>");
    }

    protected void writeText(String text) {
        if (text != null) {
            this.bodyWriter.write(Utility.replaceNewLineWithLineBreak(JRStringUtil.xmlEncode(text, this.documentBuilder.getInvalidCharReplacement())));
        }
    }

    protected void exportAnchor(String anchorName) {
        this.bodyWriter.write("<text:bookmark text:name=\"");
        this.bodyWriter.write(anchorName);
        this.bodyWriter.write("\"/>");
    }

    protected String getIgnoreHyperlinkProperty() {
        return "net.sf.jasperreports.export.odt.ignore.hyperlink";
    }

    protected boolean startHyperlink(JRPrintHyperlink link, boolean isText) {
        String href = null;
        String ignLnkPropName = this.getIgnoreHyperlinkProperty();
        Boolean ignoreHyperlink = HyperlinkUtil.getIgnoreHyperlink(ignLnkPropName, link);
        if (ignoreHyperlink == null) {
            ignoreHyperlink = JRPropertiesUtil.getInstance(this.getJasperReportsContext()).getBooleanProperty(this.jasperPrint, ignLnkPropName, false);
        }
        if (!ignoreHyperlink.booleanValue()) {
            href = this.documentBuilder.getHyperlinkURL(link);
        }
        if (href != null) {
            this.writeHyperlink(link, href, isText);
        }
        return href != null;
    }

    protected void writeHyperlink(JRPrintHyperlink link, String href, boolean isText) {
        if (isText) {
            this.bodyWriter.write("<text:a xlink:href=\"");
        } else {
            this.bodyWriter.write("<draw:a xlink:type=\"simple\" xlink:href=\"");
        }
        this.bodyWriter.write(JRStringUtil.xmlEncode(href));
        this.bodyWriter.write("\"");
        String target = this.getHyperlinkTarget(link);
        if (target != null) {
            this.bodyWriter.write(" office:target-frame-name=\"");
            this.bodyWriter.write(target);
            this.bodyWriter.write("\"");
            if (target.equals("_blank")) {
                this.bodyWriter.write(" xlink:show=\"new\"");
            }
        }
        this.bodyWriter.write(">");
    }

    protected void endHyperlink(boolean isText) {
        if (isText) {
            this.bodyWriter.write("</text:a>");
        } else {
            this.bodyWriter.write("</draw:a>");
        }
    }

    protected String getHyperlinkTarget(JRPrintHyperlink link) {
        String target = null;
        switch (link.getHyperlinkTargetValue()) {
            case SELF: {
                target = "_self";
                break;
            }
            default: {
                target = "_blank";
            }
        }
        return target;
    }

    protected float getXAlignFactor(JRPrintImage image) {
        float xalignFactor = 0.0f;
        switch (image.getHorizontalAlignmentValue()) {
            case RIGHT: {
                xalignFactor = 1.0f;
                break;
            }
            case CENTER: {
                xalignFactor = 0.5f;
                break;
            }
            default: {
                xalignFactor = 0.0f;
            }
        }
        return xalignFactor;
    }

    protected float getYAlignFactor(JRPrintImage image) {
        float yalignFactor = 0.0f;
        switch (image.getVerticalAlignmentValue()) {
            case BOTTOM: {
                yalignFactor = 1.0f;
                break;
            }
            case MIDDLE: {
                yalignFactor = 0.5f;
                break;
            }
            default: {
                yalignFactor = 0.0f;
            }
        }
        return yalignFactor;
    }

    protected JasperReportsContext getJasperReportsContext() {
        return this.documentBuilder.getJasperReportsContext();
    }
}

