/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.util.List;
import java.util.Locale;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.util.LocalizedMessageProvider;
import net.sf.jasperreports.engine.util.MessageProvider;
import net.sf.jasperreports.engine.util.MessageProviderFactory;

public final class MessageUtil {
    private final JasperReportsContext jasperReportsContext;

    private MessageUtil(JasperReportsContext jasperReportsContext) {
        this.jasperReportsContext = jasperReportsContext;
    }

    public static final MessageUtil getInstance(JasperReportsContext jasperReportsContext) {
        return new MessageUtil(jasperReportsContext);
    }

    public MessageProvider getMessageProvider(String name) {
        List<MessageProviderFactory> factories = this.jasperReportsContext.getExtensions(MessageProviderFactory.class);
        for (MessageProviderFactory factory : factories) {
            MessageProvider provider = factory.getMessageProvider(name);
            if (provider == null) continue;
            return provider;
        }
        throw new JRRuntimeException("Message provider '" + name + "' not found.");
    }

    public LocalizedMessageProvider getLocalizedMessageProvider(String name, Locale locale) {
        return new LocalizedMessageProvider(this.getMessageProvider(name), locale);
    }
}

