/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.util.FileResolver;

public class SimpleFileResolver
implements FileResolver {
    private List<File> folders;
    private boolean isResolveAbsolutePath;

    public SimpleFileResolver(File parentFolder) {
        this.folders = new ArrayList<File>();
        this.folders.add(parentFolder);
    }

    public SimpleFileResolver(List<File> parentFolders) {
        this.folders = parentFolders;
    }

    public List<File> getFolders() {
        return this.folders;
    }

    public boolean isResolveAbsolutePath() {
        return this.isResolveAbsolutePath;
    }

    public void setResolveAbsolutePath(boolean isResolveAbsolutePath) {
        this.isResolveAbsolutePath = isResolveAbsolutePath;
    }

    @Override
    public File resolveFile(String fileName) {
        if (fileName != null) {
            File file;
            for (File folder : this.folders) {
                File file2 = new File(folder, fileName);
                if (!file2.exists() || !file2.isFile()) continue;
                return file2;
            }
            if (this.isResolveAbsolutePath && (file = new File(fileName)).exists() && file.isFile()) {
                return file;
            }
        }
        return null;
    }
}

