/*
 * Decompiled with CFR 0.152.
 */
package rex.graphics.dimensiontree.elements;

import javax.swing.ImageIcon;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import rex.graphics.dimensiontree.elements.DimensionTreeElement;
import rex.metadata.ServerMetadata;
import rex.utils.DOM;
import rex.utils.I18n;
import rex.utils.S;
import rex.xmla.XMLADiscoverProperties;
import rex.xmla.XMLADiscoverRestrictions;

public class DimensionElement
implements DimensionTreeElement {
    private String catalogName;
    private String schemaName;
    private String cubeName;
    private String dimensionName;
    private String dimensionUniqueName;
    private String dimensionGuid;
    private String dimensionCaption;
    private int dimensionOrdinal;
    private short dimensionType;
    private int dimensionCardinality;
    private String defaultHierarchy;
    private String description;
    private boolean isVirtual;
    private boolean isReadwrite;
    private int dimensionUniqueSettings;
    private String dimensionMasterUniqueName;
    private boolean dimensionIsVisible;
    private boolean nodeEnabled;
    private XMLADiscoverRestrictions restrictions;
    private XMLADiscoverProperties properties;
    private ServerMetadata parent;
    private boolean flattenDimensions;
    public static short DIMENSION_TYPE_TIME = 1;
    public static short DIMENSION_TYPE_MEASURE = (short)2;
    public static short DIMENSION_TYPE_REGULAR = (short)3;
    static int DIMENSION_CARDINALITY_NOT_INITIALIZED = -1;
    static ImageIcon iconRegular = S.getAppIcon("dimension.gif");
    static ImageIcon iconTime = S.getAppIcon("time_dimension.gif");
    static ImageIcon iconMeasure = S.getAppIcon("measure_dimension.gif");

    public DimensionElement(ServerMetadata svm, Node rowNode, XMLADiscoverRestrictions _restrictions, XMLADiscoverProperties _properties) {
        this.parent = svm;
        this.nodeEnabled = true;
        this.restrictions = _restrictions;
        this.properties = _properties;
        this.dimensionCardinality = DIMENSION_CARDINALITY_NOT_INITIALIZED;
        NodeList nl = rowNode.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (nl.item(i).getNodeType() != 1) continue;
            if (nl.item(i).getNodeName().equals("CATALOG_NAME")) {
                this.catalogName = DOM.getTextFromDOMElement(nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equals("SCHEMA_NAME")) {
                this.schemaName = DOM.getTextFromDOMElement(nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equals("CUBE_NAME")) {
                this.cubeName = DOM.getTextFromDOMElement(nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equals("DIMENSION_NAME")) {
                this.dimensionName = DOM.getTextFromDOMElement(nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equals("DIMENSION_UNIQUE_NAME")) {
                this.dimensionUniqueName = DOM.getTextFromDOMElement(nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equals("DIMENSION_GUID")) {
                this.dimensionGuid = DOM.getTextFromDOMElement(nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equals("DIMENSION_CAPTION")) {
                this.dimensionCaption = DOM.getTextFromDOMElement(nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equals("DIMENSION_ORDINAL")) {
                this.dimensionOrdinal = Integer.parseInt(DOM.getTextFromDOMElement(nl.item(i)));
                continue;
            }
            if (nl.item(i).getNodeName().equals("DIMENSION_TYPE")) {
                this.dimensionType = Short.parseShort(DOM.getTextFromDOMElement(nl.item(i)));
                continue;
            }
            if (nl.item(i).getNodeName().equals("DIMENSION_CARDINALITY")) {
                this.dimensionCardinality = Integer.parseInt(DOM.getTextFromDOMElement(nl.item(i)));
                continue;
            }
            if (nl.item(i).getNodeName().equals("DEFAULT_HIERARCHY")) {
                this.defaultHierarchy = DOM.getTextFromDOMElement(nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equals("DESCRIPTION")) {
                this.description = DOM.getTextFromDOMElement(nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equals("IS_VIRTUAL")) {
                this.isVirtual = Boolean.valueOf(DOM.getTextFromDOMElement(nl.item(i)));
                continue;
            }
            if (nl.item(i).getNodeName().equals("IS_READWRITE")) {
                this.isReadwrite = Boolean.valueOf(DOM.getTextFromDOMElement(nl.item(i)));
                continue;
            }
            if (nl.item(i).getNodeName().equals("DIMENSION_UNIQUE_SETTINGS")) {
                this.dimensionUniqueSettings = Integer.parseInt(DOM.getTextFromDOMElement(nl.item(i)));
                continue;
            }
            if (nl.item(i).getNodeName().equals("DIMENSION_MASTER_UNIQUE_NAME")) {
                this.dimensionMasterUniqueName = DOM.getTextFromDOMElement(nl.item(i));
                continue;
            }
            if (!nl.item(i).getNodeName().equals("DIMENSION_IS_VISIBLE")) continue;
            this.dimensionIsVisible = Boolean.valueOf(DOM.getTextFromDOMElement(nl.item(i)));
        }
    }

    public DimensionElement(ServerMetadata svm, XMLADiscoverRestrictions _restrictions, XMLADiscoverProperties _properties, String _catalogName, String _cubeName, String _dimensionName, String _dimensionUniqueName, String _dimensionCaption) {
        this.parent = svm;
        this.nodeEnabled = true;
        this.restrictions = _restrictions;
        this.properties = _properties;
        this.catalogName = _catalogName;
        this.cubeName = _cubeName;
        this.dimensionName = _dimensionName;
        this.dimensionUniqueName = _dimensionUniqueName;
        this.dimensionCaption = _dimensionCaption;
    }

    @Override
    public DimensionTreeElement[] getChildren(boolean noMatterWhat) {
        this.restrictions.setDimensionUniqueName(this.dimensionUniqueName);
        this.restrictions.setHierarchyUniqueName(null);
        if (this.flattenDimensions) {
            return this.parent.getLevelList(this.restrictions, this.properties);
        }
        return this.parent.getHierarchyList(this.restrictions, this.properties);
    }

    public void setFlattenDimensions(boolean _flattenDimensions) {
        this.flattenDimensions = _flattenDimensions;
    }

    public boolean getFlattenDimensions() {
        return this.flattenDimensions;
    }

    @Override
    public String toString() {
        if (this.dimensionCaption == null) {
            return I18n.getString("toolTip.notInitialzed");
        }
        if (this.flattenDimensions) {
            return this.dimensionCaption;
        }
        return this.dimensionCaption;
    }

    @Override
    public ImageIcon getIcon() {
        if (this.isMeasureDimension()) {
            return iconMeasure;
        }
        if (this.isTimeDimension()) {
            return iconTime;
        }
        return iconRegular;
    }

    public static ImageIcon getDimensionIcon() {
        return iconRegular;
    }

    @Override
    public String getToolTip() {
        if (this.dimensionName == null) {
            return I18n.getString("toolTip.notInitialzed");
        }
        return "<html>" + I18n.getString("toolTip.dimensionName") + this.dimensionName + "<br>" + I18n.getString("toolTip.caption") + this.dimensionCaption + "<br>" + I18n.getString("toolTip.dimensionUniqueName") + this.dimensionUniqueName + "<html>";
    }

    @Override
    public String[] getPopUpActionList() {
        return null;
    }

    @Override
    public String getUniqueName() {
        return this.dimensionUniqueName;
    }

    @Override
    public String getDimensionUniqueName() {
        return this.dimensionUniqueName;
    }

    @Override
    public String getCaption() {
        return this.dimensionCaption;
    }

    @Override
    public boolean isEnabled() {
        return this.nodeEnabled;
    }

    @Override
    public void setEnabled(boolean newValue) {
        this.nodeEnabled = newValue;
    }

    public boolean isMeasureDimension() {
        return this.dimensionType == DIMENSION_TYPE_MEASURE;
    }

    public boolean isTimeDimension() {
        return this.dimensionType == DIMENSION_TYPE_TIME;
    }

    @Override
    public int getChildrenCount() {
        if (this.dimensionCardinality == DIMENSION_CARDINALITY_NOT_INITIALIZED) {
            DimensionTreeElement[] list = this.getChildren(true);
            this.dimensionCardinality = list == null ? 0 : list.length;
        }
        return this.dimensionCardinality;
    }

    @Override
    public ServerMetadata getServerMetadata() {
        return this.parent;
    }

    @Override
    public XMLADiscoverRestrictions getRestrictions() {
        return this.restrictions;
    }

    @Override
    public XMLADiscoverProperties getProperties() {
        return this.properties;
    }
}

