/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.IOException;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.HiveKey;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.util.Progressable;

public class HiveNullValueSequenceFileOutputFormat
extends SequenceFileOutputFormat
implements HiveOutputFormat<WritableComparable, Writable> {
    private static final Writable NULL_WRITABLE = NullWritable.get();
    private HiveKey keyWritable;
    private boolean keyIsText;

    @Override
    public FileSinkOperator.RecordWriter getHiveRecordWriter(JobConf jc, Path finalOutPath, Class<? extends Writable> valueClass, boolean isCompressed, Properties tableProperties, Progressable progress) throws IOException {
        FileSystem fs = finalOutPath.getFileSystem((Configuration)jc);
        final SequenceFile.Writer outStream = Utilities.createSequenceWriter(jc, fs, finalOutPath, HiveKey.class, NullWritable.class, isCompressed);
        this.keyWritable = new HiveKey();
        this.keyIsText = valueClass.equals(Text.class);
        return new FileSinkOperator.RecordWriter(){

            @Override
            public void write(Writable r) throws IOException {
                if (HiveNullValueSequenceFileOutputFormat.this.keyIsText) {
                    Text text = (Text)r;
                    HiveNullValueSequenceFileOutputFormat.this.keyWritable.set(text.getBytes(), 0, text.getLength());
                } else {
                    BytesWritable bw = (BytesWritable)r;
                    HiveNullValueSequenceFileOutputFormat.this.keyWritable.set(bw.get(), 0, bw.getSize());
                }
                HiveNullValueSequenceFileOutputFormat.this.keyWritable.setHashCode(r.hashCode());
                outStream.append((Writable)HiveNullValueSequenceFileOutputFormat.this.keyWritable, NULL_WRITABLE);
            }

            @Override
            public void close(boolean abort) throws IOException {
                outStream.close();
            }
        };
    }
}

