/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

public class IOContext {
    private static ThreadLocal<IOContext> threadLocal = new ThreadLocal<IOContext>(){

        @Override
        protected synchronized IOContext initialValue() {
            return new IOContext();
        }
    };
    long currentBlockStart = 0L;
    long nextBlockStart = -1L;
    long currentRow = 0L;
    boolean isBlockPointer = true;
    boolean ioExceptions = false;
    boolean useSorted = false;
    boolean isBinarySearching = false;
    boolean endBinarySearch = false;
    Comparison comparison = null;
    String genericUDFClassName = null;
    String inputFile;

    public static IOContext get() {
        return threadLocal.get();
    }

    public long getCurrentBlockStart() {
        return this.currentBlockStart;
    }

    public void setCurrentBlockStart(long currentBlockStart) {
        this.currentBlockStart = currentBlockStart;
    }

    public long getNextBlockStart() {
        return this.nextBlockStart;
    }

    public void setNextBlockStart(long nextBlockStart) {
        this.nextBlockStart = nextBlockStart;
    }

    public long getCurrentRow() {
        return this.currentRow;
    }

    public void setCurrentRow(long currentRow) {
        this.currentRow = currentRow;
    }

    public boolean isBlockPointer() {
        return this.isBlockPointer;
    }

    public void setBlockPointer(boolean isBlockPointer) {
        this.isBlockPointer = isBlockPointer;
    }

    public String getInputFile() {
        return this.inputFile;
    }

    public void setInputFile(String inputFile) {
        this.inputFile = inputFile;
    }

    public void setIOExceptions(boolean ioe) {
        this.ioExceptions = ioe;
    }

    public boolean getIOExceptions() {
        return this.ioExceptions;
    }

    public boolean useSorted() {
        return this.useSorted;
    }

    public void setUseSorted(boolean useSorted) {
        this.useSorted = useSorted;
    }

    public boolean isBinarySearching() {
        return this.isBinarySearching;
    }

    public void setIsBinarySearching(boolean isBinarySearching) {
        this.isBinarySearching = isBinarySearching;
    }

    public boolean shouldEndBinarySearch() {
        return this.endBinarySearch;
    }

    public void setEndBinarySearch(boolean endBinarySearch) {
        this.endBinarySearch = endBinarySearch;
    }

    public Comparison getComparison() {
        return this.comparison;
    }

    public void setComparison(Integer comparison) {
        if (comparison == null && this.isBinarySearching) {
            this.endBinarySearch = true;
        } else {
            this.comparison = comparison == null ? Comparison.UNKNOWN : (comparison < 0 ? Comparison.LESS : (comparison > 0 ? Comparison.GREATER : Comparison.EQUAL));
        }
    }

    public String getGenericUDFClassName() {
        return this.genericUDFClassName;
    }

    public void setGenericUDFClassName(String genericUDFClassName) {
        this.genericUDFClassName = genericUDFClassName;
    }

    public void resetSortingValues() {
        this.useSorted = false;
        this.isBinarySearching = false;
        this.endBinarySearch = false;
        this.comparison = null;
        this.genericUDFClassName = null;
    }

    public static enum Comparison {
        GREATER,
        LESS,
        EQUAL,
        UNKNOWN;

    }
}

