/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.physical;

import java.io.Serializable;
import java.util.Stack;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.optimizer.physical.GenMRSkewJoinProcessor;
import org.apache.hadoop.hive.ql.optimizer.physical.SkewJoinResolver;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;

public final class SkewJoinProcFactory {
    public static NodeProcessor getDefaultProc() {
        return new SkewJoinDefaultProcessor();
    }

    public static NodeProcessor getJoinProc() {
        return new SkewJoinJoinProcessor();
    }

    private SkewJoinProcFactory() {
    }

    public static class SkewJoinDefaultProcessor
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            return null;
        }
    }

    public static class SkewJoinJoinProcessor
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            SkewJoinResolver.SkewJoinProcCtx context = (SkewJoinResolver.SkewJoinProcCtx)ctx;
            JoinOperator op = (JoinOperator)nd;
            ParseContext parseContext = context.getParseCtx();
            Task<? extends Serializable> currentTsk = context.getCurrentTask();
            GenMRSkewJoinProcessor.processSkewJoin(op, currentTsk, parseContext);
            return null;
        }
    }
}

