/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.unionproc;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.PreOrderWalker;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.optimizer.Transform;
import org.apache.hadoop.hive.ql.optimizer.unionproc.UnionProcContext;
import org.apache.hadoop.hive.ql.optimizer.unionproc.UnionProcFactory;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;

public class UnionProcessor
implements Transform {
    @Override
    public ParseContext transform(ParseContext pCtx) throws SemanticException {
        LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
        opRules.put(new RuleRegExp("R1", "RS%.*UNION%"), UnionProcFactory.getMapRedUnion());
        opRules.put(new RuleRegExp("R2", "UNION%.*UNION%"), UnionProcFactory.getUnknownUnion());
        opRules.put(new RuleRegExp("R3", "TS%.*UNION%"), UnionProcFactory.getMapUnion());
        opRules.put(new RuleRegExp("R3", "MAPJOIN%.*UNION%"), UnionProcFactory.getMapJoinUnion());
        UnionProcContext uCtx = new UnionProcContext();
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(UnionProcFactory.getNoUnion(), opRules, uCtx);
        PreOrderWalker ogw = new PreOrderWalker(disp);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(pCtx.getTopOps().values());
        ogw.startWalking(topNodes, null);
        pCtx.setUCtx(uCtx);
        return pCtx;
    }
}

