/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.JoinCondDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;

@Explain(displayName="Join Operator")
public class JoinDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int INNER_JOIN = 0;
    public static final int LEFT_OUTER_JOIN = 1;
    public static final int RIGHT_OUTER_JOIN = 2;
    public static final int FULL_OUTER_JOIN = 3;
    public static final int UNIQUE_JOIN = 4;
    public static final int LEFT_SEMI_JOIN = 5;
    private boolean handleSkewJoin = false;
    private int skewKeyDefinition = -1;
    private Map<Byte, String> bigKeysDirMap;
    private Map<Byte, Map<Byte, String>> smallKeysDirMap;
    private Map<Byte, TableDesc> skewKeysValuesTables;
    private Map<Byte, List<ExprNodeDesc>> exprs;
    private Map<Byte, List<ExprNodeDesc>> filters;
    protected List<String> outputColumnNames;
    private transient Map<String, Byte> reversedExprs;
    protected boolean noOuterJoin;
    protected JoinCondDesc[] conds;
    protected Byte[] tagOrder;
    private TableDesc keyTableDesc;

    public JoinDesc() {
    }

    public JoinDesc(Map<Byte, List<ExprNodeDesc>> exprs, List<String> outputColumnNames, boolean noOuterJoin, JoinCondDesc[] conds, Map<Byte, List<ExprNodeDesc>> filters) {
        this.exprs = exprs;
        this.outputColumnNames = outputColumnNames;
        this.noOuterJoin = noOuterJoin;
        this.conds = conds;
        this.filters = filters;
        this.tagOrder = new Byte[exprs.size()];
        for (int i = 0; i < this.tagOrder.length; ++i) {
            this.tagOrder[i] = (byte)i;
        }
    }

    public JoinDesc(Map<Byte, List<ExprNodeDesc>> exprs, List<String> outputColumnNames, boolean noOuterJoin, JoinCondDesc[] conds) {
        this(exprs, outputColumnNames, noOuterJoin, conds, null);
    }

    public JoinDesc(Map<Byte, List<ExprNodeDesc>> exprs, List<String> outputColumnNames) {
        this(exprs, outputColumnNames, true, null);
    }

    public JoinDesc(Map<Byte, List<ExprNodeDesc>> exprs, List<String> outputColumnNames, JoinCondDesc[] conds) {
        this(exprs, outputColumnNames, true, conds, null);
    }

    public JoinDesc(JoinDesc clone) {
        this.bigKeysDirMap = clone.bigKeysDirMap;
        this.conds = clone.conds;
        this.exprs = clone.exprs;
        this.handleSkewJoin = clone.handleSkewJoin;
        this.keyTableDesc = clone.keyTableDesc;
        this.noOuterJoin = clone.noOuterJoin;
        this.outputColumnNames = clone.outputColumnNames;
        this.reversedExprs = clone.reversedExprs;
        this.skewKeyDefinition = clone.skewKeyDefinition;
        this.skewKeysValuesTables = clone.skewKeysValuesTables;
        this.smallKeysDirMap = clone.smallKeysDirMap;
        this.tagOrder = clone.tagOrder;
        this.filters = clone.filters;
    }

    public Map<Byte, List<ExprNodeDesc>> getExprs() {
        return this.exprs;
    }

    public Map<String, Byte> getReversedExprs() {
        return this.reversedExprs;
    }

    public void setReversedExprs(Map<String, Byte> reversedExprs) {
        this.reversedExprs = reversedExprs;
    }

    @Explain(displayName="condition expressions")
    public Map<Byte, String> getExprsStringMap() {
        if (this.getExprs() == null) {
            return null;
        }
        LinkedHashMap<Byte, String> ret = new LinkedHashMap<Byte, String>();
        for (Map.Entry<Byte, List<ExprNodeDesc>> ent : this.getExprs().entrySet()) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            if (ent.getValue() != null) {
                for (ExprNodeDesc expr : ent.getValue()) {
                    if (!first) {
                        sb.append(" ");
                    }
                    first = false;
                    sb.append("{");
                    sb.append(expr.getExprString());
                    sb.append("}");
                }
            }
            ret.put(ent.getKey(), sb.toString());
        }
        return ret;
    }

    public void setExprs(Map<Byte, List<ExprNodeDesc>> exprs) {
        this.exprs = exprs;
    }

    @Explain(displayName="filter predicates")
    public Map<Byte, String> getFiltersStringMap() {
        if (this.getFilters() == null || this.getFilters().size() == 0) {
            return null;
        }
        LinkedHashMap<Byte, String> ret = new LinkedHashMap<Byte, String>();
        boolean filtersPresent = false;
        for (Map.Entry<Byte, List<ExprNodeDesc>> ent : this.getFilters().entrySet()) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            if (ent.getValue() != null) {
                if (ent.getValue().size() != 0) {
                    filtersPresent = true;
                }
                for (ExprNodeDesc expr : ent.getValue()) {
                    if (!first) {
                        sb.append(" ");
                    }
                    first = false;
                    sb.append("{");
                    sb.append(expr.getExprString());
                    sb.append("}");
                }
            }
            ret.put(ent.getKey(), sb.toString());
        }
        if (filtersPresent) {
            return ret;
        }
        return null;
    }

    public Map<Byte, List<ExprNodeDesc>> getFilters() {
        return this.filters;
    }

    public void setFilters(Map<Byte, List<ExprNodeDesc>> filters) {
        this.filters = filters;
    }

    @Explain(displayName="outputColumnNames")
    public List<String> getOutputColumnNames() {
        return this.outputColumnNames;
    }

    public void setOutputColumnNames(List<String> outputColumnNames) {
        this.outputColumnNames = outputColumnNames;
    }

    public boolean getNoOuterJoin() {
        return this.noOuterJoin;
    }

    public void setNoOuterJoin(boolean noOuterJoin) {
        this.noOuterJoin = noOuterJoin;
    }

    @Explain(displayName="condition map")
    public List<JoinCondDesc> getCondsList() {
        if (this.conds == null) {
            return null;
        }
        ArrayList<JoinCondDesc> l = new ArrayList<JoinCondDesc>();
        for (JoinCondDesc cond : this.conds) {
            l.add(cond);
        }
        return l;
    }

    public JoinCondDesc[] getConds() {
        return this.conds;
    }

    public void setConds(JoinCondDesc[] conds) {
        this.conds = conds;
    }

    public Byte[] getTagOrder() {
        return this.tagOrder;
    }

    public void setTagOrder(Byte[] tagOrder) {
        this.tagOrder = tagOrder;
    }

    @Explain(displayName="handleSkewJoin")
    public boolean getHandleSkewJoin() {
        return this.handleSkewJoin;
    }

    public void setHandleSkewJoin(boolean handleSkewJoin) {
        this.handleSkewJoin = handleSkewJoin;
    }

    public Map<Byte, String> getBigKeysDirMap() {
        return this.bigKeysDirMap;
    }

    public void setBigKeysDirMap(Map<Byte, String> bigKeysDirMap) {
        this.bigKeysDirMap = bigKeysDirMap;
    }

    public Map<Byte, Map<Byte, String>> getSmallKeysDirMap() {
        return this.smallKeysDirMap;
    }

    public void setSmallKeysDirMap(Map<Byte, Map<Byte, String>> smallKeysDirMap) {
        this.smallKeysDirMap = smallKeysDirMap;
    }

    public int getSkewKeyDefinition() {
        return this.skewKeyDefinition;
    }

    public void setSkewKeyDefinition(int skewKeyDefinition) {
        this.skewKeyDefinition = skewKeyDefinition;
    }

    public Map<Byte, TableDesc> getSkewKeysValuesTables() {
        return this.skewKeysValuesTables;
    }

    public void setSkewKeysValuesTables(Map<Byte, TableDesc> skewKeysValuesTables) {
        this.skewKeysValuesTables = skewKeysValuesTables;
    }

    public boolean isNoOuterJoin() {
        return this.noOuterJoin;
    }

    public void setKeyTableDesc(TableDesc keyTblDesc) {
        this.keyTableDesc = keyTblDesc;
    }

    public TableDesc getKeyTableDesc() {
        return this.keyTableDesc;
    }
}

