/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.environment.ctrl.explorer;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Enumeration;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import nickyb.sqleonardo.common.gui.BorderLayoutPanel;
import nickyb.sqleonardo.common.gui.CommandButton;
import nickyb.sqleonardo.common.gui.ListView;
import nickyb.sqleonardo.common.jdbc.ConnectionAssistant;
import nickyb.sqleonardo.common.util.Classpath;
import nickyb.sqleonardo.environment.Application;
import nickyb.sqleonardo.environment.Preferences;
import nickyb.sqleonardo.environment.ctrl.explorer.SideNavigator;
import nickyb.sqleonardo.environment.ctrl.explorer.UoDatasource;
import nickyb.sqleonardo.environment.ctrl.explorer.UoDriver;

public class ViewDatasources
extends ListView {
    private InstallBar installBar;
    private SideNavigator navigator;

    public ViewDatasources(SideNavigator navigator) {
        this.navigator = navigator;
        this.addColumn("name");
        this.addColumn("url");
        this.addColumn("status");
        this.installBar = new InstallBar();
        this.setComponentSouth(this.installBar);
    }

    public void list(DefaultMutableTreeNode node) {
        UoDriver uoDv = (UoDriver)node.getUserObject();
        this.installBar.setVisible(uoDv.message != null);
        this.installBar.message.setText(uoDv.message);
        this.removeAllRows();
        Enumeration<TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)e.nextElement();
            UoDatasource uoDs = (UoDatasource)child.getUserObject();
            Object[] rowdata = new Object[]{uoDs.name, uoDs.url, uoDs.isConnected() ? "connected" : "disconnected"};
            this.addRow(rowdata);
        }
    }

    private class InstallBar
    extends BorderLayoutPanel
    implements ActionListener {
        JLabel message = new JLabel(Application.resources.getIcon("icon.100"));

        InstallBar() {
            this.setComponentCenter(this.message);
            this.setComponentEast(new CommandButton("install", this));
        }

        public void actionPerformed(ActionEvent ae) {
            String currentDirectory = Preferences.getString("lastDirectory", System.getProperty("user.home"));
            JFileChooser fc = new JFileChooser(currentDirectory);
            fc.setFileSelectionMode(0);
            fc.setMultiSelectionEnabled(false);
            fc.setFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().toLowerCase().endsWith(".jar") || file.getName().toLowerCase().endsWith(".zip");
                }

                public String getDescription() {
                    return "library files (*.jar, *.zip)";
                }
            });
            if (fc.showOpenDialog(Application.window) == 0) {
                Preferences.set("lastDirectory", fc.getCurrentDirectory().toString());
                UoDriver uoDv = (UoDriver)ViewDatasources.this.navigator.getSelectionNode().getUserObject();
                try {
                    String file = fc.getSelectedFile().toString();
                    ConnectionAssistant.declare(file, uoDv.classname, !Classpath.isRuntime(file));
                    uoDv.library = file;
                    uoDv.message = null;
                    ViewDatasources.this.navigator.reloadSelection();
                }
                catch (Exception e) {
                    Application.alert("SQLeonardo", "Installation failed!");
                    uoDv.message = e.getMessage();
                }
            }
        }
    }
}

