/*
 * Decompiled with CFR 0.152.
 */
package rex.graphics.dimensiontree;

import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import rex.graphics.TreeElement;
import rex.graphics.dimensiontree.elements.DimensionElement;
import rex.graphics.dimensiontree.elements.DimensionRootElement;
import rex.graphics.dimensiontree.elements.DimensionTreeElement;
import rex.graphics.dimensiontree.elements.MeasureElement;
import rex.metadata.QueryElement;
import rex.metadata.ServerMetadata;
import rex.metadata.resultelements.Member;
import rex.utils.I18n;
import rex.utils.S;
import rex.xmla.XMLADiscoverProperties;
import rex.xmla.XMLADiscoverRestrictions;

public class DimensionTreeModel
implements TreeModel {
    private Vector treeModelListeners;
    private TreeElement root;
    private ServerMetadata smd;
    private XMLADiscoverRestrictions restrictions;
    private XMLADiscoverProperties properties;
    private boolean flattenDimensions = true;
    private boolean withMembersLevel;
    protected static int MAX_CHILDREN_COUNT_ASK = 1001;
    protected static int MAX_CHILDREN_COUNT_DONT_ASK = 1;

    public DimensionTreeModel(XMLADiscoverRestrictions _restrictions, XMLADiscoverProperties _properties, ServerMetadata _smd, boolean _withMembersLevel) {
        this.withMembersLevel = _withMembersLevel;
        this.root = new TreeElement(new DimensionRootElement(), null);
        ((DimensionRootElement)this.root.getUserObject()).setFlattenDimensions(this.flattenDimensions);
        this.restrictions = _restrictions;
        this.properties = _properties;
        this.smd = _smd;
        this.treeModelListeners = new Vector();
        this.buildTree();
    }

    public void buildTree() {
        this.restrictions.setDimensionUniqueName(null);
        this.restrictions.setHierarchyUniqueName(null);
        DimensionTreeElement[] dims = this.smd.getDimensionList(this.restrictions, this.properties);
        if (dims != null) {
            for (int i = 0; dims != null && i < dims.length; ++i) {
                ((DimensionElement)dims[i]).setFlattenDimensions(this.flattenDimensions);
                TreeElement dimension = new TreeElement(dims[i], this.root);
                this.root.addChild(dimension);
                this.buildTreeRecursively(dimension);
            }
            this.fireTreeStructureChanged(this.root);
        } else {
            JOptionPane.showMessageDialog(null, I18n.getString("msgText.noDimensions"), I18n.getString("msgTitle.getDimensions"), 0);
        }
    }

    private void buildTreeRecursively(TreeElement parent) {
        DimensionTreeElement[] dte = ((DimensionTreeElement)parent.getUserObject()).getChildren(false);
        for (int i = 0; dte != null && i < dte.length; ++i) {
            TreeElement node = new TreeElement(dte[i], parent);
            parent.addChild(node);
            this.buildTreeRecursively(node);
        }
    }

    public void addChildrenOneLevel(TreeElement parent) {
        DimensionTreeElement[] dte = ((DimensionTreeElement)parent.getUserObject()).getChildren(true);
        for (int i = 0; dte != null && i < dte.length; ++i) {
            TreeElement node = new TreeElement(dte[i], parent);
            parent.addChild(node);
        }
    }

    void rebuildTree() {
        this.setFlattenDimensions(this.getFlattenDimensions());
    }

    public boolean getFlattenDimensions() {
        return this.flattenDimensions;
    }

    public void setFlattenDimensions(boolean b) {
        this.flattenDimensions = b;
        ((DimensionRootElement)this.root.getUserObject()).setFlattenDimensions(b);
        this.root.dropChildren();
        this.buildTree();
        this.fireTreeStructureChanged(this.root);
    }

    private void enableAllTreeElementsRec(TreeElement parent) {
        for (int i = 0; i < parent.getChildCount(); ++i) {
            if (parent.getChildAt(i).getUserObject() instanceof QueryElement) {
                ((DimensionTreeElement)parent.getChildAt(i).getUserObject()).setEnabled(true);
            }
            if (parent.getChildAt(i).getChildCount() <= 0) continue;
            this.enableAllTreeElementsRec(parent.getChildAt(i));
        }
    }

    public void enableAllTreeElements() {
        this.enableAllTreeElementsRec(this.root);
    }

    public void disableTreeElements(QueryElement qe) {
        if (qe instanceof MeasureElement) {
            this.toggleMeasureEnabled(this.root, ((MeasureElement)qe).getUniqueName(), false);
        } else {
            this.toggleTreeElementsEnabled(this.root, qe.getHierarchyUniqueName(), false);
        }
    }

    public void enableTreeElements(QueryElement qe) {
        System.out.println(qe.getHierarchyUniqueName().toLowerCase().indexOf("measures"));
        if (qe.getHierarchyUniqueName().toLowerCase().indexOf("measures") > 0) {
            this.toggleMeasureEnabled(this.root, ((Member)qe).getUniqueName(), true);
        } else {
            this.toggleTreeElementsEnabled(this.root, qe.getHierarchyUniqueName(), true);
        }
    }

    private void toggleTreeElementsEnabled(TreeElement parent, String hierarchyUniqueName, boolean newEnabledValue) {
        for (int i = 0; i < parent.getChildCount(); ++i) {
            if (parent.getChildAt(i).getUserObject() instanceof QueryElement && ((QueryElement)parent.getChildAt(i).getUserObject()).getHierarchyUniqueName().equals(hierarchyUniqueName)) {
                System.out.println(((QueryElement)parent.getChildAt(i).getUserObject()).getHierarchyUniqueName() + " :By Prakash");
                ((DimensionTreeElement)parent.getChildAt(i).getUserObject()).setEnabled(newEnabledValue);
            }
            if (parent.getChildAt(i).getChildCount() <= 0) continue;
            this.toggleTreeElementsEnabled(parent.getChildAt(i), hierarchyUniqueName, newEnabledValue);
        }
    }

    private int toggleMeasureEnabled(TreeElement parent, String uniqueName, boolean newEnabledValue) {
        int foundIt = 0;
        for (int i = 0; i < parent.getChildCount(); ++i) {
            if (parent.getChildAt(i).getUserObject() instanceof MeasureElement && ((MeasureElement)parent.getChildAt(i).getUserObject()).getUniqueName().equals(uniqueName)) {
                System.out.println(((MeasureElement)parent.getChildAt(i).getUserObject()).getUniqueName() + " :By Prakash");
                ((DimensionTreeElement)parent.getChildAt(i).getUserObject()).setEnabled(newEnabledValue);
                return 1;
            }
            if (parent.getChildAt(i).getChildCount() > 0) {
                foundIt += this.toggleMeasureEnabled(parent.getChildAt(i), uniqueName, newEnabledValue);
            }
            if (foundIt <= 0) continue;
            return foundIt;
        }
        return foundIt;
    }

    public DimensionTreeElement getDimensionTreeElement(String uniqueName) {
        return this.getDimensionTreeElementRec(this.root, uniqueName);
    }

    private DimensionTreeElement getDimensionTreeElementRec(TreeElement parent, String uniqueName) {
        if (((DimensionTreeElement)parent.getUserObject()).getUniqueName().startsWith(uniqueName)) {
            S.out("RETURNING:" + parent.getUserObject());
            return (DimensionTreeElement)parent.getUserObject();
        }
        for (int i = 0; i < parent.getChildCount(); ++i) {
            DimensionTreeElement retVal = this.getDimensionTreeElementRec(parent.getChildAt(i), uniqueName);
            if (retVal == null) continue;
            return retVal;
        }
        return null;
    }

    public TreeElement getTreeElement(String uniqueName) {
        return this.getTreeElementRec(this.root, uniqueName);
    }

    private TreeElement getTreeElementRec(TreeElement parent, String uniqueName) {
        if (((DimensionTreeElement)parent.getUserObject()).getUniqueName().startsWith(uniqueName)) {
            S.out("RETURNING:" + parent);
            return parent;
        }
        for (int i = 0; i < parent.getChildCount(); ++i) {
            TreeElement retVal = this.getTreeElementRec(parent.getChildAt(i), uniqueName);
            if (retVal == null) continue;
            return retVal;
        }
        return null;
    }

    protected void fireTreeStructureChanged(TreeElement oldRoot) {
        int len = this.treeModelListeners.size();
        TreeModelEvent e = new TreeModelEvent((Object)this, new Object[]{oldRoot});
        for (int i = 0; i < len; ++i) {
            ((TreeModelListener)this.treeModelListeners.elementAt(i)).treeStructureChanged(e);
        }
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.treeModelListeners.addElement(l);
    }

    @Override
    public Object getChild(Object parent, int index) {
        TreeElement p = (TreeElement)parent;
        return p.getChildAt(index);
    }

    @Override
    public int getChildCount(Object parent) {
        TreeElement p = (TreeElement)parent;
        return p.getChildCount();
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        TreeElement p = (TreeElement)parent;
        return p.getIndexOfChild((TreeElement)child);
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public boolean isLeaf(Object node) {
        if (this.withMembersLevel) {
            DimensionTreeElement dte = (DimensionTreeElement)((TreeElement)node).getUserObject();
            return dte.getChildrenCount() == 0;
        }
        TreeElement p = (TreeElement)node;
        return p.getChildCount() == 0;
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.treeModelListeners.removeElement(l);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        System.out.println("*** valueForPathChanged : " + path + " --> " + newValue);
    }

    public void removeLanguageChangeListener() {
        if (this.root != null) {
            ((DimensionRootElement)this.root.getUserObject()).removeLanguageListener();
        }
    }
}

