/*
 * Decompiled with CFR 0.152.
 */
package rex.graphics.mdxeditor;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.w3c.dom.Document;
import rex.event.RexWizardEvent;
import rex.event.RexWizardListener;
import rex.exceptions.RexXMLADiscoverException;
import rex.exceptions.RexXMLAExecuteException;
import rex.graphics.mdxeditor.MdxEditor;
import rex.graphics.mdxeditor.mdxbuilder.dnd.DragElement;
import rex.metadata.ServerMetadata;
import rex.utils.I18n;
import rex.utils.LanguageChangedEvent;
import rex.utils.LanguageChangedListener;
import rex.utils.LocaleOptionPane;
import rex.utils.RexDefaultProperties;
import rex.utils.S;
import rex.xmla.RexXMLAPort;
import rex.xmla.XMLADiscoverProperties;
import rex.xmla.XMLADiscoverRestrictions;
import rex.xmla.XMLAExecuteProperties;
import rex.xmla.XMLAObjectsFactory;

public class RexWizard
extends JDialog
implements LanguageChangedListener {
    private RexXMLAPort port;
    private String strQuery;
    private XMLADiscoverRestrictions restriction;
    private XMLADiscoverProperties dProperties;
    private XMLAExecuteProperties execProperties;
    private XMLADiscoverRestrictions mdxEditorRestrictions;
    private XMLADiscoverProperties mdxEditorProperties;
    private JPanel pMdxMainPanel;
    private JPanel pConnection;
    private JPanel pQueryEditor;
    private MdxEditor mdxEditor;
    private JPanel pSouthPanel;
    private CardLayout cardLayout;
    private JTextField txtURL;
    private JComboBox cmbDataSource;
    private JComboBox cmbCatalog;
    private JComboBox cmbCube;
    private JLabel lblError;
    private JButton bBack;
    private JButton bNext;
    private JButton bFinish = new JButton();
    private JButton bCancel = new JButton();
    private Vector vCatalog;
    private Vector vCube;
    public RexWizardEvent rexWizardEvent;
    public RexWizardListener rexWizardListener;
    private HandleRexWizardEvent handleEvent;
    private int iFlagEditor = 0;
    String strOLAPURL;
    String strDataSourcename;
    String strCatalog;
    String strCube;
    String strErrorConst = "error";
    Locale locale = Locale.getDefault();
    private boolean status = true;
    Document document;
    DocListener documentListener;

    public RexWizard() {
        this.setGlassPane(new DragElement());
        this.iFlagEditor = 0;
        I18n.addOnLanguageChangedListener(this);
        this.applyI18n();
    }

    public RexWizard(String strOLAPURL, String strDataSourcename, String strCatalog, String strCube) {
        this.setGlassPane(new DragElement());
        this.strOLAPURL = strOLAPURL;
        this.strDataSourcename = strDataSourcename;
        this.strCatalog = strCatalog;
        this.strCube = strCube;
        this.iFlagEditor = 1;
        I18n.addOnLanguageChangedListener(this);
        this.applyI18n();
    }

    public RexWizard(String strOLAPURL, String strDataSourcename, String strCatalog, String strCube, String strQuery, Locale iRLocale) {
        Iterator it = LocaleOptionPane.getListOfAvailLanguages().iterator();
        if (iRLocale == null) {
            this.locale = Locale.US;
        } else {
            while (it.hasNext()) {
                Locale temp = (Locale)it.next();
                temp.getDisplayLanguage();
                temp.getDisplayCountry();
                if (iRLocale.getDisplayLanguage().equalsIgnoreCase(temp.getDisplayLanguage()) && iRLocale.getDisplayCountry().equalsIgnoreCase(temp.getDisplayCountry())) {
                    this.locale = iRLocale;
                    break;
                }
                this.locale = Locale.US;
            }
        }
        this.setGlassPane(new DragElement());
        RexDefaultProperties.createDefaultProperties();
        this.strOLAPURL = strOLAPURL;
        this.strDataSourcename = strDataSourcename;
        this.strCatalog = strCatalog;
        this.strCube = strCube;
        this.strQuery = strQuery;
        I18n.addOnLanguageChangedListener(this);
        I18n.setCurrentLocale(this.locale);
        this.applyI18n();
        this.iFlagEditor = 1;
    }

    @Override
    public void languageChanged(LanguageChangedEvent evt) {
        this.applyI18n();
    }

    @Override
    public void removeLanguageListener() {
        I18n.removeOnLanguageChangedListener(this);
    }

    public void applyI18n() {
        this.bCancel.setText(I18n.getString("btn.cancel"));
        this.bFinish.setText(I18n.getString("btn.finish"));
    }

    public void addRexWizardListener(RexWizardListener rwl) {
        this.rexWizardListener = rwl;
    }

    public void fireRexWizardEvent(RexWizardEvent rwt) {
        this.rexWizardListener.getMdx(rwt);
    }

    public void showDialog() {
        this.documentListener = new DocListener();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent wEvent) {
                if (RexWizard.this.status) {
                    RexWizard.this.dispose();
                } else {
                    int confirm = JOptionPane.showConfirmDialog(null, I18n.getString("msgText.wantToSave"));
                    if (confirm == 0) {
                        RexWizard.this.status = true;
                        String[] wholeMdxString = ((RexWizard)RexWizard.this).mdxEditor.textArea.getText().split("\n");
                        int mdxQueryCounter = 0;
                        for (int lineCounter = 0; lineCounter < wholeMdxString.length; ++lineCounter) {
                            if (wholeMdxString[lineCounter].startsWith("--") || wholeMdxString[lineCounter].trim().length() == 0) continue;
                            ++mdxQueryCounter;
                        }
                        String[] bss = new String[mdxQueryCounter];
                        mdxQueryCounter = 0;
                        for (int lineCounter = 0; lineCounter < wholeMdxString.length; ++lineCounter) {
                            if (wholeMdxString[lineCounter].startsWith("--") || wholeMdxString[lineCounter].trim().length() == 0) continue;
                            bss[mdxQueryCounter] = wholeMdxString[lineCounter];
                            ++mdxQueryCounter;
                        }
                        String mdxStr = "";
                        for (int i = 0; i < bss.length; ++i) {
                            mdxStr = mdxStr.concat(bss[i].concat("\n"));
                        }
                        RexWizard.this.fireRexWizardEvent(new RexWizardEvent(mdxStr));
                        RexWizard.this.dispose();
                    } else {
                        RexWizard.this.status = true;
                        RexWizard.this.dispose();
                    }
                }
            }
        });
        this.vCatalog = new Vector();
        this.vCube = new Vector();
        this.vCatalog.addElement("");
        this.vCube.addElement("");
        this.restriction = XMLAObjectsFactory.newXMLADiscoverRestrictions();
        this.dProperties = XMLAObjectsFactory.newXMLADiscoverProperties();
        this.mdxEditorRestrictions = XMLAObjectsFactory.newXMLADiscoverRestrictions();
        this.mdxEditorProperties = XMLAObjectsFactory.newXMLADiscoverProperties();
        this.execProperties = XMLAObjectsFactory.newXMLAExecuteProperties();
        this.handleEvent = new HandleRexWizardEvent();
        this.setTitle(I18n.getString("dlgTitle.connProp"));
        this.pConnection = new JPanel();
        this.pConnection.setLayout(null);
        JLabel lblURL = new JLabel();
        lblURL.setText(I18n.getString("label.urlOfXMLA"));
        lblURL.setBounds(10, 26, 107, 16);
        this.pConnection.add(lblURL);
        JSeparator separator = new JSeparator();
        separator.setBounds(10, 98, 574, 1);
        this.pConnection.add(separator);
        JLabel lblDatasource = new JLabel();
        lblDatasource.setText("Datasource");
        lblDatasource.setBounds(10, 117, 66, 16);
        this.pConnection.add(lblDatasource);
        JLabel lblCatalog = new JLabel();
        lblCatalog.setText("Catalog");
        lblCatalog.setBounds(10, 178, 66, 16);
        this.pConnection.add(lblCatalog);
        JLabel lblCube = new JLabel();
        lblCube.setText("Cube");
        lblCube.setBounds(10, 244, 66, 16);
        this.pConnection.add(lblCube);
        this.txtURL = new JTextField();
        this.txtURL.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent fEvent) {
                RexWizard.this.checkURL();
            }
        });
        this.txtURL.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent kEvent) {
                if (kEvent.getKeyCode() == 10) {
                    RexWizard.this.checkURL();
                }
            }
        });
        this.txtURL.setBounds(10, 51, 574, 20);
        this.pConnection.add(this.txtURL);
        String[] tempArrayForCombo = new String[]{" "};
        this.cmbDataSource = new JComboBox();
        this.cmbDataSource.setBounds(10, 139, 574, 25);
        this.pConnection.add(this.cmbDataSource);
        this.cmbCatalog = new JComboBox();
        this.cmbCatalog.setBounds(10, 201, 574, 25);
        this.pConnection.add(this.cmbCatalog);
        this.cmbCube = new JComboBox();
        this.cmbCube.setBounds(10, 266, 574, 25);
        this.pConnection.add(this.cmbCube);
        this.lblError = new JLabel();
        this.lblError.setFont(new Font("Arial", 0, 10));
        this.lblError.setForeground(Color.red);
        this.lblError.setBounds(10, 75, 574, 16);
        this.pConnection.add(this.lblError);
        JSeparator separator_2 = new JSeparator();
        separator_2.setBounds(10, 388, 574, 1);
        this.pConnection.add(separator_2);
        this.pQueryEditor = new JPanel();
        this.pQueryEditor.setLayout(new BorderLayout());
        this.pQueryEditor.setBorder(new CompoundBorder());
        this.pMdxMainPanel = new JPanel();
        this.getContentPane().add((Component)this.pMdxMainPanel, "Center");
        this.cardLayout = new CardLayout();
        this.pMdxMainPanel.setLayout(this.cardLayout);
        this.pMdxMainPanel.add("pConnection", this.pConnection);
        this.pMdxMainPanel.add("pQueryEditor", this.pQueryEditor);
        this.pSouthPanel = new JPanel();
        this.getContentPane().add((Component)this.pSouthPanel, "South");
        this.bBack = new JButton();
        this.bBack.setText(I18n.getString("btn.back"));
        this.bBack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent aEvent) {
                RexWizard.this.cardLayout.show(RexWizard.this.pMdxMainPanel, "pConnection");
                RexWizard.this.mdxEditor.removeAll();
                RexWizard.this.mdxEditor = null;
                RexWizard.this.pQueryEditor.removeAll();
                RexWizard.this.bBack.setEnabled(false);
                RexWizard.this.bNext.setEnabled(true);
                RexWizard.this.bFinish.setEnabled(false);
                RexWizard.this.setTitle(I18n.getString("dlgTitle.connProp"));
                RexWizard.this.validate();
            }
        });
        this.bBack.setEnabled(false);
        this.pSouthPanel.add(this.bBack);
        this.bNext = new JButton();
        this.bNext.setEnabled(false);
        this.bNext.setText(I18n.getString("btn.next"));
        this.bNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent aEvent) {
                RexWizard.this.strOLAPURL = RexWizard.this.txtURL.getText().trim();
                RexWizard.this.strDataSourcename = (String)RexWizard.this.cmbDataSource.getSelectedItem();
                RexWizard.this.strCatalog = (String)RexWizard.this.cmbCatalog.getSelectedItem();
                RexWizard.this.strCube = (String)RexWizard.this.cmbCube.getSelectedItem();
                RexWizard.this.showEditor();
            }
        });
        this.pSouthPanel.add(this.bNext);
        this.bFinish.addActionListener(this.handleEvent);
        this.bFinish.setEnabled(false);
        this.pSouthPanel.add(this.bFinish);
        this.bFinish.setText(I18n.getString("btn.finish"));
        this.bCancel.addActionListener(this.handleEvent);
        this.bCancel.setText(I18n.getString("btn.cancel"));
        this.pSouthPanel.add(this.bCancel);
        this.setBounds((int)(Toolkit.getDefaultToolkit().getScreenSize().getWidth() / 6.0), (int)(Toolkit.getDefaultToolkit().getScreenSize().getHeight() / 5.0), (int)(Toolkit.getDefaultToolkit().getScreenSize().getWidth() / 1.3), (int)(Toolkit.getDefaultToolkit().getScreenSize().getHeight() / 1.3));
        this.setDefaultCloseOperation(2);
        this.setResizable(true);
        this.setModal(true);
        if (this.iFlagEditor == 1) {
            this.showEditor();
            this.mdxEditor.textArea.getDocument().addDocumentListener(this.documentListener);
            this.bNext.setVisible(false);
            this.bBack.setVisible(false);
        }
        this.setVisible(true);
    }

    private void checkURL() {
        if (this.txtURL.getText().trim().length() == 0) {
            this.lblError.setText(I18n.getString("label.noUrlFound"));
            this.cmbDataSource.removeAllItems();
            this.cmbCatalog.removeAllItems();
            this.cmbCube.removeAllItems();
        } else {
            this.doDiscover();
            this.cmbDataSource.addActionListener(this.handleEvent);
        }
    }

    private void doDiscover() {
        try {
            int j;
            this.port = new RexXMLAPort(new URL(this.txtURL.getText().trim()));
            String[] dsn = this.port.discoverDataSourcesAsString(this.restriction, this.dProperties);
            this.cmbDataSource.removeAllItems();
            for (j = 0; j < dsn.length; ++j) {
                this.cmbDataSource.addItem(dsn[j]);
            }
            this.vCatalog.removeAllElements();
            this.vCube.removeAllElements();
            for (j = 0; j < dsn.length; ++j) {
                this.dProperties.setDataSourceInfo(dsn[j]);
                String[] catalogs = this.port.getCatalogListAsString(this.restriction, this.dProperties);
                for (int k = 0; k < catalogs.length; ++k) {
                    this.dProperties.setCatalog(catalogs[k]);
                    String[] cubes = this.port.getCubeListAsString(this.restriction, this.dProperties);
                    this.vCatalog.addElement(dsn[j].concat(":" + catalogs[k]));
                    for (int l = 0; l < cubes.length; ++l) {
                        this.vCube.addElement(dsn[j].concat(":" + catalogs[k]).concat(":" + cubes[l]));
                    }
                }
            }
            this.insertCatalog();
        }
        catch (RexXMLAExecuteException xmlaException) {
            this.handleException(xmlaException.getError());
        }
        catch (RexXMLADiscoverException xmlaDiscException) {
            this.handleException(xmlaDiscException.getError());
        }
        catch (Exception exc) {
            this.handleException(exc.getMessage());
        }
    }

    private void handleException(String exceptionString) {
        this.lblError.setText(exceptionString);
        this.cmbDataSource.removeAllItems();
        this.cmbCatalog.removeAllItems();
        this.cmbCube.removeAllItems();
        this.bNext.setEnabled(false);
    }

    private void insertCatalog() {
        this.cmbCatalog.removeAllItems();
        int catalogSize = this.vCatalog.size();
        for (int catCounter = 0; catCounter < catalogSize; ++catCounter) {
            String[] dsnCat = this.vCatalog.elementAt(catCounter).toString().split(":");
            if (!((String)this.cmbDataSource.getSelectedItem()).equals(dsnCat[0])) continue;
            this.cmbCatalog.addItem(dsnCat[1]);
        }
        this.insertCube();
    }

    private void insertCube() {
        int cubeSize = this.vCube.size();
        this.cmbCube.removeAllItems();
        for (int cubeCounter = 0; cubeCounter < cubeSize; ++cubeCounter) {
            String[] dsnCatCube = this.vCube.elementAt(cubeCounter).toString().split(":");
            if (!((String)this.cmbDataSource.getSelectedItem()).equals(dsnCatCube[0]) || !((String)this.cmbCatalog.getSelectedItem()).equals(dsnCatCube[1])) continue;
            this.cmbCube.addItem(dsnCatCube[2]);
        }
        this.lblError.setText("");
        this.bNext.setEnabled(true);
    }

    public void showEditor() {
        this.mdxEditorRestrictions.setCatalog(this.strCatalog);
        this.mdxEditorRestrictions.setCubeName(this.strCube);
        this.mdxEditorProperties.setDataSourceInfo(this.strDataSourcename);
        this.mdxEditorProperties.setCatalog(this.strCatalog);
        this.mdxEditor = new MdxEditor(this.mdxEditorRestrictions, this.mdxEditorProperties, new ServerMetadata(this.strOLAPURL), this.strCube);
        this.mdxEditor.setLocale(this.locale);
        I18n.setCurrentLocale(this.locale);
        this.mdxEditor.setLocaleEnabled(false);
        this.pQueryEditor.add((Component)this.mdxEditor, "Center");
        this.cardLayout.show(this.pMdxMainPanel, "pQueryEditor");
        this.mdxEditor.textArea.setText(this.strQuery);
        this.mdxEditor.textArea.validate();
        this.bNext.setEnabled(false);
        this.bFinish.setEnabled(true);
        this.bBack.setEnabled(true);
        this.setTitle("WareHouse EXplorer - " + this.mdxEditorRestrictions.getCubeName());
        this.validate();
    }

    private void checkMdx() {
        if (this.mdxEditor.textArea.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(null, I18n.getString("msgText.noQuery"), this.strErrorConst, 1);
            return;
        }
        String[] wholeMdxString = this.mdxEditor.textArea.getText().split("\n");
        int mdxQueryCounter = 0;
        for (int lineCounter = 0; lineCounter < wholeMdxString.length; ++lineCounter) {
            if (wholeMdxString[lineCounter].startsWith("--") || wholeMdxString[lineCounter].trim().length() == 0) continue;
            ++mdxQueryCounter;
        }
        String[] bss = new String[mdxQueryCounter];
        mdxQueryCounter = 0;
        for (int lineCounter = 0; lineCounter < wholeMdxString.length; ++lineCounter) {
            if (wholeMdxString[lineCounter].startsWith("--") || wholeMdxString[lineCounter].trim().length() == 0) continue;
            bss[mdxQueryCounter] = wholeMdxString[lineCounter];
            ++mdxQueryCounter;
        }
        String mdxStr = "";
        for (int i = 0; i < bss.length; ++i) {
            mdxStr = mdxStr.concat(bss[i].concat("\n"));
        }
        try {
            if (this.iFlagEditor == 0) {
                this.execProperties.setDataSourceInfo((String)this.cmbDataSource.getSelectedItem());
                this.execProperties.setCatalog((String)this.cmbCatalog.getSelectedItem());
            }
            if (this.iFlagEditor == 1) {
                this.execProperties.setDataSourceInfo(this.strDataSourcename);
                this.execProperties.setCatalog(this.strCatalog);
                this.port = new RexXMLAPort(new URL(this.strOLAPURL));
            }
            this.port.execute(mdxStr, this.execProperties);
            this.rexWizardEvent = new RexWizardEvent(mdxStr);
            this.fireRexWizardEvent(this.rexWizardEvent);
            this.setVisible(false);
            this.dispose();
        }
        catch (RexXMLAExecuteException exc) {
            JOptionPane.showMessageDialog(null, exc.toString(), this.strErrorConst, 1);
        }
        catch (RexXMLADiscoverException exc) {
            JOptionPane.showMessageDialog(null, exc.toString(), this.strErrorConst, 1);
        }
        catch (Exception exc) {
            JOptionPane.showMessageDialog(null, exc.toString(), this.strErrorConst, 1);
        }
    }

    public static void main(String[] args) {
        RexWizard frame = new RexWizard();
        frame.showDialog();
        frame.setVisible(true);
    }

    class DocListener
    implements DocumentListener {
        DocListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            RexWizard.this.status = false;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            RexWizard.this.status = false;
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            RexWizard.this.status = false;
        }
    }

    private class HandleRexWizardEvent
    implements ActionListener {
        private HandleRexWizardEvent() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object eventSource = actionEvent.getSource();
            if (eventSource.equals(RexWizard.this.bFinish)) {
                RexWizard.this.checkMdx();
            }
            if (eventSource.equals(RexWizard.this.bCancel)) {
                RexWizard.this.setVisible(false);
                RexWizard.this.dispose();
            }
            if (eventSource.equals(RexWizard.this.cmbDataSource)) {
                try {
                    RexWizard.this.insertCatalog();
                }
                catch (Exception exc) {
                    S.reportError(exc);
                }
            }
            if (eventSource.equals(RexWizard.this.cmbCatalog)) {
                try {
                    RexWizard.this.insertCube();
                }
                catch (Exception exc) {
                    S.reportError(exc);
                }
            }
        }
    }
}

