/*
 * Decompiled with CFR 0.152.
 */
package rex.graphics.mdxeditor.mdxbuilder;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.Stack;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import rex.graphics.mdxeditor.mdxbuilder.CanSaveAndResumeState;
import rex.graphics.mdxeditor.mdxbuilder.HandlesMdxEditorSettings;
import rex.graphics.mdxeditor.mdxbuilder.MdxBuilderTree;
import rex.utils.AppColors;
import rex.utils.I18n;
import rex.utils.LanguageChangedEvent;
import rex.utils.LanguageChangedListener;
import rex.utils.S;

public class MdxBuilderToolbar
extends JPanel
implements LanguageChangedListener {
    private CanSaveAndResumeState parent;
    private HandlesMdxEditorSettings settingsHandler;
    private JLabel saveQuery;
    private JLabel loadQuery;
    private JLabel undoAction;
    private JLabel redoAction;
    private JLabel newQuery;
    private static int MAX_UNDO_OPERATIONS = 20;
    private Stack undoStack;
    private Stack redoStack;
    private static ImageIcon undoEnabledIcon = S.getAppIcon("undo.gif");
    private static ImageIcon undoDisabledIcon = S.getAppIcon("undo_disabled.gif");
    private static ImageIcon redoEnabledIcon = S.getAppIcon("redo.gif");
    private static ImageIcon redoDisabledIcon = S.getAppIcon("redo_disabled.gif");
    JFileChooser chooser;

    public MdxBuilderToolbar(CanSaveAndResumeState _parent, HandlesMdxEditorSettings _settingsHandler) {
        this.parent = _parent;
        this.settingsHandler = _settingsHandler;
        this.newQuery = new JLabel(S.getAppIcon("new_query.gif"));
        this.newQuery.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MdxBuilderToolbar.this.newQuery();
            }
        });
        this.newQuery.setToolTipText(I18n.getString("toolTip.newQuery"));
        this.saveQuery = new JLabel(S.getAppIcon("save_query.gif"));
        this.saveQuery.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MdxBuilderToolbar.this.saveQuery();
            }
        });
        this.saveQuery.setToolTipText(I18n.getString("toolTip.saveQuery"));
        this.loadQuery = new JLabel(S.getAppIcon("open_query.gif"));
        this.loadQuery.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MdxBuilderToolbar.this.loadQuery();
            }
        });
        this.loadQuery.setToolTipText(I18n.getString("toolTip.loadQuery"));
        this.loadQuery.setOpaque(false);
        this.undoAction = new JLabel(undoDisabledIcon);
        this.undoAction.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MdxBuilderToolbar.this.undo();
            }
        });
        this.undoAction.setToolTipText(I18n.getString("toolTip.undoAction"));
        this.undoAction.setOpaque(false);
        this.redoAction = new JLabel(redoDisabledIcon);
        this.redoAction.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MdxBuilderToolbar.this.redo();
            }
        });
        this.redoAction.setToolTipText(I18n.getString("toolTip.redoAction"));
        this.redoAction.setOpaque(false);
        this.setLayout(new BoxLayout(this, 0));
        this.add(Box.createRigidArea(new Dimension(4, 0)));
        this.add(this.newQuery);
        this.add(Box.createRigidArea(new Dimension(4, 0)));
        this.add(this.saveQuery);
        this.add(Box.createRigidArea(new Dimension(4, 0)));
        this.add(this.loadQuery);
        this.add(Box.createRigidArea(new Dimension(4, 0)));
        this.add(this.undoAction);
        this.add(Box.createRigidArea(new Dimension(4, 0)));
        this.add(this.redoAction);
        this.setBorder(AppColors.TOOLBAR_BORDER);
        this.setOpaque(false);
        this.undoStack = new Stack();
        this.redoStack = new Stack();
        this.chooser = new JFileChooser();
        try {
            this.chooser.setFileSelectionMode(2);
            this.chooser.addChoosableFileFilter(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.getName().toLowerCase().endsWith(".mdx") || pathname.isDirectory();
                }

                @Override
                public String getDescription() {
                    return "MDX (*.mdx)";
                }
            });
            this.chooser.addChoosableFileFilter(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.getName().toLowerCase().endsWith(".mbt") || pathname.isDirectory();
                }

                @Override
                public String getDescription() {
                    return "MBT files (*.mbt)";
                }
            });
            this.chooser.setCurrentDirectory(new File(System.getProperty("java.home")));
            String fileName = ((MdxBuilderTree)this.parent).getFileName();
            if (fileName != null & fileName.trim().length() > 0) {
                this.chooser.setSelectedFile(new File(fileName));
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, ex.getMessage(), "Error", 0);
        }
        I18n.addOnLanguageChangedListener(this);
        this.applyI18n();
    }

    public void setUndoEnabled(boolean enabled) {
        this.undoAction.setEnabled(enabled);
        if (enabled) {
            this.undoAction.setIcon(undoEnabledIcon);
        } else {
            this.undoAction.setIcon(undoDisabledIcon);
        }
    }

    public void setRedoEnabled(boolean enabled) {
        this.redoAction.setEnabled(enabled);
        if (enabled) {
            this.redoAction.setIcon(redoEnabledIcon);
        } else {
            this.redoAction.setIcon(redoDisabledIcon);
        }
    }

    public void refreshUndoRedoState() {
        this.setUndoEnabled(this.canUndo());
        this.setRedoEnabled(this.canRedo());
    }

    public void actionToBePerformed() {
        if (this.undoStack.size() == MAX_UNDO_OPERATIONS) {
            this.undoStack.removeElementAt(0);
        }
        ByteArrayOutputStream memStream = new ByteArrayOutputStream();
        this.redoStack.removeAllElements();
        this.parent.saveState(memStream);
        this.undoStack.push(memStream);
        this.refreshUndoRedoState();
    }

    public void undo() {
        if (this.canUndo()) {
            ByteArrayOutputStream currMemStream = new ByteArrayOutputStream();
            this.parent.saveState(currMemStream);
            this.redoStack.push(currMemStream);
            ByteArrayOutputStream memStream = (ByteArrayOutputStream)this.undoStack.pop();
            this.parent.resumeState(new ByteArrayInputStream(memStream.toByteArray()));
            this.refreshUndoRedoState();
        }
    }

    public void redo() {
        if (this.canRedo()) {
            ByteArrayOutputStream currMemStream = new ByteArrayOutputStream();
            this.parent.saveState(currMemStream);
            this.undoStack.push(currMemStream);
            ByteArrayOutputStream memStream = (ByteArrayOutputStream)this.redoStack.pop();
            this.parent.resumeState(new ByteArrayInputStream(memStream.toByteArray()));
            this.refreshUndoRedoState();
        }
    }

    public boolean canUndo() {
        return !this.undoStack.empty();
    }

    public boolean canRedo() {
        return !this.redoStack.empty();
    }

    protected void newQuery() {
        ((MdxBuilderTree)this.parent).newQuery();
    }

    protected void loadQuery() {
        ((MdxBuilderTree)this.parent).openQuery();
    }

    protected void saveQuery() {
        ((MdxBuilderTree)this.parent).saveQuery();
    }

    @Override
    public void paintComponent(Graphics g) {
        S.paintBackground(g, this);
        super.paintComponent(g);
    }

    @Override
    public void languageChanged(LanguageChangedEvent evt) {
        this.applyI18n();
    }

    @Override
    public void removeLanguageListener() {
        I18n.removeOnLanguageChangedListener(this);
    }

    public void applyI18n() {
        this.newQuery.setToolTipText(I18n.getString("toolTip.newQuery"));
        this.saveQuery.setToolTipText(I18n.getString("toolTip.saveQuery"));
        this.loadQuery.setToolTipText(I18n.getString("toolTip.loadQuery"));
        this.undoAction.setToolTipText(I18n.getString("toolTip.undoAction"));
        this.redoAction.setToolTipText(I18n.getString("toolTip.redoAction"));
    }
}

