/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.mongodb.connection;

import com.mongodb.DB;
import com.mongodb.Mongo;
import com.mongodb.MongoException;
import com.mongodb.MongoURI;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import net.sf.jasperreports.engine.JRException;
import org.apache.log4j.Logger;

public class MongoDbConnection
implements Connection {
    protected static final List<Integer> AUTH_ERROR_CODES = Arrays.asList(16550, 16549, 10057, 15845);
    private Mongo client;
    private MongoURI mongoURIObject;
    private String mongoURI;
    private String username;
    private String password;
    private DB mongoDatabase;
    private final Logger logger = Logger.getLogger(MongoDbConnection.class);

    public MongoDbConnection(String mongoURI, String username, String password) throws JRException {
        this.mongoURI = mongoURI;
        this.create(this.mongoURI);
        this.username = username;
        this.password = password;
        this.setDatabase();
    }

    private void create(String mongoURI) throws JRException {
        this.close();
        try {
            this.mongoURIObject = new MongoURI(mongoURI);
            this.client = new Mongo(this.mongoURIObject);
        }
        catch (Exception e) {
            this.logger.error((Object)e);
            throw new JRException(e.getMessage());
        }
    }

    private void setDatabase() throws JRException {
        if (this.client == null) {
            this.logger.error((Object)"No client");
            return;
        }
        if (this.mongoDatabase != null) {
            return;
        }
        this.mongoDatabase = this.client.getDB(this.mongoURIObject.getDatabase());
        boolean performaAuthentication = false;
        try {
            this.mongoDatabase.getCollectionNames();
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (e instanceof MongoException) {
                if (AUTH_ERROR_CODES.contains(((MongoException)e).getCode())) {
                    performaAuthentication = true;
                }
                this.logger.error((Object)"Cannot set database", (Throwable)e);
                throw new JRException(message);
            }
            this.logger.error((Object)"Cannot set database", (Throwable)e);
            throw new JRException(message);
        }
        if (performaAuthentication) {
            if (this.username != null && this.password != null) {
                if (!this.mongoDatabase.authenticate(this.username, this.password.toCharArray())) {
                    throw new JRException("Successful connection but wrong authentication");
                }
            } else {
                throw new JRException("Authentication required but username or password is empty");
            }
        }
    }

    public DB getMongoDatabase() {
        return this.mongoDatabase;
    }

    public String getMongoURI() {
        return this.mongoURI;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    @Override
    public void close() {
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
        this.mongoURIObject = null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.client == null;
    }

    public MongoURI getMongoURIObject() {
        return this.mongoURIObject;
    }

    public Mongo getClient() {
        return this.client;
    }

    public String test() throws JRException {
        if (this.mongoURIObject == null) {
            throw new JRException("Invalid mongo URL");
        }
        if (this.mongoDatabase == null) {
            throw new JRException("No mongo database");
        }
        try {
            return "Connection test successful.\nMongo database name: " + this.mongoDatabase.getName();
        }
        catch (Exception e) {
            this.logger.error((Object)e);
            throw new JRException((Throwable)e);
        }
    }

    public void getDatabase(String databaseName) {
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public Statement createStatement() throws SQLException {
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return null;
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return null;
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return null;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return false;
    }

    @Override
    public void commit() throws SQLException {
    }

    @Override
    public void rollback() throws SQLException {
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return null;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return false;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
    }

    @Override
    public String getCatalog() throws SQLException {
        return null;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return null;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return null;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return null;
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
    }

    @Override
    public int getHoldability() throws SQLException {
        return 0;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return null;
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return null;
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return null;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return null;
    }

    @Override
    public Clob createClob() throws SQLException {
        return null;
    }

    @Override
    public Blob createBlob() throws SQLException {
        return null;
    }

    @Override
    public NClob createNClob() throws SQLException {
        return null;
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return null;
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return false;
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return null;
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return null;
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return null;
    }

    @Override
    public void setSchema(String schema) throws SQLException {
    }

    @Override
    public String getSchema() throws SQLException {
        return null;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return 0;
    }
}

