/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.analytics.data;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.analytics.data.PropertyValues;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MappedPropertyValues
implements PropertyValues {
    private static final Log log = LogFactory.getLog(MappedPropertyValues.class);
    private final Map<String, Integer> propertyIndexes;
    private final Object[] propertyValues;

    public MappedPropertyValues(Map<String, Integer> propertyIndexes, Object[] propertyValues) {
        this.propertyIndexes = propertyIndexes;
        this.propertyValues = propertyValues;
    }

    @Override
    public Set<String> getPropertyNames() {
        return Collections.unmodifiableSet(this.propertyIndexes.keySet());
    }

    @Override
    public Object getPropertyValue(String name) {
        Object value;
        Integer propertyIndex = this.propertyIndexes.get(name);
        if (propertyIndex == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("property " + name + " not found"));
            }
            value = null;
        } else {
            value = this.propertyValues[propertyIndex];
        }
        return value;
    }
}

