/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.GenericElementHandlerEnviroment;
import net.sf.jasperreports.engine.export.GenericElementJsonHandler;
import net.sf.jasperreports.engine.export.HtmlExporter;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRHtmlExporterParameter;
import net.sf.jasperreports.engine.export.JsonExporterContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JsonExporter
extends JRAbstractExporter {
    private static final Log log = LogFactory.getLog(JsonExporter.class);
    public static final String JSON_EXPORTER_KEY = "net.sf.jasperreports.json";
    protected static final String JSON_EXPORTER_PROPERTIES_PREFIX = "net.sf.jasperreports.export.json.";
    protected JRExportProgressMonitor progressMonitor;
    protected String encoding;
    protected boolean flushOutput;
    protected Writer writer;
    protected int reportIndex;
    protected int pageIndex;
    private boolean gotFirstJsonFragment;
    protected JsonExporterContext exporterContext = new ExporterContext();

    public JsonExporter() {
        this(DefaultJasperReportsContext.getInstance());
    }

    public JsonExporter(JasperReportsContext jasperReportsContext) {
        super(jasperReportsContext);
    }

    @Override
    public String getExporterKey() {
        return JSON_EXPORTER_KEY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportReport() throws JRException {
        block37: {
            this.progressMonitor = (JRExportProgressMonitor)this.parameters.get(JRExporterParameter.PROGRESS_MONITOR);
            this.setOffset();
            try {
                this.setExportContext();
                this.setInput();
                this.setHyperlinkProducerFactory();
                if (!this.parameters.containsKey(JRExporterParameter.FILTER)) {
                    this.filter = this.createFilter(JSON_EXPORTER_PROPERTIES_PREFIX);
                }
                if (!this.isModeBatch) {
                    this.setPageRange();
                }
                this.encoding = this.getStringParameterOrDefault(JRExporterParameter.CHARACTER_ENCODING, "net.sf.jasperreports.export.character.encoding");
                this.flushOutput = this.getBooleanParameter(JRHtmlExporterParameter.FLUSH_OUTPUT, "net.sf.jasperreports.export.html.flush.output", true);
                StringBuffer sb = (StringBuffer)this.parameters.get(JRExporterParameter.OUTPUT_STRING_BUFFER);
                if (sb != null) {
                    try {
                        this.writer = new StringWriter();
                        this.exportReportToWriter();
                        sb.append(this.writer.toString());
                        break block37;
                    }
                    catch (IOException e) {
                        throw new JRException("Error writing to StringBuffer writer : " + this.jasperPrint.getName(), e);
                    }
                    finally {
                        if (this.writer != null) {
                            try {
                                this.writer.close();
                            }
                            catch (IOException e) {}
                        }
                    }
                }
                this.writer = (Writer)this.parameters.get(JRExporterParameter.OUTPUT_WRITER);
                if (this.writer != null) {
                    try {
                        this.exportReportToWriter();
                        break block37;
                    }
                    catch (IOException e) {
                        throw new JRException("Error writing to writer : " + this.jasperPrint.getName(), e);
                    }
                }
                OutputStream os = (OutputStream)this.parameters.get(JRExporterParameter.OUTPUT_STREAM);
                if (os != null) {
                    try {
                        this.writer = new OutputStreamWriter(os, this.encoding);
                        this.exportReportToWriter();
                        break block37;
                    }
                    catch (IOException e) {
                        throw new JRException("Error writing to OutputStream writer : " + this.jasperPrint.getName(), e);
                    }
                }
                File destFile = (File)this.parameters.get(JRExporterParameter.OUTPUT_FILE);
                if (destFile == null) {
                    String fileName = (String)this.parameters.get(JRExporterParameter.OUTPUT_FILE_NAME);
                    if (fileName != null) {
                        destFile = new File(fileName);
                    } else {
                        throw new JRException("No output specified for the exporter.");
                    }
                }
                try {
                    os = new FileOutputStream(destFile);
                    this.writer = new OutputStreamWriter(os, this.encoding);
                }
                catch (IOException e) {
                    throw new JRException("Error creating to file writer : " + this.jasperPrint.getName(), e);
                }
                try {
                    this.exportReportToWriter();
                }
                catch (IOException e) {
                    throw new JRException("Error writing to file writer : " + this.jasperPrint.getName(), e);
                }
                finally {
                    if (this.writer != null) {
                        try {
                            this.writer.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
            finally {
                this.resetExportContext();
            }
        }
    }

    protected void exportReportToWriter() throws JRException, IOException {
        this.writer.write("{\n");
        this.reportIndex = 0;
        while (this.reportIndex < this.jasperPrintList.size()) {
            this.setJasperPrint((JasperPrint)this.jasperPrintList.get(this.reportIndex));
            List<JRPrintPage> pages = this.jasperPrint.getPages();
            if (pages != null && pages.size() > 0) {
                if (this.isModeBatch) {
                    this.startPageIndex = 0;
                    this.endPageIndex = pages.size() - 1;
                }
                JRPrintPage page = null;
                this.pageIndex = this.startPageIndex;
                while (this.pageIndex <= this.endPageIndex) {
                    if (Thread.interrupted()) {
                        throw new JRException("Current thread interrupted.");
                    }
                    page = pages.get(this.pageIndex);
                    this.exportPage(page);
                    if (this.reportIndex < this.jasperPrintList.size() - 1 || this.pageIndex < this.endPageIndex) {
                        this.writer.write("\n");
                    }
                    ++this.pageIndex;
                }
            }
            ++this.reportIndex;
        }
        this.writer.write("\n}");
        if (this.flushOutput) {
            this.writer.flush();
        }
    }

    protected void exportPage(JRPrintPage page) throws IOException {
        List<JRPrintElement> elements = page.getElements();
        this.exportElements(elements);
    }

    protected void exportElements(Collection<JRPrintElement> elements) throws IOException {
        if (elements != null && elements.size() > 0) {
            for (JRPrintElement element : elements) {
                if (this.filter != null && !this.filter.isToExport(element)) continue;
                if (element instanceof JRPrintFrame) {
                    this.exportFrame((JRPrintFrame)element);
                    continue;
                }
                if (!(element instanceof JRGenericPrintElement)) continue;
                this.exportGenericElement((JRGenericPrintElement)element);
            }
        }
    }

    protected void exportFrame(JRPrintFrame frame) throws IOException {
        this.exportElements(frame.getElements());
    }

    protected void exportGenericElement(JRGenericPrintElement element) throws IOException {
        GenericElementJsonHandler handler = (GenericElementJsonHandler)GenericElementHandlerEnviroment.getInstance(this.getJasperReportsContext()).getElementHandler(element.getGenericType(), JSON_EXPORTER_KEY);
        if (handler != null) {
            String fragment = handler.getJsonFragment(this.exporterContext, element);
            if (fragment != null && !fragment.isEmpty()) {
                if (this.gotFirstJsonFragment) {
                    this.writer.write(",\n");
                } else {
                    this.gotFirstJsonFragment = true;
                }
                this.writer.write(fragment);
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("No JSON generic element handler for " + element.getGenericType()));
        }
    }

    protected class ExporterContext
    extends JRAbstractExporter.BaseExporterContext
    implements JsonExporterContext {
        protected ExporterContext() {
        }

        @Override
        public String getExportPropertiesPrefix() {
            return JsonExporter.JSON_EXPORTER_PROPERTIES_PREFIX;
        }

        @Override
        public String getHyperlinkURL(JRPrintHyperlink link) {
            return HtmlExporter.resolveHyperlinkURL(JsonExporter.this, JsonExporter.this.reportIndex, link);
        }
    }
}

