/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ddf.EscherComplexProperty;
import org.apache.poi.ddf.EscherOptRecord;
import org.apache.poi.ddf.EscherProperty;
import org.apache.poi.hssf.record.EscherAggregate;
import org.apache.poi.hssf.usermodel.HSSFAnchor;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFComment;
import org.apache.poi.hssf.usermodel.HSSFPicture;
import org.apache.poi.hssf.usermodel.HSSFPolygon;
import org.apache.poi.hssf.usermodel.HSSFShape;
import org.apache.poi.hssf.usermodel.HSSFShapeContainer;
import org.apache.poi.hssf.usermodel.HSSFShapeGroup;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFSimpleShape;
import org.apache.poi.hssf.usermodel.HSSFTextbox;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HSSFPatriarch
implements HSSFShapeContainer,
Drawing {
    private final List<HSSFShape> _shapes = new ArrayList<HSSFShape>();
    private int _x1 = 0;
    private int _y1 = 0;
    private int _x2 = 1023;
    private int _y2 = 255;
    private EscherAggregate _boundAggregate;
    final HSSFSheet _sheet;

    HSSFPatriarch(HSSFSheet sheet, EscherAggregate boundAggregate) {
        this._sheet = sheet;
        this._boundAggregate = boundAggregate;
    }

    public HSSFShapeGroup createGroup(HSSFClientAnchor anchor) {
        HSSFShapeGroup group = new HSSFShapeGroup(null, anchor);
        group.anchor = anchor;
        this._shapes.add(group);
        return group;
    }

    public HSSFSimpleShape createSimpleShape(HSSFClientAnchor anchor) {
        HSSFSimpleShape shape = new HSSFSimpleShape(null, anchor);
        shape.anchor = anchor;
        this._shapes.add(shape);
        return shape;
    }

    public HSSFPicture createPicture(HSSFClientAnchor anchor, int pictureIndex) {
        HSSFPicture shape = new HSSFPicture(null, anchor);
        shape.setPictureIndex(pictureIndex);
        shape.anchor = anchor;
        shape._patriarch = this;
        this._shapes.add(shape);
        return shape;
    }

    @Override
    public HSSFPicture createPicture(ClientAnchor anchor, int pictureIndex) {
        return this.createPicture((HSSFClientAnchor)anchor, pictureIndex);
    }

    public HSSFPolygon createPolygon(HSSFClientAnchor anchor) {
        HSSFPolygon shape = new HSSFPolygon(null, anchor);
        shape.anchor = anchor;
        this._shapes.add(shape);
        return shape;
    }

    public HSSFTextbox createTextbox(HSSFClientAnchor anchor) {
        HSSFTextbox shape = new HSSFTextbox(null, anchor);
        shape.anchor = anchor;
        this._shapes.add(shape);
        return shape;
    }

    public HSSFComment createComment(HSSFAnchor anchor) {
        HSSFComment shape = new HSSFComment(null, anchor);
        shape.anchor = anchor;
        this._shapes.add(shape);
        return shape;
    }

    HSSFSimpleShape createComboBox(HSSFAnchor anchor) {
        HSSFSimpleShape shape = new HSSFSimpleShape(null, anchor);
        shape.setShapeType(20);
        shape.anchor = anchor;
        this._shapes.add(shape);
        return shape;
    }

    @Override
    public HSSFComment createCellComment(ClientAnchor anchor) {
        return this.createComment((HSSFAnchor)((Object)anchor));
    }

    @Override
    public List<HSSFShape> getChildren() {
        return this._shapes;
    }

    public int countOfAllChildren() {
        int count = this._shapes.size();
        for (HSSFShape shape : this._shapes) {
            count += shape.countOfAllChildren();
        }
        return count;
    }

    public void setCoordinates(int x1, int y1, int x2, int y2) {
        this._x1 = x1;
        this._y1 = y1;
        this._x2 = x2;
        this._y2 = y2;
    }

    public boolean containsChart() {
        EscherOptRecord optRecord = (EscherOptRecord)this._boundAggregate.findFirstWithId((short)-4085);
        if (optRecord == null) {
            return false;
        }
        for (EscherProperty prop : optRecord.getEscherProperties()) {
            EscherComplexProperty cp;
            String str;
            if (prop.getPropertyNumber() != 896 || !prop.isComplex() || !(str = StringUtil.getFromUnicodeLE((cp = (EscherComplexProperty)prop).getComplexData())).equals("Chart 1\u0000")) continue;
            return true;
        }
        return false;
    }

    public int getX1() {
        return this._x1;
    }

    public int getY1() {
        return this._y1;
    }

    public int getX2() {
        return this._x2;
    }

    public int getY2() {
        return this._y2;
    }

    protected EscherAggregate _getBoundAggregate() {
        return this._boundAggregate;
    }
}

