/*
 * Decompiled with CFR 0.152.
 */
package mondrian.calc.impl;

import java.util.ArrayList;
import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.DoubleCalc;
import mondrian.calc.DummyExp;
import mondrian.calc.IntegerCalc;
import mondrian.calc.ListCalc;
import mondrian.calc.MemberCalc;
import mondrian.calc.ResultStyle;
import mondrian.calc.TupleCalc;
import mondrian.calc.impl.AbstractDoubleCalc;
import mondrian.calc.impl.AbstractExpCompiler;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.calc.impl.AbstractTupleCalc;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Member;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.TupleType;
import mondrian.olap.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BetterExpCompiler
extends AbstractExpCompiler {
    public BetterExpCompiler(Evaluator evaluator, Validator validator) {
        super(evaluator, validator);
    }

    public BetterExpCompiler(Evaluator evaluator, Validator validator, List<ResultStyle> resultStyles) {
        super(evaluator, validator, resultStyles);
    }

    @Override
    public DoubleCalc compileDouble(Exp exp) {
        Calc calc = this.compileScalar(exp, false);
        if (calc instanceof DoubleCalc) {
            return (DoubleCalc)calc;
        }
        if (calc instanceof IntegerCalc) {
            final IntegerCalc integerCalc = (IntegerCalc)calc;
            return new AbstractDoubleCalc(exp, new Calc[]{integerCalc}){

                public double evaluateDouble(Evaluator evaluator) {
                    int result = integerCalc.evaluateInteger(evaluator);
                    return result;
                }
            };
        }
        throw Util.newInternal("cannot cast " + exp);
    }

    @Override
    public TupleCalc compileTuple(Exp exp) {
        Calc calc = this.compile(exp);
        Type type = exp.getType();
        if (type instanceof TupleType) {
            assert (calc instanceof TupleCalc);
            return (TupleCalc)calc;
        }
        if (type instanceof MemberType) {
            assert (calc instanceof MemberCalc);
            final MemberCalc memberCalc = (MemberCalc)calc;
            return new AbstractTupleCalc(exp, new Calc[]{memberCalc}){

                public Member[] evaluateTuple(Evaluator evaluator) {
                    return new Member[]{memberCalc.evaluateMember(evaluator)};
                }
            };
        }
        throw Util.newInternal("cannot cast " + exp);
    }

    @Override
    public ListCalc compileList(Exp exp, boolean mutable) {
        ListCalc listCalc = super.compileList(exp, mutable);
        if (mutable && listCalc.getResultStyle() == ResultStyle.LIST) {
            return new CopyListCalc(listCalc);
        }
        return listCalc;
    }

    private static class CopyListCalc
    extends AbstractListCalc {
        private final ListCalc listCalc;

        public CopyListCalc(ListCalc listCalc) {
            super(new DummyExp(listCalc.getType()), new Calc[]{listCalc});
            this.listCalc = listCalc;
        }

        public List evaluateList(Evaluator evaluator) {
            List list = this.listCalc.evaluateList(evaluator);
            return new ArrayList(list);
        }
    }
}

