/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.IterCalc;
import mondrian.calc.ListCalc;
import mondrian.calc.ResultStyle;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.calc.impl.GenericCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Hierarchy;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.Resolver;
import mondrian.olap.type.SetType;
import mondrian.olap.type.Type;
import mondrian.olap.type.TypeUtil;
import mondrian.spi.UserDefinedFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UdfResolver
implements Resolver {
    private final UserDefinedFunction udf;
    private static final String[] emptyStringArray = new String[0];

    public UdfResolver(UserDefinedFunction udf) {
        this.udf = udf;
    }

    @Override
    public String getName() {
        return this.udf.getName();
    }

    @Override
    public String getDescription() {
        return this.udf.getDescription();
    }

    @Override
    public String getSignature() {
        Type[] parameterTypes = this.udf.getParameterTypes();
        int[] parameterCategories = new int[parameterTypes.length];
        for (int i = 0; i < parameterCategories.length; ++i) {
            parameterCategories[i] = TypeUtil.typeToCategory(parameterTypes[i]);
        }
        Type returnType = this.udf.getReturnType(parameterTypes);
        int returnCategory = TypeUtil.typeToCategory(returnType);
        return this.getSyntax().getSignature(this.getName(), returnCategory, parameterCategories);
    }

    @Override
    public Syntax getSyntax() {
        return this.udf.getSyntax();
    }

    @Override
    public FunDef getFunDef() {
        Type[] parameterTypes = this.udf.getParameterTypes();
        int[] parameterCategories = new int[parameterTypes.length];
        for (int i = 0; i < parameterCategories.length; ++i) {
            parameterCategories[i] = TypeUtil.typeToCategory(parameterTypes[i]);
        }
        Type returnType = this.udf.getReturnType(parameterTypes);
        return new UdfFunDef(parameterCategories, returnType);
    }

    @Override
    public FunDef resolve(Exp[] args, Validator validator, List<Resolver.Conversion> conversions) {
        Type[] parameterTypes = this.udf.getParameterTypes();
        if (args.length != parameterTypes.length) {
            return null;
        }
        int[] parameterCategories = new int[parameterTypes.length];
        Type[] castArgTypes = new Type[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            Type parameterType = parameterTypes[i];
            Exp arg = args[i];
            Type argType = arg.getType();
            int parameterCategory = TypeUtil.typeToCategory(parameterType);
            if (!validator.canConvert(i, arg, parameterCategory, conversions)) {
                return null;
            }
            parameterCategories[i] = parameterCategory;
            if (parameterType.equals(argType)) continue;
            castArgTypes[i] = FunDefBase.castType(argType, parameterCategory);
        }
        Type returnType = this.udf.getReturnType(castArgTypes);
        return new UdfFunDef(parameterCategories, returnType);
    }

    @Override
    public boolean requiresExpression(int k) {
        return false;
    }

    @Override
    public String[] getReservedWords() {
        String[] reservedWords = this.udf.getReservedWords();
        return reservedWords == null ? emptyStringArray : reservedWords;
    }

    private static class CalcExp
    implements UserDefinedFunction.Argument {
        private final Calc calc;
        private final Calc scalarCalc;
        private final IterCalc iterCalc;
        private final ListCalc listCalc;

        public CalcExp(Calc calc, Calc scalarCalc, ListCalc listCalc, IterCalc iterCalc) {
            this.calc = calc;
            this.scalarCalc = scalarCalc;
            this.listCalc = listCalc;
            this.iterCalc = iterCalc;
        }

        public Type getType() {
            return this.calc.getType();
        }

        public Object evaluate(Evaluator evaluator) {
            return this.calc.evaluate(evaluator);
        }

        public Object evaluateScalar(Evaluator evaluator) {
            return this.scalarCalc.evaluate(evaluator);
        }

        public List evaluateList(Evaluator eval) {
            if (this.listCalc == null) {
                throw new RuntimeException("Expression is not a set");
            }
            return this.listCalc.evaluateList(eval);
        }

        public Iterable evaluateIterable(Evaluator eval) {
            if (this.iterCalc == null) {
                throw new RuntimeException("Expression is not a set");
            }
            return this.iterCalc.evaluateIterable(eval);
        }
    }

    private static class ListCalcImpl
    extends AbstractListCalc {
        private final UserDefinedFunction udf;
        private final UserDefinedFunction.Argument[] args;

        public ListCalcImpl(ResolvedFunCall call, Calc[] calcs, UserDefinedFunction udf, UserDefinedFunction.Argument[] args) {
            super(call, calcs);
            this.udf = udf;
            this.args = args;
        }

        public List evaluateList(Evaluator evaluator) {
            return (List)this.udf.execute(evaluator, this.args);
        }

        public boolean dependsOn(Dimension dimension) {
            return true;
        }
    }

    private static class ScalarCalcImpl
    extends GenericCalc {
        private final Calc[] calcs;
        private final UserDefinedFunction udf;
        private final UserDefinedFunction.Argument[] args;

        public ScalarCalcImpl(ResolvedFunCall call, Calc[] calcs, UserDefinedFunction udf, UserDefinedFunction.Argument[] args) {
            super(call);
            this.calcs = calcs;
            this.udf = udf;
            this.args = args;
        }

        public Calc[] getCalcs() {
            return this.calcs;
        }

        public Object evaluate(Evaluator evaluator) {
            return this.udf.execute(evaluator, this.args);
        }

        public boolean dependsOn(Hierarchy hierarchy) {
            return true;
        }
    }

    private class UdfFunDef
    extends FunDefBase {
        private Type returnType;

        public UdfFunDef(int[] parameterCategories, Type returnType) {
            super(UdfResolver.this, TypeUtil.typeToCategory(returnType), parameterCategories);
            this.returnType = returnType;
        }

        public Type getResultType(Validator validator, Exp[] args) {
            return this.returnType;
        }

        public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
            Exp[] args = call.getArgs();
            Calc[] calcs = new Calc[args.length];
            UserDefinedFunction.Argument[] expCalcs = new UserDefinedFunction.Argument[args.length];
            for (int i = 0; i < args.length; ++i) {
                IterCalc iterCalc;
                ListCalc listCalc;
                Exp arg = args[i];
                Calc calc = compiler.compileAs(arg, UdfFunDef.castType(arg.getType(), this.parameterCategories[i]), ResultStyle.ANY_LIST);
                Calc scalarCalc = compiler.compileScalar(arg, true);
                if (arg.getType() instanceof SetType) {
                    listCalc = compiler.compileList(arg, true);
                    iterCalc = compiler.compileIter(arg);
                } else {
                    listCalc = null;
                    iterCalc = null;
                }
                expCalcs[i] = new CalcExp(calc, scalarCalc, listCalc, iterCalc);
            }
            UserDefinedFunction udf2 = Util.createUdf(UdfResolver.this.udf.getClass(), UdfResolver.this.udf.getName());
            if (call.getType() instanceof SetType) {
                return new ListCalcImpl(call, calcs, udf2, expCalcs);
            }
            return new ScalarCalcImpl(call, calcs, udf2, expCalcs);
        }
    }
}

