/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.oasis;

import java.io.IOException;
import net.sf.jasperreports.engine.export.LengthUtil;
import net.sf.jasperreports.engine.export.oasis.Style;
import net.sf.jasperreports.engine.export.oasis.WriterHelper;

public class TableStyle
extends Style {
    private int width;
    private int reportIndex;
    private boolean isFrame;
    private boolean isPageBreak;

    public TableStyle(WriterHelper styleWriter, int width, int reportIndex, boolean isFrame, boolean isPageBreak) {
        super(styleWriter);
        this.width = width;
        this.reportIndex = reportIndex;
        this.isFrame = isFrame;
        this.isPageBreak = isPageBreak;
    }

    @Override
    public String getId() {
        return this.width + "|" + this.reportIndex + "|" + this.isFrame + "|" + this.isPageBreak;
    }

    @Override
    public void write(String tableStyleName) throws IOException {
        this.styleWriter.write(" <style:style style:name=\"" + tableStyleName + "\"");
        if (!this.isFrame) {
            this.styleWriter.write(" style:master-page-name=\"master_" + this.reportIndex + "\"");
        }
        this.styleWriter.write(" style:family=\"table\">\n");
        this.styleWriter.write("   <style:table-properties");
        this.styleWriter.write(" table:align=\"left\" style:width=\"" + LengthUtil.inch(this.width) + "in\"");
        if (this.isPageBreak) {
            this.styleWriter.write(" fo:break-before=\"page\"");
        }
        this.styleWriter.write("/>\n");
        this.styleWriter.write(" </style:style>\n");
        this.styleWriter.flush();
    }
}

