/*
 * iReport - Visual Designer for JasperReports.
 * Copyright (C) 2002 - 2009 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com
 *
 * Unless you have purchased a commercial license agreement from Jaspersoft,
 * the following license terms apply:
 *
 * This program is part of iReport.
 *
 * iReport is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * iReport is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with iReport. If not, see <http://www.gnu.org/licenses/>.
 */
package com.jaspersoft.ireport.designer.connection.gui;

import com.jaspersoft.ireport.locale.I18n;
import com.jaspersoft.ireport.designer.IReportConnection;
import com.jaspersoft.ireport.designer.IReportConnectionEditor;
import com.jaspersoft.ireport.designer.connection.EJBQLConnection;
import com.jaspersoft.ireport.designer.utils.Misc;


/**
 *
 * @author  gtoffoli
 */
public class EJBQLConnectionEditor extends javax.swing.JPanel implements IReportConnectionEditor {
    
    private IReportConnection iReportConnection = null;
    private boolean init = false;
    
    /** Creates new form EJBQLConnectionEditor */
    public EJBQLConnectionEditor() {
        initComponents();
        //applyI18n();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jPanelEJBQL = new javax.swing.JPanel();
        jLabel18 = new javax.swing.JLabel();
        jTextFieldPersistanceUnit = new javax.swing.JTextField();
        jLabel1 = new javax.swing.JLabel();

        setLayout(new java.awt.BorderLayout());

        jPanelEJBQL.setLayout(new java.awt.GridBagLayout());

        jLabel18.setText(I18n.getString("EJBQLConnectionEditor.Label.UnitName")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 2, 4);
        jPanelEJBQL.add(jLabel18, gridBagConstraints);

        jTextFieldPersistanceUnit.setMargin(new java.awt.Insets(0, 5, 2, 4));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 3, 4);
        jPanelEJBQL.add(jTextFieldPersistanceUnit, gridBagConstraints);

        jLabel1.setText("jLabel1");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanelEJBQL.add(jLabel1, gridBagConstraints);

        add(jPanelEJBQL, java.awt.BorderLayout.CENTER);
    }// </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel18;
    private javax.swing.JPanel jPanelEJBQL;
    private javax.swing.JTextField jTextFieldPersistanceUnit;
    // End of variables declaration//GEN-END:variables
    
    
    public void setIReportConnection(IReportConnection c) {
        
        this.iReportConnection = c;
        if (iReportConnection instanceof EJBQLConnection)
        {
            EJBQLConnection con = (EJBQLConnection)iReportConnection;
            this.jTextFieldPersistanceUnit.setText( Misc.nvl(con.getProperties().get(I18n.getString("EJBQLConnectionEditor.TextField.PersistenceUnit")), "") ); 
        }
    }

    @SuppressWarnings("unchecked")
    public IReportConnection getIReportConnection() {
        
        IReportConnection irConn = new EJBQLConnection();

            if (jTextFieldPersistanceUnit.getText().trim().length() != 0)
            {
                irConn.getProperties().put("PersistenceUnit", jTextFieldPersistanceUnit.getText().trim());
            }
            else
            {
                javax.swing.JOptionPane.showMessageDialog(this,
                        //I18n.getString("messages.connectionDialog.ejbql.invalidPersistenceUnit",
                        I18n.getString("EJBQLConnectionEditor.Message.NoPersistaceUnit"),
                        //I18n.getString("messages.connectionDialog.invalidPersistenceUnitCaption",
                        I18n.getString("EJBQLConnectionEditor.Message.InvalidPersistanceUnit"),javax.swing.JOptionPane.WARNING_MESSAGE );
                return null;
            }

        iReportConnection = irConn;
        return iReportConnection;
    }
    
    /*
    public void applyI18n(){
                // Start autogenerated code ----------------------
                jLabel18.setText(I18n.getString("connectionDialog.label18","Persistance Unit Name"));
                jLabel1.setText("<html>" + I18n.getString("connectionDialog.textPane2","iReport will search for persistence.xml files within the META-INF directory of any CLASSPATH element"));
    }
     */
    
    
}
