/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer;

import java.awt.EventQueue;
import java.io.InputStream;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.xml.JRXmlDigester;
import net.sf.jasperreports.engine.xml.JRXmlDigesterFactory;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import org.apache.commons.digester.Digester;
import org.openide.filesystems.FileObject;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class JrxmlLoader
implements ErrorHandler {
    FileObject file = null;

    public JrxmlLoader(FileObject f) {
        this.file = f;
    }

    public JrxmlLoader() {
        this(null);
    }

    public JasperDesign reloadJasperDesign() throws JRException {
        if (this.file == null) {
            throw new JRException("File not found.");
        }
        try {
            InputStream in = this.file.getInputStream();
            return this.reloadJasperDesign(in);
        }
        catch (JRException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new JRException(ex);
        }
    }

    public JasperDesign reloadJasperDesign(InputStream in) throws JRException {
        if (EventQueue.isDispatchThread()) {
            throw new IllegalStateException("You are trying to load a jrxml file from an event thread. Don't do that.");
        }
        try {
            JRXmlDigester digester = new JRXmlDigester();
            JRXmlDigesterFactory.configureDigester((Digester)digester);
            digester.setErrorHandler((ErrorHandler)this);
            JRXmlLoader xmlLoader = new JRXmlLoader((Digester)digester);
            JasperDesign jasperDesign = xmlLoader.loadXML(in);
            return jasperDesign;
        }
        catch (JRException ex) {
            ex.printStackTrace();
            throw ex;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            throw new JRException(ex);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception ex2) {}
            }
        }
    }

    public void warning(SAXParseException exception) throws SAXException {
        throw exception;
    }

    public void error(SAXParseException exception) throws SAXException {
        throw exception;
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        throw exception;
    }
}

