/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.outline;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.undo.AddStyleUndoableEdit;
import java.io.IOException;
import java.util.List;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import net.sf.jasperreports.engine.design.JRDesignVariable;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.datatransfer.NewType;

class NewObjectType
extends NewType {
    Node parentNode = null;
    int type = -1;

    public NewObjectType(int type, Node parentNode) {
        this.parentNode = parentNode;
        this.type = type;
    }

    public void create() throws IOException {
        JasperDesign jd = (JasperDesign)this.parentNode.getLookup().lookup(JasperDesign.class);
        if (jd == null) {
            return;
        }
        JRDesignDataset dataset = (JRDesignDataset)this.parentNode.getLookup().lookup(JRDesignDataset.class);
        if (dataset == null) {
            dataset = jd.getMainDesignDataset();
        }
        if (dataset == null) {
            return;
        }
        JRDesignParameter obj = null;
        switch (this.type) {
            case 1: {
                try {
                    String baseName;
                    JRDesignParameter p = new JRDesignParameter();
                    String new_name = baseName = "parameter";
                    List list = dataset.getParametersList();
                    boolean found = true;
                    int j = 1;
                    while (found) {
                        found = false;
                        new_name = baseName + j;
                        for (int i = 0; i < list.size(); ++i) {
                            JRDesignParameter tmpP = (JRDesignParameter)list.get(i);
                            if (!tmpP.getName().equals(new_name)) continue;
                            found = true;
                        }
                        ++j;
                    }
                    p.setName(new_name);
                    obj = p;
                    dataset.addParameter((JRParameter)p);
                }
                catch (JRException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                break;
            }
            case 2: {
                try {
                    String baseName;
                    JRDesignField f = new JRDesignField();
                    String new_name = baseName = "field";
                    List list = dataset.getFieldsList();
                    boolean found = true;
                    int j = 1;
                    while (found) {
                        found = false;
                        new_name = baseName + j;
                        for (int i = 0; i < list.size(); ++i) {
                            JRDesignField tmpP = (JRDesignField)list.get(i);
                            if (!tmpP.getName().equals(new_name)) continue;
                            found = true;
                        }
                        ++j;
                    }
                    f.setName(new_name);
                    obj = f;
                    dataset.addField((JRField)f);
                }
                catch (JRException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                break;
            }
            case 4: {
                try {
                    String baseName;
                    JRDesignVariable v = new JRDesignVariable();
                    String new_name = baseName = "variable";
                    List list = dataset.getVariablesList();
                    boolean found = true;
                    int j = 1;
                    while (found) {
                        found = false;
                        new_name = baseName + j;
                        for (int i = 0; i < list.size(); ++i) {
                            JRDesignVariable tmpP = (JRDesignVariable)list.get(i);
                            if (!tmpP.getName().equals(new_name)) continue;
                            found = true;
                        }
                        ++j;
                    }
                    v.setName(new_name);
                    obj = v;
                    dataset.addVariable(v);
                }
                catch (JRException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                break;
            }
            case 8: {
                try {
                    String baseName;
                    JRDesignStyle v = new JRDesignStyle();
                    String new_name = baseName = "style";
                    List list = jd.getStylesList();
                    boolean found = true;
                    int j = 1;
                    while (found) {
                        found = false;
                        new_name = baseName + j;
                        for (int i = 0; i < list.size(); ++i) {
                            JRDesignStyle tmpP = (JRDesignStyle)list.get(i);
                            if (!tmpP.getName().equals(new_name)) continue;
                            found = true;
                        }
                        ++j;
                    }
                    v.setName(new_name);
                    obj = v;
                    jd.addStyle((JRStyle)v);
                    AddStyleUndoableEdit undo = new AddStyleUndoableEdit(v, jd);
                    IReportManager.getInstance().addUndoableEdit(undo);
                    break;
                }
                catch (JRException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        if (obj != null) {
            IReportManager.getInstance().setSelectedObject(obj);
        }
    }

    public String getName() {
        switch (this.type) {
            case 1: {
                return "Parameter";
            }
            case 2: {
                return "Field";
            }
            case 4: {
                return "Variable";
            }
            case 8: {
                return "Style";
            }
        }
        return super.getName();
    }
}

