/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ListCalc;
import mondrian.calc.impl.AbstractStringCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Member;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.type.SetType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SetToStrFunDef
extends FunDefBase {
    public static final FunDefBase instance = new SetToStrFunDef();

    private SetToStrFunDef() {
        super("SetToStr", "SetToStr(<Set>)", "Constructs a string from a set.", "fSx");
    }

    @Override
    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        Exp arg = call.getArg(0);
        final ListCalc listCalc = compiler.compileList(arg);
        if (((SetType)arg.getType()).getArity() == 1) {
            return new AbstractStringCalc(call, new Calc[]{listCalc}){

                public String evaluateString(Evaluator evaluator) {
                    List list = listCalc.evaluateList(evaluator);
                    return SetToStrFunDef.memberSetToStr(list);
                }
            };
        }
        return new AbstractStringCalc(call, new Calc[]{listCalc}){

            public String evaluateString(Evaluator evaluator) {
                List list = listCalc.evaluateList(evaluator);
                return SetToStrFunDef.tupleSetToStr(list);
            }
        };
    }

    static String memberSetToStr(List<Member> list) {
        StringBuilder buf = new StringBuilder();
        buf.append("{");
        int k = 0;
        for (Member member : list) {
            if (k++ > 0) {
                buf.append(", ");
            }
            buf.append(member.getUniqueName());
        }
        buf.append("}");
        return buf.toString();
    }

    static String tupleSetToStr(List<Member[]> list) {
        StringBuilder buf = new StringBuilder();
        buf.append("{");
        int k = 0;
        for (Member[] members : list) {
            if (k++ > 0) {
                buf.append(", ");
            }
            SetToStrFunDef.appendTuple(buf, members);
        }
        buf.append("}");
        return buf.toString();
    }
}

