/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer;

import com.jaspersoft.ireport.designer.IRFont;
import com.jaspersoft.ireport.designer.IReportConnection;
import com.jaspersoft.ireport.designer.JrxmlVisualView;
import com.jaspersoft.ireport.designer.ReportClassLoader;
import com.jaspersoft.ireport.designer.connection.JREmptyDatasourceConnection;
import com.jaspersoft.ireport.designer.data.queryexecuters.QueryExecuterDef;
import com.jaspersoft.ireport.designer.fonts.TTFFontsLoader;
import com.jaspersoft.ireport.designer.fonts.TTFFontsLoaderMonitor;
import com.jaspersoft.ireport.designer.outline.OutlineTopComponent;
import com.jaspersoft.ireport.designer.undo.AggregatedUndoableEdit;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.UndoableEdit;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.design.JRDesignChartDataset;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.util.JRProperties;
import org.apache.xerces.parsers.DOMParser;
import org.openide.awt.StatusDisplayer;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IReportManager {
    public static final String PROPERTY_CONNECTIONS = "PROPERTY_CONNECTIONS";
    public static final String PROPERTY_DEFAULT_CONNECTION = "PROPERTY_DEFAULT_CONNECTION";
    public static final String CURRENT_DIRECTORY = "CURRENT_DIRECTORY";
    public static final String IREPORT_CLASSPATH = "IREPORT_CLASSPATH";
    public static final String IREPORT_FONTPATH = "IREPORT_FONTPATH";
    public static final String DEFAULT_CONNECTION_NAME = "DEFAULT_CONNECTION_NAME";
    public static final String USE_AUTO_REGISTER_FIELDS = "UseAutoRegiesterFields";
    private static ReportClassLoader reportClassLoader = null;
    private static IReportManager mainInstance = null;
    private ArrayList<IReportConnection> connections = null;
    private ArrayList<QueryExecuterDef> queryExecuters = null;
    private List<IRFont> fonts = null;
    private HashMap parameterValues = new HashMap();
    private List connectionImplementations = null;
    private IReportConnection defaultConnection = null;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private JRDesignChartDataset chartDatasetClipBoard = null;
    private List chartSeriesClipBoard = null;
    private UndoableEdit lastUndoableEdit = null;
    private long lastUndoableEditTime = 0L;

    public List<IRFont> getFonts() {
        return this.fonts;
    }

    public void setFonts(List<IRFont> fonts) {
        this.fonts = fonts;
    }

    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.propertyChangeSupport;
    }

    private IReportManager() {
    }

    private void initialize() {
        JRProperties.setProperty((String)"net.sf.jasperreports.query.executer.factory.xmla-mdx", (String)"net.sf.jasperreports.engine.query.JRXmlaQueryExecuterFactory");
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                ((ReportClassLoader)IReportManager.getReportClassLoader()).rescanAdditionalClasspath();
                Thread.currentThread().setContextClassLoader(IReportManager.getReportClassLoader());
                IReportManager.this.setFonts(TTFFontsLoader.loadTTFFonts(new TTFFontsLoaderMonitor(){

                    public void fontsLoadingStarted() {
                    }

                    public void fontsLoadingStatusUpdated(String statusMsg) {
                        StatusDisplayer.getDefault().setStatusText(statusMsg);
                    }

                    public void fontsLoadingFinished() {
                        StatusDisplayer.getDefault().setStatusText("");
                    }
                }));
            }
        });
    }

    public static IReportManager getInstance() {
        if (mainInstance == null) {
            mainInstance = new IReportManager();
            Thread.currentThread().setContextClassLoader(IReportManager.getReportClassLoader());
            mainInstance.initialize();
        }
        return mainInstance;
    }

    public List<IReportConnection> getConnections() {
        if (this.connections == null) {
            String s;
            this.connections = new ArrayList();
            int i = 0;
            while ((s = IReportManager.getPreferences().get("connection." + i, null)) != null) {
                IReportConnection con = this.loadConnection(s);
                if (con != null) {
                    this.connections.add(con);
                }
                ++i;
            }
            if (this.connections.size() == 0) {
                JREmptyDatasourceConnection c = new JREmptyDatasourceConnection();
                c.setName("Empty datasource");
                this.connections.add(c);
                this.saveiReportConfiguration();
            }
        }
        return this.connections;
    }

    public void addConnection(IReportConnection con) {
        this.getConnections().add(con);
        this.saveiReportConfiguration();
        this.propertyChangeSupport.firePropertyChange(PROPERTY_CONNECTIONS, null, this.getConnections());
    }

    public void removeConnection(IReportConnection con) {
        this.getConnections().remove(con);
        this.propertyChangeSupport.firePropertyChange(PROPERTY_CONNECTIONS, null, this.getConnections());
    }

    public IReportConnection loadConnection(String xml) {
        try {
            Element node;
            DOMParser parser = new DOMParser();
            InputSource input_sss = new InputSource(new StringReader(xml));
            parser.parse(input_sss);
            Document document = parser.getDocument();
            Element connectionNode = node = document.getDocumentElement();
            if (connectionNode.getNodeName() != null && connectionNode.getNodeName().equals("iReportConnection")) {
                String connectionName = "";
                String connectionClass = "";
                HashMap<String, String> hm = new HashMap<String, String>();
                NamedNodeMap nnm = connectionNode.getAttributes();
                if (nnm.getNamedItem("name") != null) {
                    connectionName = nnm.getNamedItem("name").getNodeValue();
                }
                if (nnm.getNamedItem("connectionClass") != null) {
                    connectionClass = nnm.getNamedItem("connectionClass").getNodeValue();
                }
                NodeList list_child2 = connectionNode.getChildNodes();
                for (int ck2 = 0; ck2 < list_child2.getLength(); ++ck2) {
                    String parameterName = "";
                    org.w3c.dom.Node child_child = list_child2.item(ck2);
                    if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("connectionParameter")) continue;
                    NamedNodeMap nnm2 = child_child.getAttributes();
                    if (nnm2.getNamedItem("name") != null) {
                        parameterName = nnm2.getNamedItem("name").getNodeValue();
                    }
                    hm.put(parameterName, Misc.readPCDATA(child_child));
                }
                try {
                    IReportConnection con = (IReportConnection)Class.forName(connectionClass).newInstance();
                    con.loadProperties(hm);
                    con.setName(connectionName);
                    return con;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public IReportConnection getDefaultConnection() {
        if (this.defaultConnection == null && this.connections.size() > 0) {
            String defaultConnectionName = IReportManager.getPreferences().get(DEFAULT_CONNECTION_NAME, null);
            if (defaultConnectionName != null) {
                for (IReportConnection con : this.getConnections()) {
                    if (con.getName() == null || !con.getName().equals(defaultConnectionName)) continue;
                    this.defaultConnection = con;
                    break;
                }
            }
            if (this.defaultConnection == null) {
                this.defaultConnection = this.connections.get(0);
            }
        }
        return this.defaultConnection;
    }

    public void setDefaultConnection(IReportConnection connection) {
        IReportConnection con = this.getDefaultConnection();
        this.defaultConnection = connection;
        if (this.defaultConnection == null) {
            IReportManager.getPreferences().remove(DEFAULT_CONNECTION_NAME);
        } else {
            IReportManager.getPreferences().put(DEFAULT_CONNECTION_NAME, this.defaultConnection.getName());
        }
        this.propertyChangeSupport.firePropertyChange(PROPERTY_DEFAULT_CONNECTION, con, this.defaultConnection);
    }

    public void saveiReportConfiguration() {
        try {
            int i = 0;
            for (IReportConnection con : this.getConnections()) {
                StringWriter sw = new StringWriter();
                con.save(new PrintWriter(sw));
                IReportManager.getPreferences().put("connection." + i, sw.toString());
                ++i;
            }
            IReportManager.getPreferences().flush();
        }
        catch (BackingStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public List getConnectionImplementations() {
        if (this.connectionImplementations == null) {
            this.connectionImplementations = new ArrayList();
            this.addDefaultConnectionImplementations();
        }
        return this.connectionImplementations;
    }

    public boolean addConnectionImplementation(String className) {
        if (this.getConnectionImplementations().contains(className)) {
            return true;
        }
        try {
            Class.forName(className, true, IReportManager.getReportClassLoader());
            this.getConnectionImplementations().add(className);
            return true;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
    }

    public static ClassLoader getReportClassLoader() {
        if (reportClassLoader == null) {
            ClassLoader syscl = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            reportClassLoader = new ReportClassLoader(syscl);
        }
        return reportClassLoader;
    }

    public void setSelectedObject(Object obj) {
        Node root = OutlineTopComponent.getDefault().getExplorerManager().getRootContext();
        Node node = null;
        node = obj == null ? root : this.findNodeOf(obj, root);
        if (node != null) {
            try {
                OutlineTopComponent.getDefault().getExplorerManager().setSelectedNodes(new Node[]{node});
            }
            catch (PropertyVetoException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public Node findNodeOf(Object obj, Node root) {
        if (obj == null || root == null) {
            return null;
        }
        if (root.getLookup().lookup(obj.getClass()) == obj) {
            return root;
        }
        Node[] children = root.getChildren().getNodes(true);
        for (int i = 0; i < children.length; ++i) {
            Node res = this.findNodeOf(obj, children[i]);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    private void addDefaultConnectionImplementations() {
        this.addConnectionImplementation("com.jaspersoft.ireport.designer.connection.JDBCConnection");
        this.addConnectionImplementation("com.jaspersoft.ireport.designer.connection.JDBCNBConnection");
        this.addConnectionImplementation("com.jaspersoft.ireport.designer.connection.JRXMLDataSourceConnection");
        this.addConnectionImplementation("com.jaspersoft.ireport.designer.connection.JavaBeanDataSourceConnection");
        this.addConnectionImplementation("com.jaspersoft.ireport.designer.connection.JRCSVDataSourceConnection");
        this.addConnectionImplementation("com.jaspersoft.ireport.designer.connection.JRDataSourceProviderConnection");
        this.addConnectionImplementation("com.jaspersoft.ireport.designer.connection.JRCustomDataSourceConnection");
        this.addConnectionImplementation("com.jaspersoft.ireport.designer.connection.JREmptyDatasourceConnection");
        this.addConnectionImplementation("com.jaspersoft.ireport.designer.connection.JRHibernateConnection");
        this.addConnectionImplementation("com.jaspersoft.ireport.designer.connection.JRSpringLoadedHibernateConnection");
        this.addConnectionImplementation("com.jaspersoft.ireport.designer.connection.EJBQLConnection");
        this.addConnectionImplementation("com.jaspersoft.ireport.designer.connection.JRXMLADataSourceConnection");
        this.addConnectionImplementation("com.jaspersoft.ireport.designer.connection.MondrianConnection");
        this.addConnectionImplementation("com.jaspersoft.ireport.designer.connection.QueryExecuterConnection");
    }

    public String getProperty(String key, String def) {
        return IReportManager.getPreferences().get(key, def);
    }

    public String getProperty(String key) {
        return IReportManager.getPreferences().get(key, null);
    }

    public String getCurrentDirectory() {
        return IReportManager.getPreferences().get(CURRENT_DIRECTORY, System.getProperty("user.dir"));
    }

    public void setCurrentDirectory(String currentDirectory) {
        this.setCurrentDirectory(currentDirectory, true);
    }

    public void setCurrentDirectory(String currentDirectory, boolean save) {
        this.setCurrentDirectory(new File(currentDirectory), save);
    }

    public void setCurrentDirectory(File f, boolean save) {
        String currentDirectory = "";
        if (f == null || !f.exists()) {
            return;
        }
        try {
            currentDirectory = f.isDirectory() ? f.getAbsolutePath() : f.getParentFile().getAbsolutePath();
            if (save) {
                IReportManager.getPreferences().put(CURRENT_DIRECTORY, currentDirectory);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    public static Preferences getPreferences() {
        return NbPreferences.forModule(IReportManager.class);
    }

    public List<String> getClasspath() {
        ArrayList<String> cp = new ArrayList<String>();
        String[] paths = IReportManager.getPreferences().get(IREPORT_CLASSPATH, "").split(";");
        for (int idx = 0; idx < paths.length; ++idx) {
            cp.add(paths[idx]);
        }
        return cp;
    }

    public void setClasspath(List<String> cp) {
        String classpathString = "";
        for (String path : cp) {
            classpathString = classpathString + path + ";";
        }
        IReportManager.getPreferences().put(IREPORT_CLASSPATH, classpathString);
        ((ReportClassLoader)IReportManager.getReportClassLoader()).rescanAdditionalClasspath();
    }

    public void updateConnection(int i, IReportConnection con) {
        this.getConnections().set(i, con);
        this.propertyChangeSupport.firePropertyChange(PROPERTY_CONNECTIONS, null, this.getConnections());
    }

    public ArrayList<QueryExecuterDef> getQueryExecuters() {
        if (this.queryExecuters == null) {
            this.queryExecuters = new ArrayList();
            this.addQueryExecuterDef(new QueryExecuterDef("sql", JRProperties.getProperty((String)"net.sf.jasperreports.query.executer.factory.sql"), "com.jaspersoft.ireport.designer.data.fieldsproviders.SQLFieldsProvider"), true);
            this.addQueryExecuterDef(new QueryExecuterDef("SQL", JRProperties.getProperty((String)"net.sf.jasperreports.query.executer.factory.SQL"), "com.jaspersoft.ireport.designer.data.fieldsproviders.SQLFieldsProvider"), true);
            this.addQueryExecuterDef(new QueryExecuterDef("xPath", JRProperties.getProperty((String)"net.sf.jasperreports.query.executer.factory.xPath"), "com.jaspersoft.ireport.designer.data.fieldsproviders.XMLFieldsProvider"), true);
            this.addQueryExecuterDef(new QueryExecuterDef("XPath", JRProperties.getProperty((String)"net.sf.jasperreports.query.executer.factory.XPath"), "com.jaspersoft.ireport.designer.data.fieldsproviders.XMLFieldsProvider"), true);
            this.addQueryExecuterDef(new QueryExecuterDef("hql", JRProperties.getProperty((String)"net.sf.jasperreports.query.executer.factory.hql"), "com.jaspersoft.ireport.designer.data.fieldsproviders.HQLFieldsProvider"), true);
            this.addQueryExecuterDef(new QueryExecuterDef("mdx", JRProperties.getProperty((String)"net.sf.jasperreports.query.executer.factory.mdx"), "com.jaspersoft.ireport.designer.data.fieldsproviders.HQLFieldsProvider"), true);
            this.addQueryExecuterDef(new QueryExecuterDef("MDX", JRProperties.getProperty((String)"net.sf.jasperreports.query.executer.factory.MDX"), "com.jaspersoft.ireport.designer.data.fieldsproviders.MDXFieldsProvider"), true);
            this.addQueryExecuterDef(new QueryExecuterDef("ejbql", JRProperties.getProperty((String)"net.sf.jasperreports.query.executer.factory.ejbql"), "com.jaspersoft.ireport.designer.data.fieldsproviders.EJBQLFieldsProvider"), true);
            this.addQueryExecuterDef(new QueryExecuterDef("EJBQL", JRProperties.getProperty((String)"net.sf.jasperreports.query.executer.factory.EJBQL"), "com.jaspersoft.ireport.designer.data.fieldsproviders.EJBQLFieldsProvider"), true);
            this.addQueryExecuterDef(new QueryExecuterDef("xmla-mdx", JRProperties.getProperty((String)"net.sf.jasperreports.query.executer.factory.xmla-mdx"), "com.jaspersoft.ireport.designer.data.fieldsproviders.CincomMDXFieldsProvider"), true);
        }
        return this.queryExecuters;
    }

    public boolean addQueryExecuterDef(QueryExecuterDef qed, boolean overrideSameLanguage) {
        if (qed == null) {
            return false;
        }
        boolean found = false;
        for (int i = 0; i < this.getQueryExecuters().size(); ++i) {
            QueryExecuterDef tqe = this.getQueryExecuters().get(i);
            if (!tqe.getLanguage().equals(qed.getLanguage())) continue;
            if (overrideSameLanguage) {
                this.getQueryExecuters().set(i, qed);
                found = true;
                break;
            }
            return false;
        }
        if (!found) {
            this.getQueryExecuters().add(qed);
        }
        JRProperties.setProperty((String)("net.sf.jasperreports.query.executer.factory." + qed.getLanguage()), (String)qed.getClassName());
        return true;
    }

    public JasperDesign getActiveReport() {
        try {
            return OutlineTopComponent.getDefault().getCurrentJrxmlVisualView().getReportDesignerPanel().getJasperDesign();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public List<IRFont> getIRFonts() {
        if (this.fonts == null) {
            this.fonts = TTFFontsLoader.loadTTFFonts();
        }
        return this.fonts;
    }

    public List<String> getFontpath() {
        ArrayList<String> cp = new ArrayList<String>();
        String[] paths = IReportManager.getPreferences().get(IREPORT_FONTPATH, "").split(";");
        for (int idx = 0; idx < paths.length; ++idx) {
            cp.add(paths[idx]);
        }
        return cp;
    }

    public void setFontpath(List<String> cp) {
        String fontpathString = "";
        for (String path : cp) {
            fontpathString = fontpathString + path + ";";
        }
        IReportManager.getPreferences().put(IREPORT_FONTPATH, fontpathString);
        this.fonts = null;
    }

    public JrxmlVisualView getActiveVisualView() {
        return OutlineTopComponent.getDefault().getCurrentJrxmlVisualView();
    }

    public boolean notifyReportChange() {
        return this.getActiveVisualView().getEditorSupport().notifyModified();
    }

    public JRDesignChartDataset getChartDatasetClipBoard() {
        return this.chartDatasetClipBoard;
    }

    public void setChartDatasetClipBoard(JRDesignChartDataset chartDatasetClipBoard) {
        this.chartDatasetClipBoard = chartDatasetClipBoard;
    }

    public List getChartSeriesClipBoard() {
        return this.chartSeriesClipBoard;
    }

    public void setChartSeriesClipBoard(List list) {
        this.chartSeriesClipBoard = list;
    }

    public void addUndoableEdit(UndoableEdit edit) {
        this.addUndoableEdit(edit, false);
    }

    public void addUndoableEdit(UndoableEdit edit, boolean aggregate) {
        if (aggregate && this.lastUndoableEdit != null && this.lastUndoableEdit instanceof AggregatedUndoableEdit && System.currentTimeMillis() - this.lastUndoableEditTime < 100L) {
            ((AggregatedUndoableEdit)this.lastUndoableEdit).concatenate(edit);
            this.lastUndoableEditTime = System.currentTimeMillis();
            return;
        }
        this.lastUndoableEditTime = System.currentTimeMillis();
        this.lastUndoableEdit = edit;
        this.getActiveVisualView().getUndoRedoManager().undoableEditHappened(new UndoableEditEvent(this, edit));
    }

    public UndoableEdit getLastUndoableEdit() {
        return this.lastUndoableEdit;
    }

    public Object getLastParameterValue(JRParameter p) {
        Object o = this.parameterValues.get(p.getName() + " " + p.getValueClassName());
        if (p.getValueClass().isInstance(o)) {
            return o;
        }
        return null;
    }

    public void setLastParameterValue(JRParameter p, Object value) {
        if (p == null || value == null || p.getValueClass() == null) {
            return;
        }
        this.parameterValues.put(p.getName() + " " + p.getValueClassName(), value);
    }
}

