/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.outline.properties;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.undo.ObjectPropertyUndoableEdit;
import java.lang.reflect.InvocationTargetException;
import org.openide.ErrorManager;
import org.openide.nodes.PropertySupport;

public abstract class IntegerProperty
extends PropertySupport.ReadWrite {
    private final Object object;

    public IntegerProperty(Object object) {
        super(null, Integer.class, null, null);
        this.object = object;
        this.setValue("suppressCustomEditor", Boolean.TRUE);
    }

    public void setValue(Object value) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (value instanceof Integer) {
            Integer oldValue = this.getOwnValue();
            Integer newValue = (Integer)value;
            this.validate(newValue);
            this.setValue(newValue);
            ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.object, this.getDisplayName(), Integer.TYPE, oldValue, newValue);
            IReportManager.getInstance().addUndoableEdit(urob);
        }
    }

    public IllegalArgumentException annotateException(String msg) {
        IllegalArgumentException e = new IllegalArgumentException(msg);
        ErrorManager.getDefault().annotate((Throwable)e, 4096, msg, msg, null, null);
        return e;
    }

    public boolean isDefaultValue() {
        Object value = null;
        try {
            value = this.getValue();
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        return this.getDefaultValue() == null && value == null || this.getDefaultValue() != null && this.getDefaultValue().equals(value);
    }

    public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
        this.setValue(this.getDefaultValue());
    }

    public boolean supportsDefaultValue() {
        return true;
    }

    public abstract Integer getOwnValue();

    public abstract Integer getDefaultValue();

    public abstract void setValue(Integer var1);

    public abstract void validate(Integer var1);
}

