/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.palette;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.outline.OutlineTopComponent;
import com.jaspersoft.ireport.designer.palette.PaletteItemAction;
import java.awt.Image;
import java.awt.dnd.DropTargetDropEvent;
import java.util.Properties;
import org.netbeans.api.visual.widget.Scene;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class PaletteItem {
    private Properties props;
    private Image icon16;
    private Image icon32;
    private Object data = null;
    public static final String PROP_ID = "id";
    public static final String PROP_NAME = "name";
    public static final String PROP_COMMENT = "tooltip";
    public static final String PROP_ICON16 = "icon16";
    public static final String PROP_ICON32 = "icon32";
    public static final String ACTION = "action";

    public PaletteItem(Properties props) {
        this.props = props;
        this.loadIcons();
    }

    public String getId() {
        return this.props.getProperty(PROP_ID);
    }

    public String getDisplayName() {
        if (this.props.getProperty(PROP_NAME) != null) {
            try {
                return NbBundle.getMessage(PaletteItem.class, (String)this.props.getProperty(PROP_NAME));
            }
            catch (Exception ex) {
                return this.props.getProperty(PROP_NAME);
            }
        }
        return null;
    }

    public String getComment() {
        if (this.props.getProperty(PROP_COMMENT) != null) {
            try {
                return NbBundle.getMessage(PaletteItem.class, (String)this.props.getProperty(PROP_COMMENT));
            }
            catch (Exception ex) {
                return this.props.getProperty(PROP_COMMENT);
            }
        }
        return null;
    }

    public Image getSmallImage() {
        return this.icon16;
    }

    public Image getBigImage() {
        return this.icon32;
    }

    public boolean equals(Object obj) {
        if (obj instanceof PaletteItem) {
            return this.getId().equals(((PaletteItem)obj).getId());
        }
        return false;
    }

    private void loadIcons() {
        String iconId = this.props.getProperty(PROP_ICON16);
        if (iconId == null) {
            return;
        }
        this.icon16 = Utilities.loadImage((String)iconId);
        iconId = this.props.getProperty(PROP_ICON32);
        this.icon32 = Utilities.loadImage((String)iconId);
    }

    public void drop(DropTargetDropEvent dtde) {
        if (this.props.getProperty(ACTION) != null) {
            try {
                PaletteItemAction pia = (PaletteItemAction)Class.forName(this.props.getProperty(ACTION), true, Thread.currentThread().getContextClassLoader()).newInstance();
                pia.setJasperDesign(IReportManager.getInstance().getActiveReport());
                pia.setPaletteItem(this);
                pia.setScene((Scene)OutlineTopComponent.getDefault().getCurrentJrxmlVisualView().getReportDesignerPanel().getScene());
                pia.drop(dtde);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }
}

