/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.highlighting;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import javax.swing.text.AttributeSet;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.spi.editor.highlighting.HighlightsChangeEvent;
import org.netbeans.spi.editor.highlighting.HighlightsChangeListener;
import org.netbeans.spi.editor.highlighting.HighlightsContainer;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.netbeans.spi.editor.highlighting.support.AbstractHighlightsContainer;

public final class ProxyHighlightsContainer
extends AbstractHighlightsContainer {
    private static final Logger LOG = Logger.getLogger(ProxyHighlightsContainer.class.getName());
    private HighlightsContainer[] layers;
    private boolean[] blacklisted;
    private long version = 0L;
    private final String LOCK = new String("ProxyHighlightsContainer.LOCK");
    private final LayerListener listener = new LayerListener(this);

    public ProxyHighlightsContainer() {
        this(null);
    }

    public ProxyHighlightsContainer(HighlightsContainer[] highlightsContainerArray) {
        this.setLayers(highlightsContainerArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HighlightsSequence getHighlights(int n, int n2) {
        assert (0 <= n) : "offsets must be greater than or equal to zero";
        assert (n <= n2) : "startOffset must be less than or equal to endOffset; startOffset = " + n + " endOffset = " + n2;
        String string = this.LOCK;
        synchronized (string) {
            if (this.layers == null || this.layers.length == 0 || n == n2) {
                return HighlightsSequence.EMPTY;
            }
            ArrayList<HighlightsSequence> arrayList = new ArrayList<HighlightsSequence>(this.layers.length);
            for (int i = 0; i < this.layers.length; ++i) {
                if (this.blacklisted[i]) continue;
                arrayList.add(this.layers[this.layers.length - i - 1].getHighlights(n, n2));
                continue;
            }
            return new ProxySeq(this.version, arrayList, n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HighlightsContainer[] getLayers() {
        String string = this.LOCK;
        synchronized (string) {
            return this.layers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLayers(HighlightsContainer[] highlightsContainerArray) {
        String string = this.LOCK;
        synchronized (string) {
            int n;
            if (this.layers != null) {
                for (n = 0; n < this.layers.length; ++n) {
                    this.layers[n].removeHighlightsChangeListener(this.listener);
                }
            }
            this.layers = highlightsContainerArray;
            this.blacklisted = highlightsContainerArray == null ? null : new boolean[highlightsContainerArray.length];
            ++this.version;
            if (this.layers != null) {
                for (n = 0; n < this.layers.length; ++n) {
                    this.layers[n].addHighlightsChangeListener(this.listener);
                }
            }
        }
        this.fireHighlightsChange(0, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void layerChanged(HighlightsContainer highlightsContainer, int n, int n2) {
        String string = this.LOCK;
        synchronized (string) {
            ++this.version;
        }
        this.fireHighlightsChange(n, n2);
    }

    private static final class LayerListener
    implements HighlightsChangeListener {
        private WeakReference<ProxyHighlightsContainer> ref;

        public LayerListener(ProxyHighlightsContainer proxyHighlightsContainer) {
            this.ref = new WeakReference<ProxyHighlightsContainer>(proxyHighlightsContainer);
        }

        public void highlightChanged(HighlightsChangeEvent highlightsChangeEvent) {
            ProxyHighlightsContainer proxyHighlightsContainer = (ProxyHighlightsContainer)this.ref.get();
            if (proxyHighlightsContainer != null) {
                proxyHighlightsContainer.layerChanged((HighlightsContainer)highlightsChangeEvent.getSource(), highlightsChangeEvent.getStartOffset(), highlightsChangeEvent.getEndOffset());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ProxySeq
    implements HighlightsSequence {
        private Sequence2Marks[] marks;
        private int index1 = -1;
        private int index2 = -1;
        private AttributeSet compositeAttributes = null;
        private long version;

        public ProxySeq(long l, List<HighlightsSequence> list, int n, int n2) {
            this.version = l;
            this.marks = new Sequence2Marks[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                this.marks[i] = new Sequence2Marks(list.get(i), n, n2);
                this.marks[i].moveNext();
            }
            this.index2 = this.findLowest();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean moveNext() {
            String string = ProxyHighlightsContainer.this.LOCK;
            synchronized (string) {
                this.checkVersion();
                do {
                    this.index1 = this.index2;
                    if (this.index2 != -1) {
                        this.marks[this.index2].moveNext();
                        this.index2 = this.findLowest();
                    }
                    if (this.index1 == -1 || this.index2 == -1) break;
                    this.compositeAttributes = this.findAttributes();
                } while (this.compositeAttributes == null);
                return this.index1 != -1 && this.index2 != -1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getStartOffset() {
            String string = ProxyHighlightsContainer.this.LOCK;
            synchronized (string) {
                this.checkVersion();
                if (this.index1 == -1 || this.index2 == -1) {
                    throw new NoSuchElementException();
                }
                return this.marks[this.index1].getPreviousMarkOffset();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getEndOffset() {
            String string = ProxyHighlightsContainer.this.LOCK;
            synchronized (string) {
                this.checkVersion();
                if (this.index1 == -1 || this.index2 == -1) {
                    throw new NoSuchElementException();
                }
                return this.marks[this.index2].getMarkOffset();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AttributeSet getAttributes() {
            String string = ProxyHighlightsContainer.this.LOCK;
            synchronized (string) {
                this.checkVersion();
                if (this.index1 == -1 || this.index2 == -1) {
                    throw new NoSuchElementException();
                }
                return this.compositeAttributes;
            }
        }

        private int findLowest() {
            int n = Integer.MAX_VALUE;
            int n2 = -1;
            for (int i = 0; i < this.marks.length; ++i) {
                int n3;
                if (this.marks[i].isFinished() || (n3 = this.marks[i].getMarkOffset()) >= n) continue;
                n = n3;
                n2 = i;
            }
            return n2;
        }

        private AttributeSet findAttributes() {
            ArrayList<AttributeSet> arrayList = new ArrayList<AttributeSet>();
            for (int i = 0; i < this.marks.length; ++i) {
                if (this.marks[i].getPreviousMarkAttributes() == null) continue;
                arrayList.add(this.marks[i].getPreviousMarkAttributes());
            }
            if (!arrayList.isEmpty()) {
                return AttributesUtilities.createComposite((AttributeSet[])arrayList.toArray(new AttributeSet[arrayList.size()]));
            }
            return null;
        }

        private void checkVersion() {
            if (this.version != ProxyHighlightsContainer.this.version) {
                throw new ConcurrentModificationException();
            }
        }
    }

    static final class Sequence2Marks {
        private HighlightsSequence seq;
        private int startOffset;
        private int endOffset;
        private boolean hasNext = false;
        private boolean useStartOffset = true;
        private boolean finished = true;
        private int lastEndOffset = -1;
        private int previousMarkOffset = -1;
        private AttributeSet previousMarkAttributes = null;

        public Sequence2Marks(HighlightsSequence highlightsSequence, int n, int n2) {
            this.seq = highlightsSequence;
            this.startOffset = n;
            this.endOffset = n2;
        }

        public boolean isFinished() {
            return this.finished;
        }

        public boolean moveNext() {
            if (!this.useStartOffset || this.hasNext) {
                this.previousMarkOffset = this.getMarkOffset();
                this.previousMarkAttributes = this.getMarkAttributes();
            }
            if (this.useStartOffset) {
                while ((this.hasNext = this.seq.moveNext()) && this.seq.getEndOffset() <= this.startOffset) {
                }
                if (this.hasNext && this.seq.getStartOffset() > this.endOffset) {
                    this.hasNext = false;
                }
                if (this.hasNext) {
                    if (this.lastEndOffset != -1 && this.lastEndOffset < this.seq.getStartOffset()) {
                        this.useStartOffset = false;
                    } else {
                        this.lastEndOffset = this.seq.getEndOffset();
                    }
                } else if (this.lastEndOffset != -1) {
                    this.useStartOffset = false;
                }
            } else {
                if (this.hasNext) {
                    this.lastEndOffset = this.seq.getEndOffset();
                }
                this.useStartOffset = true;
            }
            this.finished = this.useStartOffset && !this.hasNext;
            return !this.finished;
        }

        public int getMarkOffset() {
            if (this.finished) {
                throw new NoSuchElementException();
            }
            return this.useStartOffset ? Math.max(this.startOffset, this.seq.getStartOffset()) : Math.min(this.endOffset, this.lastEndOffset);
        }

        public AttributeSet getMarkAttributes() {
            if (this.finished) {
                throw new NoSuchElementException();
            }
            return this.useStartOffset ? this.seq.getAttributes() : null;
        }

        public int getPreviousMarkOffset() {
            return this.previousMarkOffset;
        }

        public AttributeSet getPreviousMarkAttributes() {
            return this.previousMarkAttributes;
        }
    }
}

