/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.options;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import org.netbeans.modules.editor.options.AbbrevInputPanel;
import org.netbeans.modules.editor.options.AbbrevsEditor;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class AbbrevsEditorPanel
extends JPanel {
    PairStringModel model;
    private AbbrevsEditor editor;
    private FontSizeTable abbrevsTable;
    private JScrollPane abbrevsPane;
    private JButton addButton;
    private JButton editButton;
    private JButton removeButton;

    public AbbrevsEditorPanel(AbbrevsEditor abbrevsEditor) {
        this.editor = abbrevsEditor;
        this.model = new PairStringModel();
        this.initComponents();
        this.abbrevsTable = new FontSizeTable();
        this.abbrevsTable.setBorder(new EmptyBorder(new Insets(8, 8, 8, 8)));
        this.abbrevsTable.setModel(this.model);
        this.abbrevsTable.setShowHorizontalLines(false);
        this.abbrevsTable.setShowVerticalLines(false);
        this.abbrevsTable.setSelectionMode(0);
        TableColumnModel tableColumnModel = this.abbrevsTable.getColumnModel();
        tableColumnModel.getColumn(0).setMaxWidth(3000);
        tableColumnModel.getColumn(0).setPreferredWidth(30);
        tableColumnModel.getColumn(1).setMaxWidth(7000);
        tableColumnModel.getColumn(1).setPreferredWidth(70);
        this.abbrevsPane.setViewportView(this.abbrevsTable);
        this.getAccessibleContext().setAccessibleDescription(this.getBundleString("ACSD_AEP"));
        this.abbrevsTable.getAccessibleContext().setAccessibleName(this.getBundleString("ACSN_AEP_Table"));
        this.abbrevsTable.getAccessibleContext().setAccessibleDescription(this.getBundleString("ACSD_AEP_Table"));
        this.addButton.getAccessibleContext().setAccessibleDescription(this.getBundleString("ACSD_AEP_Add"));
        this.editButton.getAccessibleContext().setAccessibleDescription(this.getBundleString("ACSD_AEP_Edit"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(this.getBundleString("ACSD_AEP_Remove"));
        this.enableButtons(false);
        this.abbrevsTable.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SwingUtilities.getAncestorOfClass(Window.class, AbbrevsEditorPanel.this).setVisible(false);
            }
        }, KeyStroke.getKeyStroke(27, 0), 0);
        this.abbrevsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                if (AbbrevsEditorPanel.this.abbrevsTable.getRowCount() == 0) {
                    AbbrevsEditorPanel.this.enableButtons(false);
                    return;
                }
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                AbbrevsEditorPanel.this.enableButtons(!listSelectionModel.isSelectionEmpty());
            }
        });
    }

    private void enableButtons(boolean bl) {
        this.editButton.setEnabled(bl);
        this.removeButton.setEnabled(bl);
    }

    private String getBundleString(String string) {
        return NbBundle.getMessage(AbbrevsEditorPanel.class, (String)string);
    }

    public void setValue(Map map) {
        if (map != null) {
            this.model.setData(new TreeMap(map));
        } else {
            this.model.setData(new TreeMap());
        }
        if (this.model.getRowCount() > 0) {
            this.abbrevsTable.setRowSelectionInterval(0, 0);
        }
    }

    public Map getValue() {
        return this.model.getData();
    }

    private void notifyEditor() {
        if (this.editor != null) {
            this.editor.customEditorChange();
        }
    }

    private void initComponents() {
        this.abbrevsPane = new JScrollPane();
        this.addButton = new JButton();
        this.editButton = new JButton();
        this.removeButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(new Insets(12, 12, 11, 11)));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.abbrevsPane, gridBagConstraints);
        this.addButton.setMnemonic(this.getBundleString("AEP_Add_Mnemonic").charAt(0));
        this.addButton.setText(this.getBundleString("AEP_Add"));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbbrevsEditorPanel.this.addButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.addButton, gridBagConstraints);
        this.editButton.setMnemonic(this.getBundleString("AEP_Edit_Mnemonic").charAt(0));
        this.editButton.setText(this.getBundleString("AEP_Edit"));
        this.editButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbbrevsEditorPanel.this.editButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.editButton, gridBagConstraints);
        this.removeButton.setMnemonic(this.getBundleString("AEP_Remove_Mnemonic").charAt(0));
        this.removeButton.setText(this.getBundleString("AEP_Remove"));
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbbrevsEditorPanel.this.removeButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.add((Component)this.removeButton, gridBagConstraints);
    }

    private void addButtonActionPerformed(ActionEvent actionEvent) {
        String[] stringArray = this.getAbbrev(null);
        if (stringArray == null) {
            return;
        }
        int n = this.model.putPair(stringArray);
        this.abbrevsTable.setRowSelectionInterval(n, n);
        this.notifyEditor();
    }

    private void editButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.abbrevsTable.getSelectedRow();
        if (n != -1) {
            String[] stringArray = this.model.getPair(n);
            if ((stringArray = this.getAbbrev(stringArray)) != null) {
                this.model.removePair(n);
                n = this.model.putPair(stringArray);
                this.abbrevsTable.setRowSelectionInterval(n, n);
                this.notifyEditor();
            }
        }
    }

    private void removeButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.abbrevsTable.getSelectedRow();
        if (n != -1) {
            this.model.removePair(n);
            if (n >= this.model.getRowCount()) {
                --n;
            }
            if (n >= 0) {
                this.abbrevsTable.setRowSelectionInterval(n, n);
            }
            this.notifyEditor();
        }
    }

    private String[] getAbbrev(String[] stringArray) {
        String[] stringArray2;
        AbbrevInputPanel abbrevInputPanel = new AbbrevInputPanel();
        HelpCtx.setHelpIDString((JComponent)abbrevInputPanel, HelpCtx.findHelp((Component)this) != null ? HelpCtx.findHelp((Component)this).getHelpID() : null);
        if (stringArray != null) {
            abbrevInputPanel.setAbbrev(stringArray);
        }
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)abbrevInputPanel, this.getBundleString("AEP_EnterAbbrev"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        abbrevInputPanel.requestFocus();
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION && !"".equals((stringArray2 = abbrevInputPanel.getAbbrev())[0])) {
            int n = this.model.containsKey(stringArray2[0]);
            if (n >= 0) {
                if (stringArray != null && stringArray[0].equals(stringArray2[0])) {
                    return stringArray2;
                }
                String[] stringArray3 = this.model.getPair(n);
                NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(AbbrevsEditorPanel.class, (String)"AEP_Overwrite", (Object[])new Object[]{stringArray2[0], stringArray3[1], stringArray2[1]}), 0, 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
                if (confirmation.getValue() != NotifyDescriptor.YES_OPTION) {
                    return null;
                }
            }
            return stringArray2;
        }
        return null;
    }

    private final class FontSizeTable
    extends JTable {
        private boolean needCalcRowHeight = true;

        public void updateUI() {
            super.updateUI();
            this.needCalcRowHeight = true;
        }

        public void paint(Graphics graphics) {
            if (this.needCalcRowHeight) {
                this.calcRowHeight(graphics);
            }
            super.paint(graphics);
        }

        private void calcRowHeight(Graphics graphics) {
            Font font = this.getFont();
            FontMetrics fontMetrics = graphics.getFontMetrics(font);
            int n = fontMetrics.getHeight();
            this.needCalcRowHeight = false;
            this.setRowHeight(n);
        }
    }

    private class PairStringModel
    extends AbstractTableModel {
        String[] columns;
        TreeMap data;
        String[] keys;

        public PairStringModel() {
            this.columns = new String[]{AbbrevsEditorPanel.this.getBundleString("AEP_AbbrevTitle"), AbbrevsEditorPanel.this.getBundleString("AEP_ExpandTitle")};
            this.data = new TreeMap();
            this.keys = new String[0];
        }

        public void setData(TreeMap treeMap) {
            this.data = treeMap;
            this.updateKeys();
        }

        private void updateKeys() {
            this.keys = this.data.keySet().toArray(new String[0]);
            this.fireTableDataChanged();
        }

        public TreeMap getData() {
            return this.data;
        }

        public int getRowCount() {
            return this.keys.length;
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int n) {
            return this.columns[n];
        }

        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return this.keys[n];
            }
            return this.data.get(this.keys[n]);
        }

        public int putPair(String[] stringArray) {
            this.data.put(stringArray[0], stringArray[1]);
            this.updateKeys();
            return Arrays.binarySearch(this.keys, stringArray[0]);
        }

        public void removePair(int n) {
            this.data.remove(this.getValueAt(n, 0));
            this.updateKeys();
        }

        public String[] getPair(int n) {
            String string = (String)this.getValueAt(n, 0);
            String[] stringArray = new String[]{string, (String)this.data.get(string)};
            return stringArray;
        }

        public int containsKey(String string) {
            return Arrays.binarySearch(this.keys, string);
        }
    }
}

