/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Caret;
import org.netbeans.beaninfo.ExplorerPanel;
import org.netbeans.beaninfo.editors.DataFolderEditor;
import org.openide.awt.Mnemonics;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.RepositoryNodeFactory;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.NbCollections;
import org.openide.windows.TopComponent;

class DataFolderPanel
extends TopComponent
implements DocumentListener,
DataFilter,
PropertyChangeListener,
VetoableChangeListener {
    static Dimension PREF_DIM = new Dimension(450, 250);
    private ChangeListener listener;
    Reference<FileSystem> system = new WeakReference<Object>(null);
    private Node rootNode;
    private DataFolder df;
    private DataFolderEditor editor;
    private static final String PATH_TOKEN_DELIMITER = "/" + File.separatorChar;
    private String last_suggestion = "";
    private BeanTreeView beanTreeView;
    private JButton createButton;
    private JLabel descriptionLabel;
    private JLabel dirLabel;
    private JTextField directoryName;
    private JLabel packageLabel;
    private JTextField packageName;
    private ExplorerPanel packagesPanel;

    public DataFolderPanel(DataFolderEditor dataFolderEditor) {
        this();
        this.editor = dataFolderEditor;
        this.editor.env.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
        this.editor.env.addPropertyChangeListener((PropertyChangeListener)this);
    }

    public DataFolderPanel() {
        this.initComponents();
        this.setName(DataFolderPanel.getString("LAB_TargetLocationPanelName"));
        this.setBorder(new EmptyBorder(new Insets(12, 12, 0, 11)));
        this.rootNode = this.createPackagesNode();
        this.beanTreeView.setRootVisible(false);
        this.packagesPanel.getExplorerManager().setRootContext(this.rootNode);
        this.packagesPanel.getExplorerManager().addPropertyChangeListener((PropertyChangeListener)this);
        this.packagesPanel.getExplorerManager().addVetoableChangeListener((VetoableChangeListener)this);
        this.packageName.getDocument().addDocumentListener(this);
        this.packageName.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0));
        this.beanTreeView.getAccessibleContext().setAccessibleDescription(DataFolderPanel.getString("ACSD_DataFolderTree"));
        this.packageName.getAccessibleContext().setAccessibleDescription(DataFolderPanel.getString("ACSD_package"));
        this.directoryName.getAccessibleContext().setAccessibleDescription(DataFolderPanel.getString("ACSD_directory"));
        this.createButton.getAccessibleContext().setAccessibleDescription(DataFolderPanel.getString("ACSD_Create"));
        this.getAccessibleContext().setAccessibleDescription(DataFolderPanel.getString("ACSD_DataFolderPanel"));
    }

    public Dimension getPreferredSize() {
        return PREF_DIM;
    }

    public void requestFocus() {
    }

    private Node createPackagesNode() {
        Node node = RepositoryNodeFactory.getDefault().repository((DataFilter)this);
        Node[] nodeArray = node.getChildren().getNodes(true);
        assert (nodeArray != null && nodeArray.length == 1) : "Only one subnode " + node + " found, but was " + Arrays.asList(nodeArray);
        return nodeArray[0];
    }

    private void initComponents() {
        this.packagesPanel = new ExplorerPanel();
        this.beanTreeView = new BeanTreeView();
        this.descriptionLabel = new JLabel();
        this.packageLabel = new JLabel();
        this.packageName = new JTextField();
        this.dirLabel = new JLabel();
        this.directoryName = new JTextField();
        this.createButton = new JButton();
        this.setLayout(new BorderLayout());
        this.packagesPanel.setLayout(new GridBagLayout());
        this.beanTreeView.setDefaultActionAllowed(false);
        this.beanTreeView.setPopupAllowed(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.packagesPanel.add((Component)this.beanTreeView, gridBagConstraints);
        this.descriptionLabel.setLabelFor((Component)this.beanTreeView);
        Mnemonics.setLocalizedText((JLabel)this.descriptionLabel, (String)NbBundle.getBundle(DataFolderPanel.class).getString("LAB_TargetLocationDescription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.packagesPanel.add(this.descriptionLabel, gridBagConstraints);
        this.packageLabel.setLabelFor(this.packageName);
        Mnemonics.setLocalizedText((JLabel)this.packageLabel, (String)NbBundle.getBundle(DataFolderPanel.class).getString("LAB_package"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 12);
        this.packagesPanel.add(this.packageLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.packagesPanel.add(this.packageName, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.dirLabel, (String)NbBundle.getBundle(DataFolderPanel.class).getString("LAB_directory"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.packagesPanel.add(this.dirLabel, gridBagConstraints);
        this.directoryName.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.packagesPanel.add(this.directoryName, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.createButton, (String)NbBundle.getBundle(DataFolderPanel.class).getString("CTL_Create"));
        this.createButton.setEnabled(false);
        this.createButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataFolderPanel.this.createButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.packagesPanel.add(this.createButton, gridBagConstraints);
        this.add((Component)((Object)this.packagesPanel), "Center");
    }

    private void createButtonActionPerformed(ActionEvent actionEvent) {
        try {
            DataFolder dataFolder = (DataFolder)this.getPropertyValue();
            this.setTargetFolder(dataFolder);
            this.updateDirectory();
            this.updatePropertyEditor();
            this.enableCreateButton();
        }
        catch (IllegalStateException illegalStateException) {
            throw new RuntimeException(illegalStateException.getMessage());
        }
    }

    public boolean acceptDataObject(DataObject dataObject) {
        return dataObject instanceof DataFolder;
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        Node[] nodeArray;
        if ("selectedNodes".equals(propertyChangeEvent.getPropertyName()) && (nodeArray = (Node[])propertyChangeEvent.getNewValue()).length > 1) {
            throw new PropertyVetoException("Only single selection allowed", propertyChangeEvent);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
            Node[] nodeArray = this.packagesPanel.getExplorerManager().getSelectedNodes();
            if (!this.isVisible()) {
                return;
            }
            if (nodeArray.length == 1) {
                if (!this.isValid()) {
                    this.setTargetFolder(null);
                    this.implSetDataFolder(null);
                    return;
                }
                DataFolder dataFolder = (DataFolder)nodeArray[0].getCookie(DataFolder.class);
                if (dataFolder != null) {
                    this.setTargetFolder(dataFolder);
                    this.updatePropertyEditor();
                    this.enableCreateButton();
                    return;
                }
            }
            this.setTargetFolder(null);
            this.implSetDataFolder(null);
        }
        if ("state".equals(propertyChangeEvent.getPropertyName()) && propertyChangeEvent.getNewValue() == PropertyEnv.STATE_VALID) {
            this.editor.setValue(this.getPropertyValue());
        }
    }

    private void fireStateChanged() {
        if (this.listener != null) {
            this.listener.stateChanged(new ChangeEvent(this));
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getDocument() == this.packageName.getDocument()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    String string = DataFolderPanel.this.packageName.getText();
                    if (string != null) {
                        if (DataFolderPanel.this.isValid()) {
                            DataFolderPanel.this.setTargetFolder(string, false);
                            DataFolderPanel.this.updatePropertyEditor();
                        }
                        DataFolderPanel.this.updateDirectory();
                    }
                    DataFolderPanel.this.enableCreateButton();
                }
            });
            return;
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getDocument() == this.packageName.getDocument()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    String string;
                    if (DataFolderPanel.this.packageName.getText().length() == 0 && (string = DataFolderPanel.this.system.get()) != null) {
                        DataFolder dataFolder = DataFolder.findFolder((FileObject)string.getRoot());
                        DataFolderPanel.this.setTargetFolder(dataFolder);
                        DataFolderPanel.this.packageName.selectAll();
                    }
                    if ((string = DataFolderPanel.this.packageName.getText()) != null) {
                        if (DataFolderPanel.this.isValid()) {
                            DataFolderPanel.this.setTargetFolder(string, true);
                            DataFolderPanel.this.updatePropertyEditor();
                        }
                        DataFolderPanel.this.updateDirectory();
                    }
                    DataFolderPanel.this.enableCreateButton();
                }
            });
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    public HelpCtx getHelp() {
        return new HelpCtx(DataFolderPanel.class);
    }

    public boolean isValid() {
        Node[] nodeArray;
        String string = this.packageName.getText();
        return string.length() != 0 || (nodeArray = this.packagesPanel.getExplorerManager().getSelectedNodes()).length != 1 || nodeArray[0] != this.rootNode;
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (this.listener != null) {
            throw new IllegalStateException();
        }
        this.listener = changeListener;
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listener = null;
    }

    private static String computeSuggestion(Node node, String string, Node[] nodeArray) {
        Node[] nodeArray2 = node.getChildren().getNodes();
        String string2 = null;
        for (int i = 0; i < nodeArray2.length; ++i) {
            int n;
            String string3 = nodeArray2[i].getName();
            if (!string3.startsWith(string)) continue;
            if (string2 == null) {
                string2 = string3;
                if (nodeArray == null) continue;
                nodeArray[0] = nodeArray2[i];
                continue;
            }
            int n2 = Math.min(string3.length(), string2.length());
            for (n = string.length(); n < n2 && string2.charAt(n) == string3.charAt(n); ++n) {
            }
            string2 = string2.substring(0, n);
        }
        if (string2 == null) {
            return null;
        }
        return string2.substring(string.length());
    }

    boolean setTargetFolder(DataFolder dataFolder) {
        boolean bl;
        String string;
        FileObject fileObject;
        Node node = null;
        this.df = dataFolder;
        if (dataFolder != null) {
            fileObject = dataFolder.getPrimaryFile();
            string = fileObject.getPath();
            StringTokenizer stringTokenizer = new StringTokenizer(string, PATH_TOKEN_DELIMITER);
            try {
                FileSystem fileSystem = fileObject.getFileSystem();
                if (fileObject.isRoot()) {
                    boolean bl2;
                    string = this.packageName.getText().trim();
                    boolean bl3 = bl2 = string.indexOf(File.separatorChar) != -1;
                    if (fileObject.getFileObject(string) != null || bl2) {
                        string = "";
                    }
                }
                this.system = new WeakReference<FileSystem>(fileSystem);
                node = NodeOp.findPath((Node)this.rootNode, (Enumeration)NbCollections.checkedEnumerationByFilter((Enumeration)stringTokenizer, String.class, (boolean)true));
                bl = true;
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                node = this.rootNode;
                string = "";
                bl = false;
            }
            catch (NodeNotFoundException nodeNotFoundException) {
                node = nodeNotFoundException.getClosestNode();
                DataFolder dataFolder2 = (DataFolder)node.getCookie(DataFolder.class);
                string = dataFolder2 != null ? dataFolder2.getPrimaryFile().getPath() : "";
                bl = false;
            }
        } else {
            node = this.rootNode;
            string = null;
            bl = true;
        }
        fileObject = this.packagesPanel.getExplorerManager();
        fileObject.removePropertyChangeListener((PropertyChangeListener)this);
        this.packageName.getDocument().removeDocumentListener(this);
        try {
            fileObject.setSelectedNodes(new Node[]{node});
        }
        catch (PropertyVetoException propertyVetoException) {
            throw new InternalError();
        }
        this.packageName.setText(string);
        this.updateDirectory();
        this.packageName.getDocument().addDocumentListener(this);
        fileObject.addPropertyChangeListener((PropertyChangeListener)this);
        this.fireStateChanged();
        return bl;
    }

    private DataFolder getTargetFolder(boolean bl) throws IOException {
        FileSystem fileSystem;
        if (bl && this.isValid() && (fileSystem = this.system.get()) != null) {
            DataFolder dataFolder = DataFolder.findFolder((FileObject)fileSystem.getRoot());
            String string = this.packageName.getText().replace('\\', '/');
            if (string.length() > 0) {
                dataFolder = DataFolder.create((DataFolder)dataFolder, (String)string);
            }
            this.df = dataFolder;
            return dataFolder;
        }
        return this.df;
    }

    private boolean setTargetFolder(String string, boolean bl) {
        FileSystem fileSystem;
        Node node;
        NodeNotFoundException nodeNotFoundException;
        Node node2;
        block16: {
            node2 = null;
            nodeNotFoundException = null;
            HashSet<Node> hashSet = new HashSet<Node>();
            Node[] nodeArray = this.packagesPanel.getExplorerManager().getSelectedNodes();
            for (int i = 0; i < nodeArray.length; ++i) {
                node = nodeArray[i];
                if (node.getParentNode() == null) continue;
                while (node.getParentNode().getParentNode() != null) {
                    node = node.getParentNode();
                }
                hashSet.add(node);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, PATH_TOKEN_DELIMITER);
            try {
                node2 = NodeOp.findPath((Node)this.rootNode, (Enumeration)NbCollections.checkedEnumerationByFilter((Enumeration)stringTokenizer, String.class, (boolean)true));
            }
            catch (NodeNotFoundException nodeNotFoundException2) {
                if (stringTokenizer.hasMoreElements() || (fileSystem = DataFolderPanel.computeSuggestion(nodeNotFoundException2.getClosestNode(), nodeNotFoundException2.getMissingChildName(), null)) == null) break block16;
                nodeNotFoundException = nodeNotFoundException2;
            }
        }
        if (node2 != null) {
            nodeNotFoundException = null;
        } else {
            if (nodeNotFoundException == null) {
                return false;
            }
            node2 = nodeNotFoundException.getClosestNode();
        }
        node = this.packagesPanel.getExplorerManager();
        node.removePropertyChangeListener((PropertyChangeListener)this);
        if (nodeNotFoundException != null) {
            fileSystem = new Node[1];
            String string2 = DataFolderPanel.computeSuggestion(nodeNotFoundException.getClosestNode(), nodeNotFoundException.getMissingChildName(), (Node[])fileSystem);
            if (bl && string2 != null && string2.equals(this.last_suggestion)) {
                string2 = null;
            }
            this.last_suggestion = string2;
            if (string2 != null) {
                this.packageName.getDocument().removeDocumentListener(this);
                this.packageName.setText(string + string2);
                this.updateDirectory();
                Caret caret = this.packageName.getCaret();
                caret.setDot(string.length() + string2.length());
                caret.moveDot(string.length());
                this.packageName.getDocument().addDocumentListener(this);
            }
            if (fileSystem[0] != null) {
                node2 = fileSystem[0];
            }
        }
        try {
            node.setSelectedNodes(new Node[]{node2});
        }
        catch (PropertyVetoException propertyVetoException) {
            throw new InternalError();
        }
        this.df = (DataFolder)node2.getCookie(DataFolder.class);
        if (this.df != null) {
            try {
                fileSystem = this.df.getPrimaryFile().getFileSystem();
                this.system = new WeakReference<FileSystem>(fileSystem);
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                // empty catch block
            }
        }
        node.addPropertyChangeListener((PropertyChangeListener)this);
        this.fireStateChanged();
        return nodeNotFoundException == null;
    }

    void updateDirectory() {
        FileSystem fileSystem = this.system.get();
        if (fileSystem == null) {
            this.directoryName.setText("");
            return;
        }
        String string = this.packageName.getText();
        FileObject fileObject = fileSystem.findResource(string);
        if (fileObject != null) {
            File file = FileUtil.toFile((FileObject)fileObject);
            if (file != null) {
                this.directoryName.setText(file.getAbsolutePath());
            } else {
                this.directoryName.setText("");
            }
        } else {
            FileObject fileObject2 = fileSystem.getRoot();
            assert (fileObject2 != null) : fileSystem;
            File file = FileUtil.toFile((FileObject)fileObject2);
            if (file != null) {
                File file2 = new File(file, string.replace('/', File.separatorChar));
                this.directoryName.setText(file2.getAbsolutePath());
            } else {
                this.directoryName.setText("");
            }
        }
    }

    private void implSetDataFolder(DataFolder dataFolder) {
        if (this.editor != null) {
            if (!this.isValid()) {
                this.editor.setDataFolder(null);
            } else {
                Object object;
                FileSystem fileSystem = null;
                if (this.system != null) {
                    fileSystem = this.system.get();
                }
                if (dataFolder == null && fileSystem != null && (object = fileSystem.getRoot()) != null) {
                    dataFolder = DataFolder.findFolder((FileObject)object);
                }
                if (dataFolder != null) {
                    object = dataFolder.getPrimaryFile().getPath();
                    if (((String)object).equals(this.packageName.getText())) {
                        this.editor.setDataFolder(dataFolder);
                    } else {
                        this.editor.setDataFolder(null);
                    }
                } else {
                    this.editor.setDataFolder(null);
                }
            }
        }
    }

    void updatePropertyEditor() {
        try {
            DataFolder dataFolder = this.getTargetFolder(false);
            this.implSetDataFolder(dataFolder);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    void enableCreateButton() {
        String string = null;
        string = this.df != null ? this.df.getPrimaryFile().getPath() : "";
        if (string.equals(this.packageName.getText())) {
            this.createButton.setEnabled(false);
        } else {
            this.createButton.setEnabled(this.isValid());
        }
    }

    private Object getPropertyValue() throws IllegalStateException {
        if (this.isValid()) {
            try {
                this.df = this.getTargetFolder(true);
                return this.df;
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
                throw new IllegalStateException();
            }
        }
        throw new IllegalStateException();
    }

    private static String getString(String string) {
        return NbBundle.getBundle(DataFolderPanel.class).getString(string);
    }

    public static class ShadowDirNode
    extends AbstractNode {
        public ShadowDirNode(Children children) {
            super(children);
        }
    }

    public static class ShadowLeafNode
    extends AbstractNode {
        public ShadowLeafNode() {
            super(Children.LEAF);
        }
    }
}

