/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.openide.util.NbBundle;

public class DatabaseTypePropertyEditor
implements PropertyEditor {
    private int[] constants;
    private String[] names;
    private int index;
    private String name;
    private PropertyChangeSupport support;

    public DatabaseTypePropertyEditor() {
        ResourceBundle resourceBundle = NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle");
        this.support = new PropertyChangeSupport(this);
        this.constants = new int[]{2003, -5, -2, -7, 2004, 1, 2005, 91, 3, 2001, 8, 6, 4, 2000, -4, -1, 2, 7, 2006, 5, 92, 93, -6, -3, 12, 1111};
        this.names = new String[]{resourceBundle.getString("SQL_ARRAY"), resourceBundle.getString("SQL_BIGINT"), resourceBundle.getString("SQL_BINARY"), resourceBundle.getString("SQL_BIT"), resourceBundle.getString("SQL_BLOB"), resourceBundle.getString("SQL_CHAR"), resourceBundle.getString("SQL_CLOB"), resourceBundle.getString("SQL_DATE"), resourceBundle.getString("SQL_DECIMAL"), resourceBundle.getString("SQL_DISTINCT"), resourceBundle.getString("SQL_DOUBLE"), resourceBundle.getString("SQL_FLOAT"), resourceBundle.getString("SQL_INTEGER"), resourceBundle.getString("SQL_JAVA_OBJECT"), resourceBundle.getString("SQL_LONGVARBINARY"), resourceBundle.getString("SQL_LONGVARCHAR"), resourceBundle.getString("SQL_NUMERIC"), resourceBundle.getString("SQL_REAL"), resourceBundle.getString("SQL_REF"), resourceBundle.getString("SQL_SMALLINT"), resourceBundle.getString("SQL_TIME"), resourceBundle.getString("SQL_TIMESTAMP"), resourceBundle.getString("SQL_TINYINT"), resourceBundle.getString("SQL_VARBINARY"), resourceBundle.getString("SQL_VARCHAR"), resourceBundle.getString("SQL_OTHER")};
    }

    public DatabaseTypePropertyEditor(int[] nArray, String[] stringArray) {
        this.support = new PropertyChangeSupport(this);
        this.constants = nArray;
        this.names = stringArray;
    }

    public Object getValue() {
        return new Integer(this.constants[this.index]);
    }

    public void setValue(Object object) {
        int n;
        Integer n2;
        ResourceBundle resourceBundle = NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle");
        try {
            n2 = new Integer(object.toString());
        }
        catch (NumberFormatException numberFormatException) {
            String string = MessageFormat.format(resourceBundle.getString("EXC_CannotOperateWith"), object.toString());
            throw new IllegalArgumentException(string);
        }
        int n3 = n2;
        int n4 = this.constants.length;
        for (n = 0; n < n4 && this.constants[n] != n3; ++n) {
        }
        if (n == n4) {
            switch (n3) {
                case -7: {
                    this.name = resourceBundle.getString("SQL_BIT");
                    break;
                }
                case -6: {
                    this.name = resourceBundle.getString("SQL_TINYINT");
                    break;
                }
                case 5: {
                    this.name = resourceBundle.getString("SQL_SMALLINT");
                    break;
                }
                case 4: {
                    this.name = resourceBundle.getString("SQL_INTEGER");
                    break;
                }
                case -5: {
                    this.name = resourceBundle.getString("SQL_BIGINT");
                    break;
                }
                case 6: {
                    this.name = resourceBundle.getString("SQL_FLOAT");
                    break;
                }
                case 7: {
                    this.name = resourceBundle.getString("SQL_REAL");
                    break;
                }
                case 8: {
                    this.name = resourceBundle.getString("SQL_DOUBLE");
                    break;
                }
                case 2: {
                    this.name = resourceBundle.getString("SQL_NUMERIC");
                    break;
                }
                case 3: {
                    this.name = resourceBundle.getString("SQL_DECIMAL");
                    break;
                }
                case 1: {
                    this.name = resourceBundle.getString("SQL_CHAR");
                    break;
                }
                case 12: {
                    this.name = resourceBundle.getString("SQL_VARCHAR");
                    break;
                }
                case -1: {
                    this.name = resourceBundle.getString("SQL_LONGVARCHAR");
                    break;
                }
                case 91: {
                    this.name = resourceBundle.getString("SQL_DATE");
                    break;
                }
                case 92: {
                    this.name = resourceBundle.getString("SQL_TIME");
                    break;
                }
                case 93: {
                    this.name = resourceBundle.getString("SQL_TIMESTAMP");
                    break;
                }
                case -2: {
                    this.name = resourceBundle.getString("SQL_BINARY");
                    break;
                }
                case -3: {
                    this.name = resourceBundle.getString("SQL_VARBINARY");
                    break;
                }
                case -4: {
                    this.name = resourceBundle.getString("SQL_LONGVARBINARY");
                    break;
                }
                case 0: {
                    this.name = resourceBundle.getString("SQL_NULL");
                    break;
                }
                case 1111: {
                    this.name = resourceBundle.getString("SQL_OTHER");
                    break;
                }
                case 2000: {
                    this.name = resourceBundle.getString("SQL_JAVA_OBJECT");
                    break;
                }
                case 2001: {
                    this.name = resourceBundle.getString("SQL_DISTINCT");
                    break;
                }
                case 2002: {
                    this.name = resourceBundle.getString("SQL_STRUCT");
                    break;
                }
                case 2003: {
                    this.name = resourceBundle.getString("SQL_ARRAY");
                    break;
                }
                case 2004: {
                    this.name = resourceBundle.getString("SQL_BLOB");
                    break;
                }
                case 2005: {
                    this.name = resourceBundle.getString("SQL_CLOB");
                    break;
                }
                case 2006: {
                    this.name = resourceBundle.getString("SQL_REF");
                    break;
                }
                default: {
                    this.name = resourceBundle.getString("SQL_UNKNOWN");
                }
            }
            this.index = 0;
        } else {
            this.index = n;
            this.name = this.names[n];
        }
        this.support.firePropertyChange(null, null, null);
    }

    public String getAsText() {
        return this.name;
    }

    public void setAsText(String string) throws IllegalArgumentException {
        int n;
        int n2 = this.names.length;
        for (n = 0; n < n2 && !this.names[n].equals(string); ++n) {
        }
        if (n == n2) {
            String string2 = MessageFormat.format(NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("EXC_CannotFindAsText"), string);
            throw new IllegalArgumentException(string2);
        }
        this.index = n;
        this.name = this.names[n];
    }

    public String getJavaInitializationString() {
        return "" + this.index;
    }

    public String[] getTags() {
        return this.names;
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
    }

    public boolean supportsCustomEditor() {
        return false;
    }

    public Component getCustomEditor() {
        return null;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }
}

