/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.completion;

import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.editor.completion.CompletionLayout;
import org.openide.util.Utilities;

abstract class CompletionLayoutPopup {
    private CompletionLayout layout;
    private Popup popup;
    private Rectangle popupBounds;
    private JComponent contentComponent;
    private int anchorOffset;
    private Rectangle anchorOffsetBounds;
    private boolean displayAboveCaret;
    private Rectangle screenBounds;
    private boolean preferDisplayAboveCaret;
    private boolean showRetainedPreferredSize;

    CompletionLayoutPopup() {
    }

    public final boolean isVisible() {
        return this.popup != null;
    }

    public final boolean isActive() {
        return this.contentComponent != null;
    }

    public final void hide() {
        if (this.isVisible()) {
            this.popup.hide();
            this.popup = null;
            this.popupBounds = null;
            this.contentComponent = null;
            this.anchorOffset = -1;
            this.screenBounds = null;
        }
    }

    public final boolean isDisplayAboveCaret() {
        return this.displayAboveCaret;
    }

    public final Rectangle getPopupBounds() {
        return this.popupBounds;
    }

    final void setLayout(CompletionLayout completionLayout) {
        assert (completionLayout != null);
        this.layout = completionLayout;
    }

    final void setPreferDisplayAboveCaret(boolean bl) {
        this.preferDisplayAboveCaret = bl;
    }

    final void setContentComponent(JComponent jComponent) {
        assert (jComponent != null);
        this.contentComponent = jComponent;
    }

    final void setAnchorOffset(int n) {
        this.anchorOffset = n;
        this.anchorOffsetBounds = null;
    }

    final Rectangle getScreenBounds() {
        if (this.screenBounds == null) {
            JTextComponent jTextComponent = this.getEditorComponent();
            GraphicsConfiguration graphicsConfiguration = jTextComponent != null ? jTextComponent.getGraphicsConfiguration() : null;
            this.screenBounds = graphicsConfiguration != null ? graphicsConfiguration.getBounds() : new Rectangle();
        }
        return this.screenBounds;
    }

    final int getAnchorOffset() {
        JTextComponent jTextComponent;
        int n = this.anchorOffset;
        if (n == -1 && (jTextComponent = this.getEditorComponent()) != null) {
            n = jTextComponent.getSelectionStart();
        }
        return n;
    }

    final JComponent getContentComponent() {
        return this.contentComponent;
    }

    final Dimension getPreferredSize() {
        JComponent jComponent = this.getContentComponent();
        return jComponent == null ? new Dimension(0, 0) : jComponent.getPreferredSize();
    }

    final void resetPreferredSize() {
        JComponent jComponent = this.getContentComponent();
        if (jComponent == null) {
            return;
        }
        jComponent.setPreferredSize(null);
    }

    final boolean isShowRetainedPreferredSize() {
        return this.showRetainedPreferredSize;
    }

    final CompletionLayout getLayout() {
        return this.layout;
    }

    final JTextComponent getEditorComponent() {
        return this.layout.getEditorComponent();
    }

    protected int getAnchorHorizontalShift() {
        return 0;
    }

    final Rectangle getAnchorOffsetBounds() {
        JTextComponent jTextComponent = this.getEditorComponent();
        if (jTextComponent == null) {
            return new Rectangle();
        }
        if (this.anchorOffsetBounds == null) {
            int n = this.getAnchorOffset();
            try {
                this.anchorOffsetBounds = jTextComponent.modelToView(n);
                if (this.anchorOffsetBounds != null) {
                    this.anchorOffsetBounds.x -= this.getAnchorHorizontalShift();
                } else {
                    this.anchorOffsetBounds = new Rectangle();
                }
            }
            catch (BadLocationException badLocationException) {
                this.anchorOffsetBounds = new Rectangle();
            }
            Point point = this.anchorOffsetBounds.getLocation();
            SwingUtilities.convertPointToScreen(point, jTextComponent);
            this.anchorOffsetBounds.setLocation(point);
        }
        return this.anchorOffsetBounds;
    }

    final Popup getPopup() {
        return this.popup;
    }

    private Rectangle findPopupBounds(Rectangle rectangle, boolean bl) {
        Dimension dimension = this.getPreferredSize();
        Rectangle rectangle2 = this.getScreenBounds();
        Rectangle rectangle3 = new Rectangle();
        rectangle3.x = Math.min(rectangle.x, rectangle2.x + rectangle2.width - dimension.width);
        rectangle3.x = Math.max(rectangle3.x, rectangle2.x);
        rectangle3.width = Math.min(dimension.width, rectangle2.width);
        if (bl) {
            rectangle3.height = Math.min(dimension.height, rectangle.y - rectangle2.y - 1);
            rectangle3.y = rectangle.y - 1 - rectangle3.height;
        } else {
            rectangle3.y = rectangle.y + rectangle.height + 1;
            rectangle3.height = Math.min(dimension.height, rectangle2.y + rectangle2.height - rectangle3.y);
        }
        return rectangle3;
    }

    private void show(Rectangle rectangle, boolean bl) {
        if (this.popup != null) {
            this.popup.hide();
            this.popup = null;
        }
        Dimension dimension = this.getPreferredSize();
        Dimension dimension2 = rectangle.getSize();
        JComponent jComponent = this.getContentComponent();
        if (jComponent == null) {
            return;
        }
        jComponent.setPreferredSize(dimension2);
        this.showRetainedPreferredSize = dimension2.equals(dimension);
        PopupFactory popupFactory = PopupFactory.getSharedInstance();
        JTextComponent jTextComponent = Utilities.isMac() ? null : this.layout.getEditorComponent();
        this.popup = popupFactory.getPopup(jTextComponent, jComponent, rectangle.x, rectangle.y);
        this.popup.show();
        this.popupBounds = rectangle;
        this.displayAboveCaret = bl;
    }

    void showAlongAnchorBounds() {
        this.showAlongOccupiedBounds(this.getAnchorOffsetBounds());
    }

    void showAlongAnchorBounds(boolean bl) {
        this.showAlongOccupiedBounds(this.getAnchorOffsetBounds(), bl);
    }

    void showAlongOccupiedBounds(Rectangle rectangle) {
        boolean bl = this.isEnoughSpace(rectangle, this.preferDisplayAboveCaret) ? this.preferDisplayAboveCaret : this.isMoreSpaceAbove(rectangle);
        Rectangle rectangle2 = this.findPopupBounds(rectangle, bl);
        this.show(rectangle2, bl);
    }

    void showAlongOccupiedBounds(Rectangle rectangle, boolean bl) {
        Rectangle rectangle2 = this.findPopupBounds(rectangle, bl);
        this.show(rectangle2, bl);
    }

    boolean isMoreSpaceAbove(Rectangle rectangle) {
        Rectangle rectangle2 = this.getScreenBounds();
        int n = rectangle.y - rectangle2.y;
        int n2 = rectangle2.y + rectangle2.height - (rectangle.y + rectangle.height);
        return n > n2;
    }

    boolean isEnoughSpace(Rectangle rectangle) {
        return this.isEnoughSpace(rectangle, this.preferDisplayAboveCaret);
    }

    boolean isEnoughSpace(Rectangle rectangle, boolean bl) {
        Rectangle rectangle2 = this.getScreenBounds();
        int n = bl ? rectangle.y - rectangle2.y : rectangle2.y + rectangle2.height - (rectangle.y + rectangle.height);
        Dimension dimension = this.getPreferredSize();
        return dimension.height < n;
    }

    boolean isEnoughSpace(boolean bl) {
        return this.isEnoughSpace(this.getAnchorOffsetBounds(), bl);
    }

    public boolean isOverlapped(Rectangle rectangle) {
        return this.isVisible() ? this.popupBounds.intersects(rectangle) : false;
    }

    public boolean isOverlapped(CompletionLayoutPopup completionLayoutPopup) {
        return completionLayoutPopup.isVisible() ? this.isOverlapped(completionLayoutPopup.getPopupBounds()) : false;
    }

    public Rectangle unionBounds(Rectangle rectangle) {
        return this.isVisible() ? rectangle.union(this.getPopupBounds()) : rectangle;
    }

    public abstract void processKeyEvent(KeyEvent var1);
}

