/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.EventListenerList;
import org.netbeans.modules.masterfs.BasedOnResourcePath;
import org.netbeans.modules.masterfs.Cache;
import org.netbeans.modules.masterfs.Delegate;
import org.netbeans.modules.masterfs.InvalidDummy;
import org.netbeans.modules.masterfs.MasterFileSystem;
import org.netbeans.modules.masterfs.MountTable;
import org.netbeans.modules.masterfs.ProviderCall;
import org.netbeans.modules.masterfs.ResourcePath;
import org.netbeans.modules.masterfs.SpecialDelegates;
import org.netbeans.modules.masterfs.SyncSection;
import org.netbeans.modules.masterfs.Utils;
import org.netbeans.modules.masterfs.filebasedfs.FileBasedFileSystem;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.BaseFileObj;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.FileObj;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.FolderObj;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.ReplaceForSerialization;
import org.netbeans.modules.masterfs.filebasedfs.utils.FileInfo;
import org.netbeans.modules.masterfs.providers.ProvidedExtensions;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Enumerations;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

final class MasterFileObject
extends BasedOnResourcePath {
    static final long serialVersionUID = -1244651324997356809L;
    private final transient Delegate delegate;
    private transient EventListenerList listeners;
    private static final FileSystem.AtomicAction referenceAction = new AtomicAction(null);
    private transient boolean isFolder;
    static /* synthetic */ Class class$org$netbeans$modules$masterfs$MasterFileObject;
    static /* synthetic */ Class class$org$netbeans$modules$masterfs$MasterFileObject$AtomicAction;

    MasterFileObject(ResourcePath resourcePath, FileObject fileObject) {
        super(resourcePath);
        File file;
        this.isFolder = fileObject != null ? fileObject.isFolder() : ((file = resourcePath.getFile()) != null ? file.isDirectory() : true);
        this.delegate = new Delegate(fileObject, new FileChangeListenerImpl(), (FileChangeListener)new FileChangeListenerForVersioning(), this);
        this.delegate.set(fileObject);
    }

    public Date lastModified() {
        FileObject fileObject = this.getValidOrInvalid(this.getDelegate().getPrefered());
        return fileObject.lastModified();
    }

    public boolean isValid() {
        File file;
        FileObject fileObject = this.getValidOrInvalid(this.getDelegate().getPrefered());
        File file2 = file = fileObject.isVirtual() ? null : this.getResource().getFile();
        return file != null ? fileObject.isValid() && file.exists() : fileObject.isValid();
    }

    public Object getAttribute(String string) {
        FileObject fileObject;
        File file;
        if (string.equals("FileSystem.rootPath")) {
            return "";
        }
        if (string.equals("java.io.File") && (file = this.getResource().getFile()) != null && file.exists()) {
            return file;
        }
        file = this.getValidOrInvalid(this.getDelegate().getPrefered());
        Object object = file.getAttribute(string);
        if (object == null && (fileObject = this.getDelegate().get()) != null && fileObject.isValid() && fileObject.isRoot()) {
            object = fileObject.getAttribute(string);
        }
        return object;
    }

    public void setAttribute(String string, Object object) throws IOException {
        FileObject fileObject = this.getValidOrInvalid(this.getDelegate().getPrefered());
        fileObject.setAttribute(string, object);
    }

    public Enumeration getAttributes() {
        FileObject fileObject = this.getValidOrInvalid(this.getDelegate().getPrefered());
        return fileObject.getAttributes();
    }

    public long getSize() {
        FileObject fileObject = this.getValidOrInvalid(this.getDelegate().getPrefered());
        return fileObject.getSize();
    }

    public InputStream getInputStream() throws FileNotFoundException {
        FileObject fileObject = this.getValidOrInvalid(this.getDelegate().getPrefered());
        return fileObject.getInputStream();
    }

    public OutputStream getOutputStream(FileLock fileLock) throws IOException {
        FileObject fileObject = this.getValidOrInvalid(this.getDelegate().getPrefered());
        FileLock fileLock2 = fileObject.isValid() ? Delegate.getLockForDelegate(fileLock, fileObject) : null;
        return fileObject instanceof FileObj ? ((FileObj)fileObject).getOutputStream(fileLock2, MasterFileObject.getExtensions(), this) : fileObject.getOutputStream(fileLock2);
    }

    public boolean isLocked() {
        return this.getDelegate().isLocked();
    }

    public FileLock lock() throws IOException {
        FileLock fileLock = this.getDelegate().lock();
        MasterFileObject.getExtensions().fileLocked(this);
        return fileLock;
    }

    public void setImportant(boolean bl) {
        FileObject fileObject = this.getValidOrInvalid(this.getDelegate().get());
        fileObject.setImportant(bl);
    }

    public boolean isReadOnly() {
        FileObject fileObject = this.getValidOrInvalid(this.getDelegate().getPrefered());
        return fileObject.isReadOnly();
    }

    public String getMIMEType() {
        FileObject fileObject = this.getValidOrInvalid(this.getDelegate().get());
        return fileObject.getMIMEType();
    }

    public boolean existsExt(String string) {
        FileObject fileObject = this.getValidOrInvalid(this.getDelegate().getPrefered());
        return fileObject.existsExt(string);
    }

    public boolean isData() {
        return !this.isFolder();
    }

    public boolean isFolder() {
        return this.isFolder;
    }

    public boolean isVirtual() {
        FileObject fileObject = this.getValidOrInvalid(this.getDelegate().get());
        return fileObject.isVirtual();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFileChangeListener(FileChangeListener fileChangeListener) {
        MasterFileObject masterFileObject = this;
        synchronized (masterFileObject) {
            if (this.listeners == null) {
                this.listeners = new EventListenerList();
            }
            this.listeners.add(FileChangeListener.class, fileChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFileChangeListener(FileChangeListener fileChangeListener) {
        MasterFileObject masterFileObject = this;
        synchronized (masterFileObject) {
            if (this.listeners != null) {
                this.listeners.remove(FileChangeListener.class, fileChangeListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileObject[] getChildren() {
        this.enterCriticalSection();
        try {
            FileObject fileObject = this.getValidOrInvalid(this.getDelegate().get());
            FileObject[] fileObjectArray = this.transformChildren(fileObject.getChildren());
            return fileObjectArray;
        }
        finally {
            this.finishCriticalSection();
        }
    }

    public FileObject getFileObject(String string, String string2) {
        Object object;
        FileObject fileObject;
        ResourcePath resourcePath = this.getResource();
        ResourcePath resourcePath2 = resourcePath.getChild(string, string2);
        MasterFileObject masterFileObject = null;
        if (resourcePath2 != null && resourcePath.equals(resourcePath2.getParent()) && (masterFileObject = !((fileObject = this.getValidOrInvalid(this.getDelegate().get())) instanceof SpecialDelegates.WinRootVirtual) ? ((object = fileObject.getFileObject(string, string2)) != null ? this.transformChild((FileObject)object) : null) : MasterFileObject.getCache().getOrCreate(resourcePath2)) == null) {
            object = resourcePath2.getFile();
            boolean bl = true;
            if ((Utilities.isWindows() || Utilities.getOperatingSystem() == 2048) && resourcePath2.getParent().isRoot()) {
                boolean bl2 = bl = SpecialDelegates.checkValidWindowsDrive((File)object) != null;
            }
            if (bl && object != null && ((File)object).exists()) {
                FileObject fileObject2;
                this.refresh();
                masterFileObject = !(fileObject instanceof SpecialDelegates.WinRootVirtual) ? ((fileObject2 = fileObject.getFileObject(string, string2)) != null ? this.transformChild(fileObject2) : null) : MasterFileObject.getCache().getOrCreate(resourcePath2);
            }
        }
        return masterFileObject;
    }

    public Enumeration getChildren(boolean bl) {
        Enumeration enumeration = Enumerations.array((Object[])this.getChildren());
        if (!bl) {
            return enumeration;
        }
        return Enumerations.queue((Enumeration)enumeration, (Enumerations.Processor)this.getChildsEnum());
    }

    public Enumeration getFolders(boolean bl) {
        return Enumerations.filter((Enumeration)this.getChildren(bl), (Enumerations.Processor)new AcceptFolders(true));
    }

    public Enumeration getData(boolean bl) {
        return Enumerations.filter((Enumeration)this.getChildren(bl), (Enumerations.Processor)new AcceptFolders(false));
    }

    public FileSystem getFileSystem() throws FileStateInvalidException {
        return MasterFileSystem.getDefault();
    }

    public FileObject createFolder(String string) throws IOException {
        if (string.indexOf(92) != -1 || string.indexOf(47) != -1) {
            throw new IllegalArgumentException(string);
        }
        MasterFileSystem.StatusImpl statusImpl = (MasterFileSystem.StatusImpl)MasterFileSystem.getDefault().getStatus();
        ProvidedExtensions providedExtensions = statusImpl.getExtensions();
        providedExtensions.beforeCreate(this, string, true);
        FileObject fileObject = null;
        try {
            fileObject = new AtomicAction(this).createFolder(string);
            return fileObject;
        }
        catch (IOException iOException) {
            providedExtensions.createFailure(this, string, true);
            throw iOException;
        }
    }

    public FileObject createData(String string) throws IOException {
        if (string.indexOf(92) != -1 || string.indexOf(47) != -1) {
            throw new IllegalArgumentException(string);
        }
        MasterFileSystem.StatusImpl statusImpl = (MasterFileSystem.StatusImpl)MasterFileSystem.getDefault().getStatus();
        ProvidedExtensions providedExtensions = statusImpl.getExtensions();
        providedExtensions.beforeCreate(this, string, false);
        FileObject fileObject = null;
        try {
            fileObject = new AtomicAction(this).createData(string);
            return fileObject;
        }
        catch (IOException iOException) {
            providedExtensions.createFailure(this, string, false);
            throw iOException;
        }
    }

    public FileObject createData(String string, String string2) throws IOException {
        if (string.indexOf(92) != -1 || string.indexOf(47) != -1) {
            throw new IllegalArgumentException(string);
        }
        MasterFileSystem.StatusImpl statusImpl = (MasterFileSystem.StatusImpl)MasterFileSystem.getDefault().getStatus();
        ProvidedExtensions providedExtensions = statusImpl.getExtensions();
        providedExtensions.beforeCreate(this, FileInfo.composeName(string, string2), false);
        FileObject fileObject = null;
        try {
            fileObject = new AtomicAction(this).createData(string, string2);
            return fileObject;
        }
        catch (IOException iOException) {
            providedExtensions.createFailure(this, FileInfo.composeName(string, string2), false);
            throw iOException;
        }
    }

    public FileObject copy(FileObject fileObject, String string, String string2) throws IOException {
        return new AtomicAction(this).copy(fileObject, string, string2);
    }

    public void delete(FileLock fileLock) throws IOException {
        Object object;
        if ((this.getDelegate().hasMountAbleFlag() || MountTable.getDefault().getMountedFileSystem(this.getResource().getNormalizedPath()) != null) && (object = this.getDelegate().get()) != null && object.isRoot()) {
            MountTable.getDefault().unmount(this.getDelegateFileSystem());
        }
        object = (MasterFileSystem.StatusImpl)MasterFileSystem.getDefault().getStatus();
        ProvidedExtensions providedExtensions = ((MasterFileSystem.StatusImpl)object).getExtensions();
        providedExtensions.beforeDelete(this);
        IOException iOException = null;
        try {
            new AtomicAction(this).delete(fileLock);
        }
        catch (IOException iOException2) {
            iOException = iOException2;
            throw iOException2;
        }
        finally {
            if (iOException == null) {
                providedExtensions.deleteSuccess(this);
            } else {
                providedExtensions.deleteFailure(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileObject move(FileLock fileLock, FileObject fileObject, String string, String string2) throws IOException {
        this.enterExclusiveCriticalSection();
        try {
            if (this.getParent().equals(fileObject)) {
                this.rename(fileLock, string, string2);
                MasterFileObject masterFileObject = this;
                return masterFileObject;
            }
            FileObject fileObject2 = new AtomicAction(this).move(fileLock, fileObject, string, string2);
            return fileObject2;
        }
        finally {
            this.finishExclusiveCriticalSection();
        }
    }

    private FileObject superMove(FileLock fileLock, FileObject fileObject, String string, String string2) throws IOException {
        return super.move(fileLock, fileObject, string, string2);
    }

    public void refresh(boolean bl) {
        try {
            if (bl) {
                new AtomicAction(this).refreshExpected();
            } else {
                new AtomicAction(this).refresh();
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    public FileObject getParent() {
        MasterFileObject masterFileObject = null;
        ResourcePath resourcePath = this.getResource().getParent();
        if (resourcePath != null) {
            resourcePath = resourcePath.getParent() == null ? ResourcePath.getRoot() : resourcePath;
            masterFileObject = Cache.getDefault().getOrCreate(resourcePath);
            if (masterFileObject == null) {
                masterFileObject = Cache.getDefault().getValidOrInvalid(resourcePath);
            }
        }
        return masterFileObject;
    }

    public void rename(FileLock fileLock, String string, String string2) throws IOException {
        FileObject fileObject = null;
        ProvidedExtensions.IOHandler iOHandler = this.getRenameHandler(string, string2);
        this.enterCriticalSection();
        try {
            fileObject = this.getValidOrInvalid(this.getDelegate().get());
            if (this.isReadOnly()) {
                Utils.throwIOException("EXC_CannotRename", new Object[]{this.getPath(), MasterFileObject.getHFs().getDisplayName()});
            }
            ResourcePath resourcePath = this.getResource();
            this.setResource(resourcePath.getParent().getChild(string, string2));
            Cache.getDefault().replace(resourcePath.getNormalizedPath(), this);
            if (this.isRoot() || !fileObject.isRoot()) {
                try {
                    FileLock fileLock2 = Delegate.getLockForDelegate(fileLock, fileObject);
                    if (iOHandler == null) {
                        fileObject.rename(fileLock2, string, string2);
                    } else {
                        ((BaseFileObj)fileObject).rename(fileLock2, string, string2, iOHandler);
                    }
                    MountTable.getDefault();
                    MountTable.renameCachedFileObjects(resourcePath.getNormalizedPath(), this.getResource().getNormalizedPath());
                    return;
                }
                catch (IOException iOException) {
                    this.setResource(resourcePath);
                    throw iOException;
                }
            }
            throw new IOException("Not implemented yet");
        }
        finally {
            this.finishCriticalSection();
        }
    }

    private ProvidedExtensions.IOHandler getRenameHandler(String string, String string2) {
        ProvidedExtensions providedExtensions = ((MasterFileSystem.StatusImpl)MasterFileSystem.getDefault().getStatus()).getExtensions();
        File file = this.getResource().getFile();
        return providedExtensions.getRenameHandler(file, FileInfo.composeName(string, string2));
    }

    public final Object writeReplace() {
        return new Replace(this.getPath());
    }

    Delegate getDelegate() {
        return this.delegate;
    }

    private static MasterFileSystem getHFs() {
        return MasterFileSystem.getDefault();
    }

    private static Cache getCache() {
        return Cache.getDefault();
    }

    private MasterFileObject[] transformChildren(FileObject[] fileObjectArray) {
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>(fileObjectArray.length);
        for (int i = 0; i < fileObjectArray.length; ++i) {
            FileObject fileObject = this.transformChild(fileObjectArray[i]);
            if (fileObject == null) continue;
            arrayList.add(fileObject);
        }
        MasterFileObject[] masterFileObjectArray = new MasterFileObject[arrayList.size()];
        arrayList.toArray(masterFileObjectArray);
        return masterFileObjectArray;
    }

    private FileObject transformChild(FileObject fileObject) {
        MasterFileObject masterFileObject;
        if (fileObject instanceof InvalidDummy) {
            InvalidDummy invalidDummy = (InvalidDummy)fileObject;
            masterFileObject = MasterFileObject.getCache().getOrCreate(invalidDummy.getResource());
        } else {
            ResourcePath resourcePath = this.getResource().getChild(fileObject.getNameExt());
            masterFileObject = MountTable.getDefault().getMountedFileSystem(resourcePath.getNormalizedPath()) != null ? MasterFileObject.getCache().getOrCreate(resourcePath, null) : MasterFileObject.getCache().getOrCreate(resourcePath, fileObject);
        }
        return masterFileObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryAutoMount() {
        SyncSection.getDefault().enterExclusiveSection();
        try {
            FileSystem fileSystem;
            FileObject fileObject = this.getDelegate().get();
            if (this.getDelegate().hasMountAbleFlag() && fileObject != null && !fileObject.isRoot() && (fileSystem = ProviderCall.createFileSystem(this.getPath())) != null) {
                try {
                    MountTable.getDefault().mount(this.getPath(), fileSystem);
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        }
        finally {
            SyncSection.getDefault().finishExclusiveSection();
        }
    }

    private MasterFileObject eventFileToMasterFileObject(FileEvent fileEvent) {
        FileObject fileObject = fileEvent.getFile();
        if (fileObject != null) {
            MasterFileObject masterFileObject;
            MasterFileObject masterFileObject2 = null;
            ResourcePath resourcePath = this.getResource().getChild(fileObject.getNameExt());
            masterFileObject2 = MasterFileObject.getCache().get(resourcePath);
            if (fileObject.isVirtual() && !fileObject.isValid() && masterFileObject2 == null && (masterFileObject = MasterFileObject.getCache().getValidOrInvalid(resourcePath)) != null && masterFileObject.isVirtual()) {
                masterFileObject2 = masterFileObject;
            }
            masterFileObject2 = masterFileObject2 != null ? masterFileObject2 : MasterFileObject.getCache().getOrCreate(resourcePath);
            masterFileObject2 = masterFileObject2 != null ? masterFileObject2 : MasterFileObject.getCache().getValidOrInvalid(resourcePath);
            masterFileObject2 = masterFileObject2 != null ? masterFileObject2 : this;
            return masterFileObject2;
        }
        return this;
    }

    private Enumerations.Processor getChildsEnum() {
        return new Enumerations.Processor(){

            public Object process(Object object, Collection collection) {
                FileObject fileObject = (FileObject)object;
                if (fileObject != null) {
                    collection.addAll(Arrays.asList(fileObject.getChildren()));
                }
                return fileObject;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Enumeration getEnumOfListeners() {
        Object[] objectArray;
        MasterFileObject masterFileObject = this;
        synchronized (masterFileObject) {
            if (this.listeners == null) {
                return Enumerations.empty();
            }
            objectArray = this.listeners.getListenerList();
        }
        if (objectArray == null || objectArray.length == 0) {
            return Enumerations.empty();
        }
        class OnlyListeners
        implements Enumerations.Processor {
            OnlyListeners() {
            }

            public Object process(Object object, Collection collection) {
                if (object instanceof FileChangeListener) {
                    return object;
                }
                return null;
            }
        }
        return Enumerations.filter((Enumeration)Enumerations.array((Object[])objectArray), (Enumerations.Processor)new OnlyListeners());
    }

    FileSystem getDelegateFileSystem() {
        FileObject fileObject = this.getDelegate().get();
        try {
            return fileObject != null ? fileObject.getFileSystem() : null;
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            Logger.getAnonymousLogger().log(Level.WARNING, null, fileStateInvalidException);
            return null;
        }
    }

    static void refreshAfterMount(FileObject fileObject, FileObject fileObject2, MasterFileObject masterFileObject) {
        MasterFileObject masterFileObject2;
        ResourcePath resourcePath = masterFileObject.getResource().getParent();
        MasterFileObject masterFileObject3 = masterFileObject2 = resourcePath != null ? MasterFileObject.getCache().get(resourcePath) : null;
        if (fileObject != null) {
            boolean bl = false;
            try {
                bl = fileObject.getFileSystem() instanceof FileBasedFileSystem;
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                Logger.getAnonymousLogger().log(Level.WARNING, null, fileStateInvalidException);
            }
            if (fileObject.isFolder() && !bl) {
                HashSet<FileObject> hashSet = new HashSet<FileObject>(Arrays.asList(fileObject2.getChildren()));
                HashSet<FileObject> hashSet2 = new HashSet<FileObject>(Arrays.asList(fileObject.getChildren()));
                MasterFileObject.retainOnlyDifferent(hashSet, hashSet2);
                MasterFileObject.handleCreated(hashSet2, masterFileObject);
            }
        } else {
            MasterFileObject.handleDeleted(masterFileObject, masterFileObject2);
        }
    }

    private static void handleDeleted(MasterFileObject masterFileObject, MasterFileObject masterFileObject2) {
        masterFileObject.fireFileDeletedEvent(masterFileObject.getEnumOfListeners(), new FileEvent((FileObject)masterFileObject));
        if (masterFileObject2 != null) {
            masterFileObject2.fireFileDeletedEvent(masterFileObject2.getEnumOfListeners(), new FileEvent((FileObject)masterFileObject2, (FileObject)masterFileObject));
        }
    }

    private static void handleChanged(MasterFileObject masterFileObject, MasterFileObject masterFileObject2) {
        masterFileObject.fireFileChangedEvent(masterFileObject.getEnumOfListeners(), new FileEvent((FileObject)masterFileObject));
        if (masterFileObject2 != null) {
            masterFileObject2.fireFileChangedEvent(masterFileObject2.getEnumOfListeners(), new FileEvent((FileObject)masterFileObject2, (FileObject)masterFileObject));
        }
    }

    private static void handleCreated(Set set, MasterFileObject masterFileObject) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            FileObject fileObject = (FileObject)iterator.next();
            ResourcePath resourcePath = masterFileObject.getResource().getChild(fileObject.getNameExt());
            MasterFileObject masterFileObject2 = MasterFileObject.getCache().get(resourcePath);
            boolean bl = false;
            if (masterFileObject2 == null) {
                masterFileObject2 = MasterFileObject.getCache().getOrCreate(resourcePath, fileObject);
                bl = true;
            }
            if (masterFileObject2.isFolder()) {
                masterFileObject.fireFileFolderCreatedEvent(masterFileObject.getEnumOfListeners(), new FileEvent((FileObject)masterFileObject, (FileObject)masterFileObject2));
            } else {
                masterFileObject.fireFileDataCreatedEvent(masterFileObject.getEnumOfListeners(), new FileEvent((FileObject)masterFileObject, (FileObject)masterFileObject2));
            }
            if (!bl) continue;
            masterFileObject2.getDelegate().reset(masterFileObject2.getResource());
        }
    }

    private static void retainOnlyDifferent(Set set, Set set2) {
        Iterator iterator = set.iterator();
        Iterator iterator2 = set2.iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            FileObject fileObject = (FileObject)iterator.next();
            while (iterator2.hasNext()) {
                FileObject fileObject2 = (FileObject)iterator2.next();
                if (!fileObject2.getNameExt().equals(fileObject.getNameExt())) continue;
                iterator2.remove();
                iterator.remove();
                break;
            }
            iterator2 = set2.iterator();
        }
    }

    private FileObject getValidOrInvalid(FileObject fileObject) {
        return MasterFileObject.getValidOrInvalid(fileObject, this);
    }

    private static FileObject getValidOrInvalid(FileObject fileObject, MasterFileObject masterFileObject) {
        if (fileObject == null) {
            fileObject = new InvalidDummy(masterFileObject.getResource());
        }
        return fileObject;
    }

    private void finishCriticalSection() {
        SyncSection.getDefault().finishSection();
    }

    private void enterCriticalSection() {
        SyncSection.getDefault().enterSection();
    }

    private void finishExclusiveCriticalSection() {
        SyncSection.getDefault().finishExclusiveSection();
    }

    private void enterExclusiveCriticalSection() {
        SyncSection.getDefault().enterExclusiveSection();
    }

    public boolean canWrite() {
        return !this.isReadOnly();
    }

    private static ProvidedExtensions.DeleteHandler getDeleteHandler(File file) {
        return MasterFileObject.getExtensions().getDeleteHandler(file);
    }

    static ProvidedExtensions getExtensions() {
        return ((MasterFileSystem.StatusImpl)MasterFileSystem.getDefault().getStatus()).getExtensions();
    }

    private final class AcceptFolders
    implements Enumerations.Processor {
        private boolean folders;

        public AcceptFolders(boolean bl) {
            this.folders = bl;
        }

        public Object process(Object object, Collection collection) {
            FileObject fileObject = (FileObject)object;
            if (this.folders) {
                return fileObject.isFolder() ? fileObject : null;
            }
            return fileObject.isData() ? fileObject : null;
        }
    }

    private static final class AtomicAction
    implements FileSystem.AtomicAction {
        private int operation;
        private final MasterFileObject hfoI;
        private String nameI;
        private String extI;
        private FileObject targetI;
        private FileLock fLockI;
        private FileObject retVal;
        private static final int CREATE_DATA_OP = 0;
        private static final int CREATE_FOLDER_OP = 1;
        private static final int CREATE_DATA_EXT_OP = 2;
        private static final int COPY_OP = 3;
        private static final int REFRESH_EXPECTED_OP = 4;
        private static final int REFRESH_OP = 5;
        private static final int DELETE_OP = 6;
        private static final int MOVE_OP = 7;
        static final /* synthetic */ boolean $assertionsDisabled;

        private AtomicAction(MasterFileObject masterFileObject) {
            this.hfoI = masterFileObject;
        }

        private FileObject createFolder(String string) throws IOException {
            this.init(string);
            this.operation = 1;
            MasterFileObject.getHFs().runAtomicAction(this);
            return this.retVal;
        }

        FileObject createData(String string) throws IOException {
            this.init(string);
            this.operation = 0;
            MasterFileObject.getHFs().runAtomicAction(this);
            return this.retVal;
        }

        FileObject createData(String string, String string2) throws IOException {
            this.init(string, string2);
            this.operation = 2;
            MasterFileObject.getHFs().runAtomicAction(this);
            return this.retVal;
        }

        FileObject copy(FileObject fileObject, String string, String string2) throws IOException {
            this.init(fileObject, string, string2);
            this.operation = 3;
            MasterFileObject.getHFs().runAtomicAction(this);
            return this.retVal;
        }

        void delete(FileLock fileLock) throws IOException {
            this.init(fileLock, null, null, null);
            this.operation = 6;
            MasterFileObject.getHFs().runAtomicAction(this);
        }

        FileObject move(FileLock fileLock, FileObject fileObject, String string, String string2) throws IOException {
            this.init(fileLock, fileObject, string, string2);
            this.operation = 7;
            MasterFileObject.getHFs().runAtomicAction(this);
            return this.retVal;
        }

        void refreshExpected() throws IOException {
            this.operation = 4;
            MasterFileObject.getHFs().runAtomicAction(this);
        }

        void refresh() throws IOException {
            this.operation = 5;
            MasterFileObject.getHFs().runAtomicAction(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() throws IOException {
            this.hfoI.enterCriticalSection();
            try {
                switch (this.operation) {
                    case 1: {
                        this.createFolder();
                        return;
                    }
                    case 0: {
                        this.createData();
                        return;
                    }
                    case 2: {
                        this.createDataExt();
                        return;
                    }
                    case 3: {
                        this.copy();
                        return;
                    }
                    case 4: {
                        this.iRefreshExpected();
                        return;
                    }
                    case 5: {
                        this.iRefresh();
                        return;
                    }
                    case 6: {
                        this.delete();
                        return;
                    }
                    case 7: {
                        this.move();
                        return;
                    }
                }
                return;
            }
            finally {
                this.hfoI.finishCriticalSection();
            }
        }

        private void init(FileLock fileLock, FileObject fileObject, String string, String string2) {
            this.init(fileObject, string, string2);
            this.fLockI = fileLock;
        }

        private void init(FileObject fileObject, String string, String string2) {
            this.init(string, string2);
            this.targetI = fileObject;
        }

        private void init(String string, String string2) {
            this.init(string);
            this.extI = string2;
        }

        private void init(String string) {
            this.nameI = string;
            this.retVal = null;
        }

        private void createFolder() throws IOException {
            FileObject fileObject = MasterFileObject.getValidOrInvalid(this.hfoI.getDelegate().get(), this.hfoI);
            fileObject.createFolder(this.nameI);
            this.retVal = MasterFileObject.getCache().getOrCreate(this.hfoI.getResource().getChild(this.nameI));
        }

        private void createData() throws IOException {
            FileObject fileObject = MasterFileObject.getValidOrInvalid(this.hfoI.getDelegate().get(), this.hfoI);
            fileObject.createData(this.nameI);
            this.retVal = MasterFileObject.getCache().getOrCreate(this.hfoI.getResource().getChild(this.nameI));
        }

        private void createDataExt() throws IOException {
            FileObject fileObject = MasterFileObject.getValidOrInvalid(this.hfoI.getDelegate().get(), this.hfoI);
            fileObject.createData(this.nameI, this.extI);
            this.retVal = MasterFileObject.getCache().getOrCreate(this.hfoI.getResource().getChild(this.nameI, this.extI));
        }

        private void copy() throws IOException {
            FileObject fileObject = MasterFileObject.getValidOrInvalid(this.hfoI.getDelegate().getPrefered(), this.hfoI);
            this.retVal = fileObject.copy(this.targetI, this.nameI, this.extI);
        }

        private void delete() throws IOException {
            FileObject fileObject = MasterFileObject.getValidOrInvalid(this.hfoI.getDelegate().get(), this.hfoI);
            FileLock fileLock = Delegate.getLockForDelegate(this.fLockI, fileObject);
            if (fileObject instanceof BaseFileObj) {
                ((BaseFileObj)fileObject).delete(fileLock, MasterFileObject.getDeleteHandler(((BaseFileObj)fileObject).getFileName().getFile()));
            } else {
                fileObject.delete(fileLock);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private void move() throws IOException {
            ProvidedExtensions.IOHandler iOHandler = this.getMoveHandler();
            if (iOHandler == null) {
                this.retVal = this.hfoI.superMove(this.fLockI, this.targetI, this.nameI, this.extI);
                return;
            }
            if (this.targetI instanceof MasterFileObject) {
                BaseFileObj baseFileObj = (BaseFileObj)MasterFileObject.getValidOrInvalid(this.hfoI.getDelegate().get(), this.hfoI);
                FileLock fileLock = Delegate.getLockForDelegate(this.fLockI, baseFileObj);
                MasterFileObject masterFileObject = (MasterFileObject)this.targetI;
                FolderObj folderObj = (FolderObj)MasterFileObject.getValidOrInvalid(masterFileObject.getDelegate().get(), masterFileObject);
                baseFileObj.move(fileLock, folderObj, this.nameI, this.extI, iOHandler);
                this.retVal = MasterFileObject.getCache().getOrCreate(masterFileObject.getResource().getChild(this.nameI, this.extI));
                FileUtil.copyAttributes((FileObject)this.hfoI, (FileObject)this.retVal);
                return;
            }
            iOHandler.handle();
            this.hfoI.refresh(true);
            this.targetI.refresh(true);
            this.retVal = this.targetI.getFileObject(this.nameI, this.extI);
            if (!$assertionsDisabled && this.retVal == null) {
                throw new AssertionError();
            }
            FileUtil.copyAttributes((FileObject)this.hfoI, (FileObject)this.retVal);
        }

        private ProvidedExtensions.IOHandler getMoveHandler() {
            ProvidedExtensions providedExtensions = ((MasterFileSystem.StatusImpl)MasterFileSystem.getDefault().getStatus()).getExtensions();
            String string = FileInfo.composeName(this.nameI, this.extI);
            File file = this.hfoI.getResource().getFile();
            File file2 = null;
            file2 = this.targetI instanceof MasterFileObject ? ((MasterFileObject)this.targetI).getResource().getChild(string).getFile() : FileUtil.toFile((FileObject)this.targetI);
            return providedExtensions.getMoveHandler(file, file2);
        }

        private void iRefreshExpected() {
            FileObject fileObject = MasterFileObject.getValidOrInvalid(this.hfoI.getDelegate().get(), this.hfoI);
            if (fileObject != null) {
                fileObject.refresh(true);
            }
        }

        private void iRefresh() {
            FileObject fileObject = MasterFileObject.getValidOrInvalid(this.hfoI.getDelegate().get(), this.hfoI);
            if (fileObject != null) {
                fileObject.refresh(false);
            }
        }

        public boolean equals(Object object) {
            return object instanceof AtomicAction;
        }

        public int hashCode() {
            return (class$org$netbeans$modules$masterfs$MasterFileObject$AtomicAction == null ? (class$org$netbeans$modules$masterfs$MasterFileObject$AtomicAction = MasterFileObject.class$("org.netbeans.modules.masterfs.MasterFileObject$AtomicAction")) : class$org$netbeans$modules$masterfs$MasterFileObject$AtomicAction).hashCode();
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$masterfs$MasterFileObject == null ? (class$org$netbeans$modules$masterfs$MasterFileObject = MasterFileObject.class$("org.netbeans.modules.masterfs.MasterFileObject")) : class$org$netbeans$modules$masterfs$MasterFileObject).desiredAssertionStatus();
        }
    }

    private final class FileChangeListenerForVersioning
    extends FileChangeAdapter {
        private FileChangeListenerForVersioning() {
        }

        public void fileDataCreated(FileEvent fileEvent) {
            MasterFileSystem.StatusImpl statusImpl = (MasterFileSystem.StatusImpl)MasterFileSystem.getDefault().getStatus();
            ProvidedExtensions providedExtensions = statusImpl.getExtensions();
            providedExtensions.createSuccess(MasterFileObject.this.eventFileToMasterFileObject(fileEvent));
        }

        public void fileFolderCreated(FileEvent fileEvent) {
            MasterFileSystem.StatusImpl statusImpl = (MasterFileSystem.StatusImpl)MasterFileSystem.getDefault().getStatus();
            ProvidedExtensions providedExtensions = statusImpl.getExtensions();
            providedExtensions.createSuccess(MasterFileObject.this.eventFileToMasterFileObject(fileEvent));
        }
    }

    private final class FileChangeListenerImpl
    implements FileChangeListener {
        private FileChangeListenerImpl() {
        }

        public void fileDataCreated(FileEvent fileEvent) {
            MasterFileObject masterFileObject = MasterFileObject.this.eventFileToMasterFileObject(fileEvent);
            FileEvent fileEvent2 = new FileEvent((FileObject)MasterFileObject.this, (FileObject)masterFileObject, fileEvent.isExpected());
            FileObject fileObject = masterFileObject.getDelegate().get();
            FileObject fileObject2 = MasterFileObject.this.getDelegate().get();
            if (fileObject == fileEvent.getFile() && fileObject2 == fileEvent.getSource()) {
                MasterFileObject.this.fireFileDataCreatedEvent(MasterFileObject.this.getEnumOfListeners(), fileEvent2);
            }
        }

        public void fileFolderCreated(FileEvent fileEvent) {
            MasterFileObject masterFileObject = MasterFileObject.this.eventFileToMasterFileObject(fileEvent);
            FileEvent fileEvent2 = new FileEvent((FileObject)MasterFileObject.this, (FileObject)masterFileObject, fileEvent.isExpected());
            FileObject fileObject = masterFileObject.getDelegate().get();
            FileObject fileObject2 = MasterFileObject.this.getDelegate().get();
            if (fileObject == fileEvent.getFile() && fileObject2 == fileEvent.getSource()) {
                MasterFileObject.this.fireFileFolderCreatedEvent(MasterFileObject.this.getEnumOfListeners(), fileEvent2);
            }
        }

        public void fileDeleted(FileEvent fileEvent) {
            MasterFileObject masterFileObject = MasterFileObject.this.eventFileToMasterFileObject(fileEvent);
            FileEvent fileEvent2 = new FileEvent((FileObject)MasterFileObject.this, (FileObject)masterFileObject, fileEvent.isExpected());
            FileObject fileObject = masterFileObject.getDelegate().get();
            FileObject fileObject2 = MasterFileObject.this.getDelegate().get();
            if (fileObject == fileEvent.getFile() && fileObject2 == fileEvent.getSource()) {
                MasterFileObject.this.fireFileDeletedEvent(MasterFileObject.this.getEnumOfListeners(), fileEvent2);
            }
        }

        public void fileChanged(FileEvent fileEvent) {
            MasterFileObject masterFileObject = MasterFileObject.this.eventFileToMasterFileObject(fileEvent);
            FileEvent fileEvent2 = new FileEvent((FileObject)MasterFileObject.this, (FileObject)masterFileObject, fileEvent.isExpected());
            FileObject fileObject = masterFileObject.getDelegate().get();
            FileObject fileObject2 = MasterFileObject.this.getDelegate().get();
            if (fileObject == fileEvent.getFile() && fileObject2 == fileEvent.getSource()) {
                MasterFileObject.this.fireFileChangedEvent(MasterFileObject.this.getEnumOfListeners(), fileEvent2);
            }
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            String string = fileRenameEvent.getName();
            String string2 = fileRenameEvent.getExt();
            MasterFileObject masterFileObject = MasterFileObject.this.eventFileToMasterFileObject((FileEvent)fileRenameEvent);
            FileRenameEvent fileRenameEvent2 = new FileRenameEvent((FileObject)MasterFileObject.this, (FileObject)masterFileObject, string, string2);
            FileObject fileObject = masterFileObject.getDelegate().get();
            FileObject fileObject2 = MasterFileObject.this.getDelegate().get();
            if (fileObject == fileRenameEvent.getFile() && fileObject2 == fileRenameEvent.getSource()) {
                MasterFileObject.this.fireFileRenamedEvent(MasterFileObject.this.getEnumOfListeners(), fileRenameEvent2);
            }
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
            MasterFileObject masterFileObject = MasterFileObject.this.eventFileToMasterFileObject((FileEvent)fileAttributeEvent);
            FileAttributeEvent fileAttributeEvent2 = new FileAttributeEvent((FileObject)MasterFileObject.this, (FileObject)masterFileObject, fileAttributeEvent.getName(), fileAttributeEvent.getOldValue(), fileAttributeEvent.getNewValue());
            FileObject fileObject = masterFileObject.getDelegate().get();
            FileObject fileObject2 = MasterFileObject.this.getDelegate().get();
            if (fileObject == fileAttributeEvent.getFile() && fileObject2 == fileAttributeEvent.getSource()) {
                MasterFileObject.this.fireFileAttributeChangedEvent(MasterFileObject.this.getEnumOfListeners(), fileAttributeEvent2);
            }
        }
    }

    public static final class Replace
    implements Serializable {
        static final long serialVersionUID = -8552332135435542113L;
        private final String path;

        public Replace(String string) {
            this.path = string;
        }

        public Object readResolve() {
            FileObject fileObject;
            MasterFileSystem masterFileSystem = MasterFileSystem.getDefault();
            FileObject fileObject2 = fileObject = masterFileSystem == null ? null : masterFileSystem.findResource(this.path);
            if (fileObject == null) {
                fileObject = (FileObject)new ReplaceForSerialization(new File(this.path)).readResolve();
            }
            return fileObject;
        }
    }
}

