/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.execute;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.netbeans.modules.db.sql.execute.StatementInfo;

public class SQLExecutionResult {
    private final StatementInfo statementInfo;
    private final Statement statement;
    private final ResultSet resultSet;
    private final SQLException exception;
    private final long executionTime;
    private final int rowCount;

    public SQLExecutionResult(StatementInfo statementInfo, Statement statement, ResultSet resultSet, long l) {
        this(statementInfo, statement, resultSet, -1, null, l);
    }

    public SQLExecutionResult(StatementInfo statementInfo, Statement statement, int n, long l) {
        this(statementInfo, statement, null, n, null, l);
    }

    public SQLExecutionResult(StatementInfo statementInfo, Statement statement, SQLException sQLException) {
        this(statementInfo, statement, null, -1, sQLException, 0L);
    }

    private SQLExecutionResult(StatementInfo statementInfo, Statement statement, ResultSet resultSet, int n, SQLException sQLException, long l) {
        this.statementInfo = statementInfo;
        this.statement = statement;
        this.resultSet = resultSet;
        this.rowCount = n;
        this.exception = sQLException;
        this.executionTime = l;
    }

    public StatementInfo getStatementInfo() {
        return this.statementInfo;
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public SQLException getException() {
        return this.exception;
    }

    public long getExecutionTime() {
        return this.executionTime;
    }

    public DatabaseMetaData getDatabaseMetaData() throws SQLException {
        return this.statement.getConnection().getMetaData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        try {
            if (this.resultSet != null) {
                this.resultSet.close();
            }
        }
        finally {
            if (this.statement != null) {
                this.statement.close();
            }
        }
    }

    public String toString() {
        return "SQLExecutionResult[resultSet=" + this.resultSet + ",rowCount=" + this.rowCount + ",exception=" + this.exception + ",executionTime=" + this.executionTime + "]";
    }
}

