/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.actions;

import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.ReportObjectScene;
import com.jaspersoft.ireport.designer.widgets.GuideLineWidget;
import com.jaspersoft.ireport.designer.widgets.JRDesignElementWidget;
import com.jaspersoft.ireport.designer.widgets.SelectionWidget;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignFrame;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.netbeans.api.visual.action.AlignWithWidgetCollector;
import org.netbeans.api.visual.widget.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportAlignWithWidgetCollector
implements AlignWithWidgetCollector {
    private List<Integer> verticalGuideLines = new ArrayList<Integer>();
    private List<Integer> horizontalGuideLines = new ArrayList<Integer>();
    private ReportObjectScene scene = null;

    public List<Integer> getHorizontalGuideLines() {
        return this.horizontalGuideLines;
    }

    public void setHorizontalGuideLines(List<Integer> horizontalGuideLines) {
        this.horizontalGuideLines = horizontalGuideLines;
    }

    public List<Integer> getVerticalGuideLines() {
        return this.verticalGuideLines;
    }

    public void setVerticalGuideLines(List<Integer> verticalGuideLines) {
        this.verticalGuideLines = verticalGuideLines;
    }

    public ReportAlignWithWidgetCollector(ReportObjectScene scene) {
        this.scene = scene;
    }

    public boolean isSelectedObject(Widget widget) {
        JRDesignElement obj = null;
        if (widget instanceof JRDesignElementWidget) {
            obj = ((JRDesignElementWidget)widget).getElement();
        } else if (widget instanceof SelectionWidget) {
            obj = ((SelectionWidget)widget).getRealWidget().getElement();
        }
        return ((ReportObjectScene)widget.getScene()).getSelectedObjects().contains(obj);
    }

    public boolean isChildOf(Widget widget, Widget parent) {
        if (widget instanceof JRDesignElementWidget) {
            if (parent instanceof SelectionWidget) {
                parent = ((SelectionWidget)parent).getRealWidget();
            }
            if (parent instanceof JRDesignElementWidget) {
                JRDesignElement frame = ((JRDesignElementWidget)parent).getElement();
                JRDesignElement element = ((JRDesignElementWidget)widget).getElement();
                if (frame instanceof JRDesignFrame) {
                    return ModelUtils.isChildOf(element, ((JRDesignFrame)frame).getElements());
                }
            }
        }
        return false;
    }

    public Collection<Rectangle> getRegions(Widget movingWidget) {
        List children = this.scene.getElementsLayer().getChildren();
        ArrayList<Rectangle> regions = new ArrayList<Rectangle>(children.size());
        for (Widget widget : children) {
            if (widget == movingWidget || this.isSelectedObject(widget) || this.isChildOf(widget, movingWidget)) continue;
            regions.add(widget.convertLocalToScene(widget.getClientArea()));
        }
        children = this.scene.getGuideLinesLayer().getChildren();
        for (Widget widget : children) {
            if (!(widget instanceof GuideLineWidget)) continue;
            Rectangle r = widget.getClientArea();
            r.width = 0;
            regions.add(widget.convertLocalToScene(r));
        }
        JasperDesign jd = this.scene.getJasperDesign();
        int bandLocation = jd.getTopMargin();
        regions.add(new Rectangle(jd.getLeftMargin(), bandLocation, jd.getPageWidth() - jd.getRightMargin() - jd.getLeftMargin(), 0));
        for (JRBand band : ModelUtils.getBands(jd)) {
            if (band.getHeight() <= 0) continue;
            regions.add(new Rectangle(jd.getLeftMargin(), bandLocation += band.getHeight(), jd.getPageWidth() - jd.getRightMargin() - jd.getLeftMargin(), 0));
        }
        return regions;
    }
}

