/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.data.fieldsproviders.olap;

import com.jaspersoft.ireport.designer.utils.Misc;
import javax.swing.tree.DefaultMutableTreeNode;
import mondrian.olap.FunCall;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.QueryAxis;

public class WalkableWrapper {
    Object walkable = null;
    String name = "";
    private DefaultMutableTreeNode parentNode = null;

    public WalkableWrapper(Object obj, DefaultMutableTreeNode parentNode) {
        this.walkable = obj;
        this.parentNode = parentNode;
        this.name = this.walkable instanceof QueryAxis ? ((QueryAxis)this.walkable).getAxisName() : (this.walkable instanceof FunCall ? ((FunCall)this.walkable).getFunName() : (this.walkable instanceof Level ? ((Level)this.walkable).getName() : (this.walkable instanceof Hierarchy ? ((Hierarchy)this.walkable).getName() : (this.walkable instanceof Member ? ((Member)this.walkable).getName() : this.getWalkable() + " (" + this.walkable.getClass().getName()))));
    }

    public boolean isMeasure() {
        return this.walkable instanceof Member && ((Member)this.walkable).isMeasure();
    }

    public String getExpression() {
        if (this.isMeasure()) {
            int qmarks = this.parentNode.getChildCount();
            String s = "Data(" + this.walkable + "";
            for (int i = 0; i < qmarks - 1; ++i) {
                s = s + ",?";
            }
            s = s + ")";
            return s;
        }
        if (this.walkable instanceof Level) {
            DefaultMutableTreeNode node = this.getParentNode();
            DefaultMutableTreeNode nodeParent = (DefaultMutableTreeNode)this.getParentNode().getParent();
            while (nodeParent.getParent() != null) {
                node = nodeParent;
                nodeParent = (DefaultMutableTreeNode)nodeParent.getParent();
            }
            int axisIndex = nodeParent.getIndex(node);
            String s = "";
            switch (axisIndex) {
                case 0: {
                    s = "Columns";
                    break;
                }
                case 1: {
                    s = "Rows";
                    break;
                }
                case 2: {
                    s = "Pages";
                    break;
                }
                case 3: {
                    s = "Chapters";
                    break;
                }
                case 4: {
                    s = "Sections";
                    break;
                }
                default: {
                    s = "Axis(" + axisIndex + ")";
                }
            }
            s = s + Misc.string_replace("][", "].[", "" + this.walkable) + "";
            return s;
        }
        return null;
    }

    public Object getWalkable() {
        return this.walkable;
    }

    public void setWalkable(Object w) {
        this.walkable = w;
    }

    public String toString() {
        return this.name;
    }

    public DefaultMutableTreeNode getParentNode() {
        return this.parentNode;
    }

    public void setParentNode(DefaultMutableTreeNode parentNode) {
        this.parentNode = parentNode;
    }
}

