/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.outline.nodes.properties;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.editor.ExpressionContext;
import com.jaspersoft.ireport.designer.sheet.ExpressionProperty;
import com.jaspersoft.ireport.designer.undo.ObjectPropertyUndoableEdit;
import java.lang.reflect.InvocationTargetException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignSubreport;
import org.openide.ErrorManager;

public final class ConnectionExpressionProperty
extends ExpressionProperty {
    private final JRDesignDataset dataset;
    private final JRDesignSubreport element;

    public ConnectionExpressionProperty(JRDesignSubreport element, JRDesignDataset dataset) {
        super("connectionExpression", "Connection Expression", "The expression must return a java.sql.Connection object to fill the subreport.");
        this.element = element;
        this.dataset = dataset;
        this.setValue("expressionContext", new ExpressionContext(dataset));
    }

    public boolean canWrite() {
        return this.element.getConnectionExpression() != null;
    }

    public Object getValue() throws IllegalAccessException, InvocationTargetException {
        if (this.element.getConnectionExpression() == null) {
            return "";
        }
        if (this.element.getConnectionExpression().getText() == null) {
            return "";
        }
        return this.element.getConnectionExpression().getText();
    }

    public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        JRDesignExpression oldExp = (JRDesignExpression)this.element.getConnectionExpression();
        JRDesignExpression newExp = null;
        if (val == null) {
            this.element.setConnectionExpression(null);
        } else {
            String s = val != null ? val + "" : "";
            newExp = new JRDesignExpression();
            newExp.setText(s);
            this.element.setConnectionExpression((JRExpression)newExp);
        }
        ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.element, "ConnectionExpression", JRExpression.class, oldExp, newExp);
        IReportManager.getInstance().addUndoableEdit(urob);
    }

    public IllegalArgumentException annotateException(String msg) {
        IllegalArgumentException iae = new IllegalArgumentException(msg);
        ErrorManager.getDefault().annotate((Throwable)iae, 4096, msg, msg, null, null);
        return iae;
    }

    public String getHtmlDisplayName() {
        if (!this.canWrite()) {
            return "<font color=\"#CCCCCC\">" + this.getDisplayName() + "</font>";
        }
        return super.getHtmlDisplayName();
    }
}

