/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.outline.nodes.properties;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.editor.ExpressionContext;
import com.jaspersoft.ireport.designer.sheet.ExpressionProperty;
import com.jaspersoft.ireport.designer.undo.ObjectPropertyUndoableEdit;
import java.lang.reflect.InvocationTargetException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import org.openide.ErrorManager;

public final class PrintWhenExpressionProperty
extends ExpressionProperty {
    private final JRDesignDataset dataset;
    private final JRDesignElement element;

    public PrintWhenExpressionProperty(JRDesignElement element, JRDesignDataset dataset) {
        super("printWhenExpression", "Print When Expression", "Print this element only when this expression is blank or returns true.");
        this.element = element;
        this.dataset = dataset;
        this.setValue("expressionContext", new ExpressionContext(dataset));
    }

    public Object getValue() throws IllegalAccessException, InvocationTargetException {
        if (this.element.getPrintWhenExpression() == null || this.element.getPrintWhenExpression().getText() == null) {
            return "";
        }
        return this.element.getPrintWhenExpression().getText();
    }

    public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        JRDesignExpression oldExp = (JRDesignExpression)this.element.getPrintWhenExpression();
        JRDesignExpression newExp = null;
        if (val == null || val.equals("")) {
            this.element.setPrintWhenExpression(null);
        } else {
            String s = val != null ? val + "" : "";
            newExp = new JRDesignExpression();
            newExp.setText(s);
            this.element.setPrintWhenExpression((JRExpression)newExp);
        }
        ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.element, "PrintWhenExpression", JRExpression.class, oldExp, newExp);
        IReportManager.getInstance().addUndoableEdit(urob);
    }

    public IllegalArgumentException annotateException(String msg) {
        IllegalArgumentException iae = new IllegalArgumentException(msg);
        ErrorManager.getDefault().annotate((Throwable)iae, 4096, msg, msg, null, null);
        return iae;
    }

    public boolean isDefaultValue() {
        return this.element.getPrintWhenExpression() == null || this.element.getPrintWhenExpression().getText() == null || this.element.getPrintWhenExpression().getText().length() == 0;
    }

    public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
        this.setValue(null);
    }

    public boolean supportsDefaultValue() {
        return true;
    }
}

