/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GapList<E>
extends AbstractList<E>
implements List<E>,
RandomAccess,
Cloneable,
Serializable {
    private transient E[] elementData;
    private int gapStart;
    private int gapLength;

    public GapList(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n);
        }
        this.elementData = this.allocateElementsArray(n);
        this.gapLength = n;
    }

    public GapList() {
        this(10);
    }

    public GapList(Collection<? extends E> collection) {
        int n = collection.size();
        int n2 = (int)Math.min((long)n * 110L / 100L, Integer.MAX_VALUE);
        Object[] objectArray = collection.toArray(new Object[n2]);
        this.elementData = objectArray;
        this.gapStart = n;
        this.gapLength = this.elementData.length - n;
    }

    public void trimToSize() {
        ++this.modCount;
        if (this.gapLength > 0) {
            int n = this.elementData.length - this.gapLength;
            Object[] objectArray = this.allocateElementsArray(n);
            this.copyAllData(objectArray);
            this.elementData = objectArray;
            this.gapLength = 0;
        }
    }

    public void ensureCapacity(int n) {
        ++this.modCount;
        int n2 = this.elementData.length;
        if (n > n2) {
            int n3 = n2 * 3 / 2 + 1;
            if (n3 < n) {
                n3 = n;
            }
            int n4 = this.gapStart + this.gapLength;
            int n5 = n2 - n4;
            int n6 = n3 - n5;
            E[] EArray = this.allocateElementsArray(n3);
            System.arraycopy(this.elementData, 0, EArray, 0, this.gapStart);
            System.arraycopy(this.elementData, n4, EArray, n6, n5);
            this.elementData = EArray;
            this.gapLength = n6 - this.gapStart;
        }
    }

    @Override
    public int size() {
        return this.elementData.length - this.gapLength;
    }

    @Override
    public boolean isEmpty() {
        return this.elementData.length == this.gapLength;
    }

    @Override
    public boolean contains(Object object) {
        return this.indexOf(object) >= 0;
    }

    @Override
    public int indexOf(Object object) {
        if (object == null) {
            int n;
            for (n = 0; n < this.gapStart; ++n) {
                if (this.elementData[n] != null) continue;
                return n;
            }
            n += this.gapLength;
            int n2 = this.elementData.length;
            while (n < n2) {
                if (this.elementData[n] == null) {
                    return n;
                }
                ++n;
            }
        } else {
            int n;
            for (n = 0; n < this.gapStart; ++n) {
                if (!object.equals(this.elementData[n])) continue;
                return n;
            }
            n += this.gapLength;
            int n3 = this.elementData.length;
            while (n < n3) {
                if (object.equals(this.elementData[n])) {
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        if (object == null) {
            int n;
            int n2 = this.gapStart + this.gapLength;
            for (n = this.elementData.length - 1; n >= n2; --n) {
                if (this.elementData[n] != null) continue;
                return n;
            }
            n -= this.gapLength;
            while (n >= 0) {
                if (this.elementData[n] == null) {
                    return n;
                }
                --n;
            }
        } else {
            int n;
            int n3 = this.gapStart + this.gapLength;
            for (n = this.elementData.length - 1; n >= n3; --n) {
                if (!object.equals(this.elementData[n])) continue;
                return n;
            }
            n -= this.gapLength;
            while (n >= 0) {
                if (object.equals(this.elementData[n])) {
                    return n;
                }
                --n;
            }
        }
        return -1;
    }

    public Object clone() {
        try {
            GapList gapList = (GapList)super.clone();
            int n = this.size();
            Object[] objectArray = this.allocateElementsArray(n);
            this.copyAllData(objectArray);
            gapList.elementData = objectArray;
            gapList.gapStart = n;
            gapList.resetModCount();
            return gapList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public void copyItems(int n, int n2, Object[] objectArray, int n3) {
        this.copyElements(n, n2, objectArray, n3);
    }

    public void copyElements(int n, int n2, Object[] objectArray, int n3) {
        if (n < 0 || n2 < n || n2 > this.size()) {
            throw new IndexOutOfBoundsException("startIndex=" + n + ", endIndex=" + n2 + ", size()=" + this.size());
        }
        if (n2 < this.gapStart) {
            System.arraycopy(this.elementData, n, objectArray, n3, n2 - n);
        } else if (n >= this.gapStart) {
            System.arraycopy(this.elementData, n + this.gapLength, objectArray, n3, n2 - n);
        } else {
            int n4 = this.gapStart - n;
            System.arraycopy(this.elementData, n, objectArray, n3, n4);
            System.arraycopy(this.elementData, this.gapStart + this.gapLength, objectArray, n3 + n4, n2 - n - n4);
        }
    }

    public void copyElements(int n, int n2, Collection<E> collection) {
        if (n < 0 || n2 < n || n2 > this.size()) {
            throw new IndexOutOfBoundsException("startIndex=" + n + ", endIndex=" + n2 + ", size()=" + this.size());
        }
        if (n2 < this.gapStart) {
            while (n < n2) {
                collection.add(this.elementData[n++]);
            }
        } else if (n >= this.gapStart) {
            n += this.gapLength;
            n2 += this.gapLength;
            while (n < n2) {
                collection.add(this.elementData[n++]);
            }
        } else {
            while (n < this.gapStart) {
                collection.add(this.elementData[n++]);
            }
            n += this.gapLength;
            n2 += this.gapLength;
            while (n < n2) {
                collection.add(this.elementData[n++]);
            }
        }
    }

    @Override
    public Object[] toArray() {
        int n = this.size();
        Object[] objectArray = new Object[n];
        this.copyAllData(objectArray);
        return objectArray;
    }

    @Override
    public <T> T[] toArray(T[] objectArray) {
        int n = this.size();
        if (objectArray.length < n) {
            Object[] objectArray2 = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n);
            objectArray = objectArray2;
        }
        this.copyAllData(objectArray);
        if (objectArray.length > n) {
            objectArray[n] = null;
        }
        return objectArray;
    }

    @Override
    public E get(int n) {
        return this.elementData[n < this.gapStart ? n : n + this.gapLength];
    }

    @Override
    public E set(int n, E e) {
        if (n >= this.gapStart) {
            n += this.gapLength;
        }
        E e2 = this.elementData[n];
        this.elementData[n] = e;
        return e2;
    }

    public void swap(int n, int n2) {
        if (n >= this.gapStart) {
            n += this.gapLength;
        }
        if (n2 >= this.gapStart) {
            n2 += this.gapLength;
        }
        E e = this.elementData[n];
        this.elementData[n] = this.elementData[n2];
        this.elementData[n2] = e;
    }

    @Override
    public boolean add(E e) {
        int n = this.size();
        this.ensureCapacity(n + 1);
        this.addImpl(n, e);
        return true;
    }

    @Override
    public void add(int n, E e) {
        int n2 = this.size();
        if (n > n2 || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + n2);
        }
        this.ensureCapacity(n2 + 1);
        this.addImpl(n, e);
    }

    private void addImpl(int n, E e) {
        this.moveGap(n);
        this.elementData[this.gapStart++] = e;
        --this.gapLength;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        return this.addAll(this.size(), collection);
    }

    @Override
    public boolean addAll(int n, Collection<? extends E> collection) {
        return this.addArray(n, collection.toArray());
    }

    public boolean addArray(int n, Object[] objectArray) {
        return this.addArray(n, objectArray, 0, objectArray.length);
    }

    public boolean addArray(int n, Object[] objectArray, int n2, int n3) {
        int n4 = this.size();
        if (n > n4 || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + n4);
        }
        this.ensureCapacity(n4 + n3);
        this.moveGap(n);
        System.arraycopy(objectArray, n2, this.elementData, n, n3);
        this.gapStart += n3;
        this.gapLength -= n3;
        return n3 != 0;
    }

    @Override
    public void clear() {
        this.removeRange(0, this.size());
    }

    @Override
    public E remove(int n) {
        int n2 = this.size();
        if (n >= n2 || n < 0) {
            throw new IndexOutOfBoundsException("remove(): Index: " + n + ", Size: " + n2);
        }
        ++this.modCount;
        this.moveGap(n + 1);
        E e = this.elementData[n];
        this.elementData[n] = null;
        --this.gapStart;
        ++this.gapLength;
        return e;
    }

    public void remove(int n, int n2) {
        int n3 = n + n2;
        if (n < 0 || n3 < n || n3 > this.size()) {
            throw new IndexOutOfBoundsException("index=" + n + ", count=" + n2 + ", size()=" + this.size());
        }
        this.removeRange(n, n3);
    }

    @Override
    protected void removeRange(int n, int n2) {
        ++this.modCount;
        if (n == n2) {
            return;
        }
        int n3 = n2 - n;
        if (n >= this.gapStart) {
            this.moveGap(n);
            n += this.gapLength;
            n2 += this.gapLength;
            while (n < n2) {
                this.elementData[n] = null;
                ++n;
            }
        } else {
            if (n2 <= this.gapStart) {
                this.moveGap(n2);
                this.gapStart = n;
            } else {
                for (int i = n; i < this.gapStart; ++i) {
                    this.elementData[i] = null;
                }
                n = this.gapStart + this.gapLength;
                this.gapStart = n2 - n3;
                n2 += this.gapLength;
            }
            while (n < n2) {
                this.elementData[n++] = null;
            }
        }
        this.gapLength += n3;
    }

    private void moveGap(int n) {
        if (n == this.gapStart) {
            return;
        }
        if (this.gapLength > 0) {
            if (n < this.gapStart) {
                int n2 = this.gapStart - n;
                System.arraycopy(this.elementData, n, this.elementData, this.gapStart + this.gapLength - n2, n2);
                this.clearEmpty(n, Math.min(n2, this.gapLength));
            } else {
                int n3 = this.gapStart + this.gapLength;
                int n4 = n - this.gapStart;
                System.arraycopy(this.elementData, n3, this.elementData, this.gapStart, n4);
                if (n < n3) {
                    this.clearEmpty(n3, n4);
                } else {
                    this.clearEmpty(n, this.gapLength);
                }
            }
        }
        this.gapStart = n;
    }

    private void copyAllData(Object[] objectArray) {
        if (this.gapLength != 0) {
            int n = this.gapStart + this.gapLength;
            System.arraycopy(this.elementData, 0, objectArray, 0, this.gapStart);
            System.arraycopy(this.elementData, n, objectArray, this.gapStart, this.elementData.length - n);
        } else {
            System.arraycopy(this.elementData, 0, objectArray, 0, this.elementData.length);
        }
    }

    private void clearEmpty(int n, int n2) {
        while (--n2 >= 0) {
            this.elementData[n++] = null;
        }
    }

    private void resetModCount() {
        this.modCount = 0;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        int n;
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.elementData.length);
        for (n = 0; n < this.gapStart; ++n) {
            objectOutputStream.writeObject(this.elementData[n]);
        }
        n += this.gapLength;
        int n2 = this.elementData.length;
        while (n < n2) {
            objectOutputStream.writeObject(this.elementData[n]);
            ++n;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n;
        objectInputStream.defaultReadObject();
        int n2 = objectInputStream.readInt();
        this.elementData = this.allocateElementsArray(n2);
        for (n = 0; n < this.gapStart; ++n) {
            Object object = objectInputStream.readObject();
            this.elementData[n] = object;
        }
        n += this.gapLength;
        int n3 = this.elementData.length;
        while (n < n3) {
            Object object = objectInputStream.readObject();
            this.elementData[n] = object;
            ++n;
        }
    }

    protected void consistencyCheck() {
        if (this.gapStart < 0 || this.gapLength < 0 || this.gapStart + this.gapLength > this.elementData.length) {
            this.consistencyError("Inconsistent gap");
        }
        for (int i = this.gapStart + this.gapLength - 1; i >= this.gapStart; --i) {
            if (this.elementData[i] == null) continue;
            this.consistencyError("Non-null value at raw-index i");
        }
    }

    protected final void consistencyError(String string) {
        throw new IllegalStateException(string + ": " + this.dumpDetails());
    }

    protected String dumpDetails() {
        return this.dumpInternals() + "; DATA:\n" + this.toString();
    }

    protected String dumpInternals() {
        return "elems: " + this.size() + '(' + this.elementData.length + "), gap(s=" + this.gapStart + ", l=" + this.gapLength + ')';
    }

    private E[] allocateElementsArray(int n) {
        return new Object[n];
    }

    @Override
    public String toString() {
        return GapList.dumpElements(this);
    }

    public static String dumpElements(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = list.size();
        int n2 = GapList.indexDigitCount(n);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append('[');
            int n3 = n2 - GapList.indexDigitCount(i);
            while (n3 > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(i);
            stringBuffer.append("]: ");
            stringBuffer.append(list.get(i));
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    private static int indexDigitCount(int n) {
        int n2 = 1;
        while (n >= 10) {
            n /= 10;
            ++n2;
        }
        return n2;
    }
}

