/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.criterion;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.criterion.BetweenExpression;
import org.hibernate.criterion.Conjunction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.EmptyExpression;
import org.hibernate.criterion.IdentifierEqExpression;
import org.hibernate.criterion.IlikeExpression;
import org.hibernate.criterion.InExpression;
import org.hibernate.criterion.LogicalExpression;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.NaturalIdentifier;
import org.hibernate.criterion.NotEmptyExpression;
import org.hibernate.criterion.NotExpression;
import org.hibernate.criterion.NotNullExpression;
import org.hibernate.criterion.NullExpression;
import org.hibernate.criterion.PropertyExpression;
import org.hibernate.criterion.SQLCriterion;
import org.hibernate.criterion.SimpleExpression;
import org.hibernate.criterion.SizeExpression;
import org.hibernate.type.Type;
import org.hibernate.util.ArrayHelper;

public class Restrictions {
    Restrictions() {
    }

    public static Criterion idEq(Object value) {
        return new IdentifierEqExpression(value);
    }

    public static SimpleExpression eq(String propertyName, Object value) {
        return new SimpleExpression(propertyName, value, "=");
    }

    public static SimpleExpression ne(String propertyName, Object value) {
        return new SimpleExpression(propertyName, value, "<>");
    }

    public static SimpleExpression like(String propertyName, Object value) {
        return new SimpleExpression(propertyName, value, " like ");
    }

    public static SimpleExpression like(String propertyName, String value, MatchMode matchMode) {
        return new SimpleExpression(propertyName, matchMode.toMatchString(value), " like ");
    }

    public static Criterion ilike(String propertyName, String value, MatchMode matchMode) {
        return new IlikeExpression(propertyName, value, matchMode);
    }

    public static Criterion ilike(String propertyName, Object value) {
        return new IlikeExpression(propertyName, value);
    }

    public static SimpleExpression gt(String propertyName, Object value) {
        return new SimpleExpression(propertyName, value, ">");
    }

    public static SimpleExpression lt(String propertyName, Object value) {
        return new SimpleExpression(propertyName, value, "<");
    }

    public static SimpleExpression le(String propertyName, Object value) {
        return new SimpleExpression(propertyName, value, "<=");
    }

    public static SimpleExpression ge(String propertyName, Object value) {
        return new SimpleExpression(propertyName, value, ">=");
    }

    public static Criterion between(String propertyName, Object lo, Object hi) {
        return new BetweenExpression(propertyName, lo, hi);
    }

    public static Criterion in(String propertyName, Object[] values) {
        return new InExpression(propertyName, values);
    }

    public static Criterion in(String propertyName, Collection values) {
        return new InExpression(propertyName, values.toArray());
    }

    public static Criterion isNull(String propertyName) {
        return new NullExpression(propertyName);
    }

    public static PropertyExpression eqProperty(String propertyName, String otherPropertyName) {
        return new PropertyExpression(propertyName, otherPropertyName, "=");
    }

    public static PropertyExpression neProperty(String propertyName, String otherPropertyName) {
        return new PropertyExpression(propertyName, otherPropertyName, "<>");
    }

    public static PropertyExpression ltProperty(String propertyName, String otherPropertyName) {
        return new PropertyExpression(propertyName, otherPropertyName, "<");
    }

    public static PropertyExpression leProperty(String propertyName, String otherPropertyName) {
        return new PropertyExpression(propertyName, otherPropertyName, "<=");
    }

    public static PropertyExpression gtProperty(String propertyName, String otherPropertyName) {
        return new PropertyExpression(propertyName, otherPropertyName, ">");
    }

    public static PropertyExpression geProperty(String propertyName, String otherPropertyName) {
        return new PropertyExpression(propertyName, otherPropertyName, ">=");
    }

    public static Criterion isNotNull(String propertyName) {
        return new NotNullExpression(propertyName);
    }

    public static LogicalExpression and(Criterion lhs, Criterion rhs) {
        return new LogicalExpression(lhs, rhs, "and");
    }

    public static LogicalExpression or(Criterion lhs, Criterion rhs) {
        return new LogicalExpression(lhs, rhs, "or");
    }

    public static Criterion not(Criterion expression) {
        return new NotExpression(expression);
    }

    public static Criterion sqlRestriction(String sql, Object[] values, Type[] types) {
        return new SQLCriterion(sql, values, types);
    }

    public static Criterion sqlRestriction(String sql, Object value, Type type) {
        return new SQLCriterion(sql, new Object[]{value}, new Type[]{type});
    }

    public static Criterion sqlRestriction(String sql) {
        return new SQLCriterion(sql, ArrayHelper.EMPTY_OBJECT_ARRAY, ArrayHelper.EMPTY_TYPE_ARRAY);
    }

    public static Conjunction conjunction() {
        return new Conjunction();
    }

    public static Disjunction disjunction() {
        return new Disjunction();
    }

    public static Criterion allEq(Map propertyNameValues) {
        Conjunction conj = Restrictions.conjunction();
        Iterator iter = propertyNameValues.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry me = iter.next();
            conj.add(Restrictions.eq((String)me.getKey(), me.getValue()));
        }
        return conj;
    }

    public static Criterion isEmpty(String propertyName) {
        return new EmptyExpression(propertyName);
    }

    public static Criterion isNotEmpty(String propertyName) {
        return new NotEmptyExpression(propertyName);
    }

    public static Criterion sizeEq(String propertyName, int size) {
        return new SizeExpression(propertyName, size);
    }

    public static NaturalIdentifier naturalId() {
        return new NaturalIdentifier();
    }
}

