/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.actions.ActionUtils;
import org.openide.awt.Actions;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;

public class MaximizeWindowAction
extends AbstractAction {
    private final PropertyChangeListener propListener;
    private TopComponent topComponent;
    private boolean isPopup;

    public MaximizeWindowAction() {
        this.propListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if ("maximizedMode".equals(string) || "editorAreaState".equals(propertyChangeEvent.getPropertyName()) || "activeMode".equals(propertyChangeEvent.getPropertyName())) {
                    MaximizeWindowAction.this.updateState();
                }
                if ("activated".equals(string)) {
                    MaximizeWindowAction.this.updateState();
                }
            }
        };
        TopComponent.Registry registry = TopComponent.getRegistry();
        registry.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.propListener, (Object)registry));
        WindowManagerImpl windowManagerImpl = WindowManagerImpl.getInstance();
        windowManagerImpl.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.propListener, (Object)((Object)windowManagerImpl)));
        this.updateState();
    }

    public MaximizeWindowAction(TopComponent topComponent) {
        this.topComponent = topComponent;
        this.propListener = null;
        this.isPopup = true;
        this.updateState();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        TopComponent topComponent;
        WindowManagerImpl windowManagerImpl = WindowManagerImpl.getInstance();
        if (windowManagerImpl.isDocked(topComponent = this.getTCToWorkWith())) {
            ModeImpl modeImpl = (ModeImpl)windowManagerImpl.findMode(topComponent);
            String string = windowManagerImpl.findTopComponentID(topComponent);
            if (modeImpl.getKind() == 2) {
                windowManagerImpl.userToggledTopComponentSlideInMaximize(string);
            } else if (null != modeImpl) {
                ModeImpl modeImpl2 = windowManagerImpl.getCurrentMaximizedMode();
                if (null != modeImpl2) {
                    if (modeImpl2.getKind() == 1 && modeImpl.getKind() == 0) {
                        windowManagerImpl.switchMaximizedMode(modeImpl);
                    } else {
                        windowManagerImpl.switchMaximizedMode(null);
                    }
                } else {
                    windowManagerImpl.switchMaximizedMode(modeImpl);
                }
            } else {
                windowManagerImpl.switchMaximizedMode(null);
            }
        } else {
            ModeImpl modeImpl = (ModeImpl)windowManagerImpl.findMode(topComponent);
            if (modeImpl != null) {
                if (modeImpl.getFrameState() == 0) {
                    modeImpl.setFrameState(6);
                } else {
                    modeImpl.setFrameState(0);
                }
            }
        }
        this.updateState();
    }

    private void updateState() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doUpdateState();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MaximizeWindowAction.this.doUpdateState();
                }
            });
        }
    }

    private void doUpdateState() {
        boolean bl;
        WindowManagerImpl windowManagerImpl = WindowManagerImpl.getInstance();
        TopComponent topComponent = this.getTCToWorkWith();
        String string = topComponent == null ? "" : topComponent.getName();
        ModeImpl modeImpl = (ModeImpl)windowManagerImpl.findMode(topComponent);
        if (modeImpl == null) {
            return;
        }
        if (windowManagerImpl.isDocked(topComponent)) {
            bl = windowManagerImpl.getCurrentMaximizedMode() != modeImpl;
        } else {
            boolean bl2 = bl = modeImpl.getFrameState() == 0;
        }
        if (modeImpl != null && modeImpl.getKind() == 2) {
            bl = null != topComponent && !windowManagerImpl.isTopComponentMaximizedWhenSlidedIn(windowManagerImpl.findTopComponentID(topComponent));
        }
        String string2 = bl ? NbBundle.getMessage(MaximizeWindowAction.class, (String)"CTL_MaximizeWindowAction", (Object)string) : NbBundle.getMessage(MaximizeWindowAction.class, (String)"CTL_UnmaximizeWindowAction", (Object)string);
        this.putValue("Name", this.isPopup ? Actions.cutAmpersand((String)string2) : string2);
        this.setEnabled(modeImpl != null);
    }

    private TopComponent getTCToWorkWith() {
        if (this.topComponent != null) {
            return this.topComponent;
        }
        return TopComponent.getRegistry().getActivated();
    }

    public void putValue(String string, Object object) {
        if ("AcceleratorKey".equals(string)) {
            ActionUtils.putSharedAccelerator("MaximizeWindow", object);
        } else {
            super.putValue(string, object);
        }
    }

    public Object getValue(String string) {
        if ("AcceleratorKey".equals(string)) {
            return ActionUtils.getSharedAccelerator("MaximizeWindow");
        }
        return super.getValue(string);
    }
}

