/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.services;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.DefaultKeyboardFocusManager;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventListener;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicLookAndFeel;
import javax.swing.plaf.basic.BasicOptionPaneUI;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.netbeans.core.NbTopManager;
import org.netbeans.core.windows.Constants;
import org.openide.DialogDescriptor;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.awt.EqualFlowLayout;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NbPresenter
extends JDialog
implements PropertyChangeListener,
WindowListener,
Mutex.Action<Void>,
Comparator<Object> {
    public static NbPresenter currentModalDialog;
    private static final ChangeSupport cs;
    protected NotifyDescriptor descriptor;
    private final JButton stdYesButton = new JButton(NbBundle.getBundle(NbPresenter.class).getString("YES_OPTION_CAPTION"));
    private final JButton stdNoButton = new JButton(NbBundle.getBundle(NbPresenter.class).getString("NO_OPTION_CAPTION"));
    private final JButton stdOKButton = new JButton(NbBundle.getBundle(NbPresenter.class).getString("OK_OPTION_CAPTION"));
    private final JButton stdCancelButton = new JButton(NbBundle.getBundle(NbPresenter.class).getString("CANCEL_OPTION_CAPTION"));
    private final JButton stdClosedButton = new JButton(NbBundle.getBundle(NbPresenter.class).getString("CLOSED_OPTION_CAPTION"));
    private final JButton stdHelpButton = new JButton();
    private final JButton stdDetailButton = new JButton(NbBundle.getBundle(NbPresenter.class).getString("HELP_OPTION_CAPTION"));
    private static final String ESCAPE_COMMAND = "Escape";
    private Component currentMessage;
    private JScrollPane currentScrollPane;
    private boolean leaf;
    private JPanel currentButtonsPanel;
    private Component[] currentPrimaryButtons;
    private Component[] currentSecondaryButtons;
    private int currentAlign;
    private ButtonListener buttonListener;
    private transient HelpCtx currentHelp;
    private transient boolean haveCalledInitializeButtons;
    static final Logger LOG;
    static final long serialVersionUID = -4508637164126678997L;
    private final HackTypeAhead hack;
    static Field markers;
    static Method dequeue;

    public NbPresenter(NotifyDescriptor notifyDescriptor, Frame frame, boolean bl) {
        super(frame, notifyDescriptor.getTitle(), bl);
        this.stdYesButton.setDefaultCapable(true);
        this.stdOKButton.setDefaultCapable(true);
        this.stdNoButton.setDefaultCapable(false);
        this.stdCancelButton.setDefaultCapable(false);
        this.stdCancelButton.setVerifyInputWhenFocusTarget(false);
        this.stdClosedButton.setDefaultCapable(false);
        this.stdHelpButton.setDefaultCapable(false);
        this.stdDetailButton.setDefaultCapable(false);
        Mnemonics.setLocalizedText((AbstractButton)this.stdHelpButton, (String)NbBundle.getBundle(NbPresenter.class).getString("HELP_OPTION_CAPTION"));
        this.initAccessibility();
        this.leaf = false;
        this.currentHelp = null;
        this.haveCalledInitializeButtons = false;
        this.hack = new HackTypeAhead();
        this.initialize(notifyDescriptor);
    }

    public NbPresenter(NotifyDescriptor notifyDescriptor, Dialog dialog, boolean bl) {
        super(dialog, notifyDescriptor.getTitle(), bl);
        this.stdYesButton.setDefaultCapable(true);
        this.stdOKButton.setDefaultCapable(true);
        this.stdNoButton.setDefaultCapable(false);
        this.stdCancelButton.setDefaultCapable(false);
        this.stdCancelButton.setVerifyInputWhenFocusTarget(false);
        this.stdClosedButton.setDefaultCapable(false);
        this.stdHelpButton.setDefaultCapable(false);
        this.stdDetailButton.setDefaultCapable(false);
        Mnemonics.setLocalizedText((AbstractButton)this.stdHelpButton, (String)NbBundle.getBundle(NbPresenter.class).getString("HELP_OPTION_CAPTION"));
        this.initAccessibility();
        this.leaf = false;
        this.currentHelp = null;
        this.haveCalledInitializeButtons = false;
        this.hack = new HackTypeAhead();
        this.initialize(notifyDescriptor);
    }

    boolean isLeaf() {
        return this.leaf;
    }

    private void initAccessibility() {
        ResourceBundle resourceBundle = NbBundle.getBundle(NbPresenter.class);
        this.stdYesButton.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACS_YES_OPTION_NAME"));
        this.stdYesButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_YES_OPTION_DESC"));
        this.stdNoButton.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACS_NO_OPTION_NAME"));
        this.stdNoButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_NO_OPTION_DESC"));
        this.stdOKButton.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACS_OK_OPTION_NAME"));
        this.stdOKButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_OK_OPTION_DESC"));
        this.stdCancelButton.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACS_CANCEL_OPTION_NAME"));
        this.stdCancelButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_CANCEL_OPTION_DESC"));
        this.stdClosedButton.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACS_CLOSED_OPTION_NAME"));
        this.stdClosedButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_CLOSED_OPTION_DESC"));
        this.stdHelpButton.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACS_HELP_OPTION_NAME"));
        this.stdHelpButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_HELP_OPTION_DESC"));
        this.stdDetailButton.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACS_HELP_OPTION_NAME"));
        this.stdDetailButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_HELP_OPTION_DESC"));
    }

    private void initialize(NotifyDescriptor notifyDescriptor) {
        this.getRootPane().setOpaque(true);
        if (notifyDescriptor instanceof WizardDescriptor) {
            this.setDefaultCloseOperation(0);
        } else {
            this.setDefaultCloseOperation(2);
        }
        this.descriptor = notifyDescriptor;
        this.buttonListener = new ButtonListener();
        this.leaf = notifyDescriptor instanceof DialogDescriptor ? ((DialogDescriptor)notifyDescriptor).isLeaf() : true;
        this.getRootPane().registerKeyboardAction(this.buttonListener, ESCAPE_COMMAND, KeyStroke.getKeyStroke(27, 0), 1);
        this.initializePresenter();
        this.pack();
        this.setBounds(Utilities.findCenterBounds((Dimension)this.getSize()));
    }

    private void requestFocusForMessage() {
        Component component = this.currentMessage;
        if (component == null) {
            return;
        }
        if (!(component instanceof JComponent) || !((JComponent)component).requestDefaultFocus()) {
            component.requestFocus();
        }
    }

    private void initializeMessage() {
        Object object = this.descriptor.getMessage();
        if (this.currentMessage == null || !this.currentMessage.equals(object)) {
            this.uninitializeMessage();
            this.currentMessage = this.descriptor.getMessageType() == -1 && object instanceof Component ? (Component)object : this.createOptionPane();
            Dimension dimension = this.currentMessage.getPreferredSize();
            final Rectangle rectangle = Utilities.getUsableScreenBounds();
            if (dimension.width > rectangle.width - 100 || dimension.height > rectangle.height - 100) {
                this.currentScrollPane = new JScrollPane(){

                    public Dimension getPreferredSize() {
                        Dimension dimension = new Dimension(super.getPreferredSize());
                        if (dimension.width > rectangle.width - 100) {
                            dimension.width = rectangle.width * 3 / 4;
                        }
                        if (dimension.height > rectangle.height - 100) {
                            dimension.height = rectangle.height * 3 / 4;
                        }
                        return dimension;
                    }
                };
                this.currentScrollPane.setViewportView(this.currentMessage);
                this.getContentPane().add((Component)this.currentScrollPane, "Center");
            } else {
                this.getContentPane().add(this.currentMessage, "Center");
            }
        }
    }

    private void uninitializeMessage() {
        if (this.currentMessage != null) {
            if (this.currentScrollPane != null) {
                this.getContentPane().remove(this.currentScrollPane);
                this.currentScrollPane = null;
            } else {
                this.getContentPane().remove(this.currentMessage);
            }
            this.currentMessage = null;
        }
    }

    private void initializePresenter() {
        if (this.currentMessage != null) {
            return;
        }
        this.initializeMessage();
        this.updateHelp();
        this.initializeButtons();
        this.haveCalledInitializeButtons = true;
        this.descriptor.addPropertyChangeListener((PropertyChangeListener)this);
        this.addWindowListener(this);
        this.initializeClosingOptions();
    }

    private void uninitializePresenter() {
        this.descriptor.removePropertyChangeListener((PropertyChangeListener)this);
        this.uninitializeMessage();
        this.uninitializeButtons();
        this.uninitializeClosingOptions();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.initializePresenter();
        this.hack.activate();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.uninitializePresenter();
    }

    private JOptionPane createOptionPane() {
        Object object = this.descriptor.getMessage();
        boolean bl = true;
        String string = null;
        if (object instanceof String) {
            object = Utilities.replaceString((String)((String)object), (String)"\t", (String)"    ");
            string = (String)(object = Utilities.replaceString((String)((String)object), (String)"\r", (String)""));
            String string2 = string.toLowerCase();
            boolean bl2 = bl = !string2.startsWith("<html>");
        }
        if (object instanceof Accessible) {
            string = ((Accessible)object).getAccessibleContext().getAccessibleDescription();
        }
        JOptionPane jOptionPane = bl ? new JOptionPane(object, this.descriptor.getMessageType(), 0, null, new Object[0], null){

            public int getMaxCharactersPerLineCount() {
                return 100;
            }
        } : new JOptionPane(object, this.descriptor.getMessageType(), 0, null, new Object[0], null);
        if (UIManager.getLookAndFeel().getClass() == MetalLookAndFeel.class || UIManager.getLookAndFeel().getClass() == BasicLookAndFeel.class) {
            jOptionPane.setUI(new BasicOptionPaneUI(){

                public Dimension getMinimumOptionPaneSize() {
                    if (this.minimumSize == null) {
                        return new Dimension(262, 50);
                    }
                    return new Dimension(this.minimumSize.width, 50);
                }
            });
        }
        jOptionPane.setWantsInput(false);
        jOptionPane.getAccessibleContext().setAccessibleDescription(string);
        return jOptionPane;
    }

    private void uninitializeButtons() {
        if (this.currentButtonsPanel != null) {
            int n;
            if (this.currentPrimaryButtons != null) {
                for (n = 0; n < this.currentPrimaryButtons.length; ++n) {
                    this.modifyListener(this.currentPrimaryButtons[n], this.buttonListener, false);
                }
            }
            if (this.currentSecondaryButtons != null) {
                for (n = 0; n < this.currentSecondaryButtons.length; ++n) {
                    this.modifyListener(this.currentSecondaryButtons[n], this.buttonListener, false);
                }
            }
            this.getContentPane().remove(this.currentButtonsPanel);
            this.currentButtonsPanel = null;
        }
    }

    private void initializeClosingOptions(boolean bl) {
        Object[] objectArray = this.getClosingOptions();
        if (objectArray == null) {
            return;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            this.modifyListener(objectArray[i], this.buttonListener, bl);
        }
    }

    private void initializeClosingOptions() {
        this.initializeClosingOptions(true);
    }

    private void uninitializeClosingOptions() {
        this.initializeClosingOptions(false);
    }

    @Override
    public int compare(Object object, Object object2) {
        boolean bl = object.equals(this.descriptor.getDefaultValue());
        int n = object.equals(NotifyDescriptor.OK_OPTION) || object.equals(NotifyDescriptor.YES_OPTION) ? 1 : 0;
        if (bl) {
            ++n;
        }
        return n;
    }

    protected final void initializeButtons() {
        JComponent jComponent;
        int n;
        boolean bl;
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        boolean bl2 = Constants.DO_NOT_SHOW_HELP_IN_DIALOGS || this.descriptor instanceof WizardDescriptor && Boolean.FALSE.equals(((WizardDescriptor)this.descriptor).getProperty("WizardPanel_helpDisplayed"));
        boolean bl3 = this.stdHelpButton.isShowing() || this.descriptor instanceof WizardDescriptor && !bl2;
        this.uninitializeButtons();
        Object[] objectArray = this.descriptor.getOptions();
        Object[] objectArray2 = this.descriptor.getAdditionalOptions();
        this.currentAlign = this.getOptionsAlign();
        this.currentPrimaryButtons = null;
        this.currentSecondaryButtons = null;
        boolean bl4 = bl = "Aqua".equals(UIManager.getLookAndFeel().getID()) || "true".equalsIgnoreCase(System.getProperty("xtest.looks_as_mac"));
        if (bl) {
            this.currentAlign = 0;
        }
        if (objectArray != null) {
            if (bl) {
                Arrays.sort(objectArray, this);
            }
            this.currentPrimaryButtons = new Component[objectArray.length];
            for (n = 0; n < objectArray.length; ++n) {
                if (objectArray[n] == NotifyDescriptor.YES_OPTION) {
                    this.currentPrimaryButtons[n] = this.stdYesButton;
                    continue;
                }
                if (objectArray[n] == NotifyDescriptor.NO_OPTION) {
                    this.currentPrimaryButtons[n] = this.stdNoButton;
                    continue;
                }
                if (objectArray[n] == NotifyDescriptor.OK_OPTION) {
                    this.currentPrimaryButtons[n] = this.stdOKButton;
                    this.stdOKButton.setEnabled(this.descriptor.isValid());
                    continue;
                }
                if (objectArray[n] == NotifyDescriptor.CANCEL_OPTION) {
                    this.currentPrimaryButtons[n] = this.stdCancelButton;
                    continue;
                }
                if (objectArray[n] == NotifyDescriptor.CLOSED_OPTION) {
                    this.currentPrimaryButtons[n] = this.stdClosedButton;
                    continue;
                }
                if (objectArray[n] instanceof Component) {
                    this.currentPrimaryButtons[n] = (Component)objectArray[n];
                    continue;
                }
                if (objectArray[n] instanceof Icon) {
                    jComponent = new JButton((Icon)objectArray[n]);
                    ((JButton)jComponent).setDefaultCapable(false);
                    this.currentPrimaryButtons[n] = jComponent;
                    continue;
                }
                jComponent = new JButton();
                Mnemonics.setLocalizedText((AbstractButton)jComponent, (String)objectArray[n].toString());
                ((JButton)jComponent).setDefaultCapable(objectArray[n].equals(this.descriptor.getDefaultValue()));
                this.currentPrimaryButtons[n] = jComponent;
            }
        } else {
            switch (this.descriptor.getOptionType()) {
                case 0: {
                    if (bl) {
                        this.currentPrimaryButtons = new Component[2];
                        this.currentPrimaryButtons[0] = this.stdNoButton;
                        this.currentPrimaryButtons[1] = this.stdYesButton;
                        break;
                    }
                    this.currentPrimaryButtons = new Component[2];
                    this.currentPrimaryButtons[0] = this.stdYesButton;
                    this.currentPrimaryButtons[1] = this.stdNoButton;
                    break;
                }
                case 1: {
                    this.currentPrimaryButtons = new Component[3];
                    if (bl) {
                        this.currentPrimaryButtons[0] = this.stdCancelButton;
                        this.currentPrimaryButtons[1] = this.stdNoButton;
                        this.currentPrimaryButtons[2] = this.stdYesButton;
                        break;
                    }
                    this.currentPrimaryButtons[0] = this.stdYesButton;
                    this.currentPrimaryButtons[1] = this.stdNoButton;
                    this.currentPrimaryButtons[2] = this.stdCancelButton;
                    break;
                }
                default: {
                    if (bl) {
                        this.currentPrimaryButtons = new Component[2];
                        this.currentPrimaryButtons[0] = this.stdCancelButton;
                        this.currentPrimaryButtons[1] = this.stdOKButton;
                    } else {
                        this.currentPrimaryButtons = new Component[2];
                        this.currentPrimaryButtons[0] = this.stdOKButton;
                        this.currentPrimaryButtons[1] = this.stdCancelButton;
                    }
                    this.stdOKButton.setEnabled(this.descriptor.isValid());
                }
            }
        }
        if (!bl2 && (this.currentHelp != null || bl3)) {
            if (this.currentPrimaryButtons == null) {
                this.currentPrimaryButtons = new Component[0];
            }
            Component[] componentArray = new Component[this.currentPrimaryButtons.length + 1];
            if (bl) {
                System.arraycopy(this.currentPrimaryButtons, 0, componentArray, 1, this.currentPrimaryButtons.length);
                componentArray[0] = this.stdHelpButton;
            } else {
                System.arraycopy(this.currentPrimaryButtons, 0, componentArray, 0, this.currentPrimaryButtons.length);
                componentArray[this.currentPrimaryButtons.length] = this.stdHelpButton;
            }
            this.currentPrimaryButtons = componentArray;
            this.stdHelpButton.setEnabled(this.currentHelp != null);
        }
        if (objectArray2 != null && objectArray2.length != 0) {
            this.currentSecondaryButtons = new Component[objectArray2.length];
            Arrays.sort(objectArray2, this);
            for (n = 0; n < objectArray2.length; ++n) {
                if (objectArray2[n] == NotifyDescriptor.YES_OPTION) {
                    this.currentSecondaryButtons[n] = this.stdYesButton;
                    continue;
                }
                if (objectArray2[n] == NotifyDescriptor.NO_OPTION) {
                    this.currentSecondaryButtons[n] = this.stdNoButton;
                    continue;
                }
                if (objectArray2[n] == NotifyDescriptor.OK_OPTION) {
                    this.currentSecondaryButtons[n] = this.stdOKButton;
                    this.stdOKButton.setEnabled(this.descriptor.isValid());
                    continue;
                }
                if (objectArray2[n] == NotifyDescriptor.CANCEL_OPTION) {
                    this.currentSecondaryButtons[n] = this.stdCancelButton;
                    continue;
                }
                if (objectArray2[n] == NotifyDescriptor.CLOSED_OPTION) {
                    this.currentSecondaryButtons[n] = this.stdClosedButton;
                    continue;
                }
                if (objectArray2[n] instanceof Component) {
                    this.currentSecondaryButtons[n] = (Component)objectArray2[n];
                    continue;
                }
                if (objectArray2[n] instanceof Icon) {
                    jComponent = new JButton((Icon)objectArray2[n]);
                    this.currentSecondaryButtons[n] = jComponent;
                    continue;
                }
                jComponent = new JButton();
                Mnemonics.setLocalizedText((AbstractButton)jComponent, (String)objectArray2[n].toString());
                this.currentSecondaryButtons[n] = jComponent;
            }
        }
        if (this.currentAlign == 0 || this.currentAlign == -1) {
            int n2;
            JPanel jPanel = null;
            jComponent = null;
            if (this.currentPrimaryButtons != null) {
                jPanel = new JPanel();
                if (this.currentAlign == -1) {
                    jPanel.setLayout((LayoutManager)new EqualFlowLayout());
                } else {
                    jPanel.setLayout((LayoutManager)new EqualFlowLayout(2));
                }
                for (n2 = 0; n2 < this.currentPrimaryButtons.length; ++n2) {
                    this.modifyListener(this.currentPrimaryButtons[n2], this.buttonListener, true);
                    jPanel.add(this.currentPrimaryButtons[n2]);
                }
            }
            if (this.currentSecondaryButtons != null) {
                jComponent = new JPanel();
                jComponent.setLayout((LayoutManager)new EqualFlowLayout(0));
                for (n2 = 0; n2 < this.currentSecondaryButtons.length; ++n2) {
                    this.modifyListener(this.currentSecondaryButtons[n2], this.buttonListener, true);
                    jComponent.add(this.currentSecondaryButtons[n2]);
                }
            }
            if (jPanel != null && jComponent != null) {
                this.currentButtonsPanel = new JPanel();
                this.currentButtonsPanel.setLayout(new BorderLayout());
                this.currentButtonsPanel.add((Component)jPanel, "East");
                this.currentButtonsPanel.add((Component)jComponent, "West");
            } else {
                this.currentButtonsPanel = jPanel != null ? jPanel : jComponent;
            }
            if (this.currentButtonsPanel != null && this.currentButtonsPanel.getComponentCount() != 0) {
                if (this.currentButtonsPanel.getBorder() == null) {
                    this.currentButtonsPanel.setBorder(new EmptyBorder(new Insets(11, 6, 5, 5)));
                }
                this.getContentPane().add((Component)this.currentButtonsPanel, "South");
            }
        } else if (this.currentAlign == 1) {
            this.currentButtonsPanel = new JPanel();
            this.currentButtonsPanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(5, 4, 2, 5);
            gridBagConstraints.fill = 2;
            if (this.currentPrimaryButtons != null) {
                for (int i = 0; i < this.currentPrimaryButtons.length; ++i) {
                    this.modifyListener(this.currentPrimaryButtons[i], this.buttonListener, true);
                    this.currentButtonsPanel.add(this.currentPrimaryButtons[i], gridBagConstraints);
                }
            }
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridwidth = 0;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.fill = 1;
            this.currentButtonsPanel.add((Component)new JPanel(), gridBagConstraints2);
            gridBagConstraints.insets = new Insets(2, 4, 5, 5);
            if (this.currentSecondaryButtons != null) {
                for (int i = 0; i < this.currentSecondaryButtons.length; ++i) {
                    this.modifyListener(this.currentSecondaryButtons[i], this.buttonListener, true);
                    this.currentButtonsPanel.add(this.currentSecondaryButtons[i], gridBagConstraints);
                }
            }
            if (this.currentButtonsPanel != null) {
                if (this.currentButtonsPanel.getBorder() == null) {
                    this.currentButtonsPanel.setBorder(new EmptyBorder(new Insets(6, 7, 5, 5)));
                }
                this.getContentPane().add((Component)this.currentButtonsPanel, "East");
            }
        }
        this.updateDefaultButton();
        Component component2 = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (component2 != component && component != null) {
            component.requestFocus();
        }
    }

    private void updateDefaultButton() {
        JButton jButton;
        if (this.descriptor.getDefaultValue() != null && this.descriptor.getDefaultValue() instanceof JButton && (jButton = (JButton)this.descriptor.getDefaultValue()).isVisible() && jButton.isEnabled() && jButton.isDefaultCapable()) {
            this.getRootPane().setDefaultButton(jButton);
            return;
        }
        if (this.currentPrimaryButtons != null) {
            for (int i = 0; i < this.currentPrimaryButtons.length; ++i) {
                JButton jButton2;
                if (!(this.currentPrimaryButtons[i] instanceof JButton) || !(jButton2 = (JButton)this.currentPrimaryButtons[i]).isVisible() || !jButton2.isEnabled() || !jButton2.isDefaultCapable()) continue;
                this.getRootPane().setDefaultButton(jButton2);
                return;
            }
        }
        this.getRootPane().setDefaultButton(null);
    }

    private void updateOKButton(boolean bl) {
        JButton jButton;
        int n;
        if (this.currentPrimaryButtons != null) {
            for (n = 0; n < this.currentPrimaryButtons.length; ++n) {
                if (!(this.currentPrimaryButtons[n] instanceof JButton) || (jButton = (JButton)this.currentPrimaryButtons[n]) != this.stdOKButton || !jButton.isVisible()) continue;
                jButton.setEnabled(bl);
            }
        }
        if (this.currentSecondaryButtons != null) {
            for (n = 0; n < this.currentSecondaryButtons.length; ++n) {
                if (!(this.currentSecondaryButtons[n] instanceof JButton) || (jButton = (JButton)this.currentSecondaryButtons[n]) != this.stdOKButton || !jButton.isVisible()) continue;
                jButton.setEnabled(bl);
            }
        }
    }

    private void modifyListener(Object object, ButtonListener buttonListener, boolean bl) {
        if (object instanceof JButton) {
            JButton jButton = (JButton)object;
            if (bl) {
                List<EventListener> list = Arrays.asList(jButton.getActionListeners());
                if (!list.contains(buttonListener)) {
                    jButton.addActionListener(buttonListener);
                }
                if (!(list = Arrays.asList(jButton.getComponentListeners())).contains(buttonListener)) {
                    jButton.addComponentListener(buttonListener);
                }
                if (!(list = Arrays.asList(jButton.getPropertyChangeListeners())).contains(buttonListener)) {
                    jButton.addPropertyChangeListener(buttonListener);
                }
            } else {
                jButton.removeActionListener(buttonListener);
                jButton.removeComponentListener(buttonListener);
                jButton.removePropertyChangeListener(buttonListener);
            }
            return;
        }
        Method method = null;
        try {
            method = object.getClass().getMethod(bl ? "addActionListener" : "removeActionListener", ActionListener.class);
            try {
                method.setAccessible(true);
            }
            catch (SecurityException securityException) {
                method = null;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            method = null;
        }
        catch (SecurityException securityException) {
            method = null;
        }
        if (method != null) {
            try {
                method.invoke(object, buttonListener);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void superShow() {
        assert (SwingUtilities.isEventDispatchThread()) : "Invoked super.show() in AWT event thread.";
        super.show();
    }

    @Override
    @Deprecated
    public void show() {
        if (this.isModal()) {
            Mutex.EVENT.readAccess((Mutex.Action)this);
        } else if (SwingUtilities.isEventDispatchThread()) {
            this.doShow();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    NbPresenter.this.doShow();
                }
            });
        }
    }

    public Void run() {
        this.doShow();
        return null;
    }

    private void doShow() {
        NbPresenter nbPresenter = null;
        if (this.isModal()) {
            nbPresenter = currentModalDialog;
            currentModalDialog = this;
            NbPresenter.fireChangeEvent();
        }
        this.superShow();
        if (currentModalDialog != nbPresenter) {
            currentModalDialog = nbPresenter;
            NbPresenter.fireChangeEvent();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Serializable serializable;
        boolean bl = false;
        if ("options".equals(propertyChangeEvent.getPropertyName())) {
            this.initializeButtons();
            bl = true;
        } else if ("optionType".equals(propertyChangeEvent.getPropertyName())) {
            this.initializeButtons();
            bl = true;
        } else if ("optionsAlign".equals(propertyChangeEvent.getPropertyName())) {
            this.initializeButtons();
            bl = true;
        } else if ("message".equals(propertyChangeEvent.getPropertyName())) {
            this.initializeMessage();
            this.requestFocusForMessage();
            this.updateHelp();
            bl = true;
        } else if ("messageType".equals(propertyChangeEvent.getPropertyName())) {
            this.initializeMessage();
            this.requestFocusForMessage();
            bl = true;
        } else if ("title".equals(propertyChangeEvent.getPropertyName())) {
            this.setTitle(this.descriptor.getTitle());
        } else if ("helpCtx".equals(propertyChangeEvent.getPropertyName())) {
            serializable = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            this.updateHelp();
            this.currentButtonsPanel.revalidate();
            this.currentButtonsPanel.repaint();
            if (serializable != null) {
                ((Component)serializable).requestFocus();
            }
        } else if ("valid".equals(propertyChangeEvent.getPropertyName())) {
            this.updateOKButton((Boolean)propertyChangeEvent.getNewValue());
        }
        if (bl) {
            serializable = this.getSize();
            Dimension dimension = this.getPreferredSize();
            if (dimension.width > ((Dimension)serializable).width || dimension.height > ((Dimension)serializable).height) {
                this.setSize(Math.max(dimension.width, ((Dimension)serializable).width), Math.max(dimension.height, ((Dimension)serializable).height));
            }
            this.validate();
            this.repaint();
        }
    }

    private void updateHelp() {
        HelpCtx helpCtx = this.getHelpCtx();
        if (HelpCtx.DEFAULT_HELP.equals((Object)helpCtx)) {
            Object object = this.descriptor.getMessage();
            if (object instanceof Component) {
                helpCtx = HelpCtx.findHelp((Component)((Component)object));
            }
            if (HelpCtx.DEFAULT_HELP.equals((Object)helpCtx)) {
                helpCtx = null;
            }
        }
        if (!Utilities.compareObjects((Object)this.currentHelp, (Object)helpCtx)) {
            this.currentHelp = helpCtx;
            if (helpCtx != null && helpCtx.getHelpID() != null) {
                HelpCtx.setHelpIDString((JComponent)this.getRootPane(), (String)helpCtx.getHelpID());
            }
            if (this.haveCalledInitializeButtons) {
                this.initializeButtons();
            }
        }
    }

    protected int getOptionsAlign() {
        return -1;
    }

    protected ActionListener getButtonListener() {
        return null;
    }

    protected Object[] getClosingOptions() {
        return null;
    }

    protected HelpCtx getHelpCtx() {
        return null;
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        if (!(this.descriptor instanceof WizardDescriptor)) {
            this.descriptor.setValue(NotifyDescriptor.CLOSED_OPTION);
        }
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    public static void addChangeListener(ChangeListener changeListener) {
        cs.addChangeListener(changeListener);
    }

    public static void removeChangeListener(ChangeListener changeListener) {
        cs.removeChangeListener(changeListener);
    }

    private static void fireChangeEvent() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                cs.fireChange();
            }
        });
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleNbPresenter();
        }
        return this.accessibleContext;
    }

    private static String getMessageTypeDescription(int n) {
        switch (n) {
            case 0: {
                return NbBundle.getBundle(NbPresenter.class).getString("ACSD_ErrorMessage");
            }
            case 2: {
                return NbBundle.getBundle(NbPresenter.class).getString("ACSD_WarningMessage");
            }
            case 3: {
                return NbBundle.getBundle(NbPresenter.class).getString("ACSD_QuestionMessage");
            }
            case 1: {
                return NbBundle.getBundle(NbPresenter.class).getString("ACSD_InformationMessage");
            }
            case -1: {
                return NbBundle.getBundle(NbPresenter.class).getString("ACSD_PlainMessage");
            }
        }
        return "";
    }

    static {
        cs = new ChangeSupport(NbPresenter.class);
        LOG = Logger.getLogger(NbPresenter.class.getName());
        if (Boolean.getBoolean("netbeans.hack.50423")) {
            try {
                markers = DefaultKeyboardFocusManager.class.getDeclaredField("typeAheadMarkers");
                markers.setAccessible(true);
                dequeue = DefaultKeyboardFocusManager.class.getDeclaredMethod("dequeueKeyEvents", Long.TYPE, Component.class);
                dequeue.setAccessible(true);
            }
            catch (Throwable throwable) {
                LOG.log(Level.WARNING, "Not activating workaround for #50423", throwable);
            }
        }
    }

    private class AccessibleNbPresenter
    extends JDialog.AccessibleJDialog {
        AccessibleNbPresenter() {
            super(NbPresenter.this);
        }

        public String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            if (NbPresenter.this.currentMessage instanceof Accessible && NbPresenter.this.currentMessage.getAccessibleContext().getAccessibleName() != null) {
                return NbPresenter.this.currentMessage.getAccessibleContext().getAccessibleName();
            }
            return super.getAccessibleName();
        }

        public String getAccessibleDescription() {
            if (this.accessibleDescription != null) {
                return this.accessibleDescription;
            }
            if (NbPresenter.this.currentMessage instanceof Accessible && NbPresenter.this.currentMessage.getAccessibleContext().getAccessibleDescription() != null) {
                return MessageFormat.format(NbPresenter.getMessageTypeDescription(NbPresenter.this.descriptor.getMessageType()), NbPresenter.this.currentMessage.getAccessibleContext().getAccessibleDescription());
            }
            return super.getAccessibleDescription();
        }
    }

    private class ButtonListener
    implements ActionListener,
    ComponentListener,
    PropertyChangeListener {
        ButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object[] objectArray;
            Object object;
            boolean bl = "Aqua".equals(UIManager.getLookAndFeel().getID()) || "true".equalsIgnoreCase(System.getProperty("xtest.looks_as_mac"));
            Object object2 = actionEvent.getSource();
            if (NbPresenter.ESCAPE_COMMAND.equals(actionEvent.getActionCommand())) {
                object2 = NotifyDescriptor.CLOSED_OPTION;
            } else {
                int n;
                if (actionEvent.getSource() == NbPresenter.this.stdHelpButton) {
                    NbTopManager.get().showHelp(NbPresenter.this.currentHelp);
                    return;
                }
                object = NbPresenter.this.descriptor.getOptions();
                if (bl && object != null) {
                    Arrays.sort(object, NbPresenter.this);
                }
                if (object != null && NbPresenter.this.currentPrimaryButtons != null && ((Object)object).length == NbPresenter.this.currentPrimaryButtons.length - (NbPresenter.this.currentHelp != null ? 1 : 0)) {
                    n = NbPresenter.this.currentHelp != null && bl ? -1 : 0;
                    for (int i = 0; i < NbPresenter.this.currentPrimaryButtons.length; ++i) {
                        if (actionEvent.getSource() != NbPresenter.this.currentPrimaryButtons[i]) continue;
                        object2 = object[i + n];
                    }
                }
                object = NbPresenter.this.descriptor.getAdditionalOptions();
                if (bl && object != null) {
                    Arrays.sort(object, NbPresenter.this);
                }
                if (object != null && NbPresenter.this.currentSecondaryButtons != null && ((Object)object).length == NbPresenter.this.currentSecondaryButtons.length) {
                    for (n = 0; n < NbPresenter.this.currentSecondaryButtons.length; ++n) {
                        if (actionEvent.getSource() != NbPresenter.this.currentSecondaryButtons[n]) continue;
                        object2 = object[n];
                    }
                }
                if (actionEvent.getSource() == NbPresenter.this.stdYesButton) {
                    object2 = NotifyDescriptor.YES_OPTION;
                } else if (actionEvent.getSource() == NbPresenter.this.stdNoButton) {
                    object2 = NotifyDescriptor.NO_OPTION;
                } else if (actionEvent.getSource() == NbPresenter.this.stdCancelButton) {
                    object2 = NotifyDescriptor.CANCEL_OPTION;
                } else if (actionEvent.getSource() == NbPresenter.this.stdClosedButton) {
                    object2 = NotifyDescriptor.CLOSED_OPTION;
                } else if (actionEvent.getSource() == NbPresenter.this.stdOKButton) {
                    object2 = NotifyDescriptor.OK_OPTION;
                }
            }
            NbPresenter.this.descriptor.setValue(object2);
            object = NbPresenter.this.getButtonListener();
            if (object != null) {
                if (object2 == actionEvent.getSource()) {
                    object.actionPerformed(actionEvent);
                } else {
                    object.actionPerformed(new ActionEvent(object2, actionEvent.getID(), actionEvent.getActionCommand(), actionEvent.getModifiers()));
                }
            }
            if ((objectArray = NbPresenter.this.getClosingOptions()) == null || object2 == NotifyDescriptor.CLOSED_OPTION) {
                NbPresenter.this.dispose();
            } else {
                List<Object> list = Arrays.asList(objectArray);
                if (list.contains(object2)) {
                    NbPresenter.this.dispose();
                }
            }
        }

        public void componentShown(ComponentEvent componentEvent) {
            NbPresenter.this.updateDefaultButton();
        }

        public void componentResized(ComponentEvent componentEvent) {
        }

        public void componentHidden(ComponentEvent componentEvent) {
            NbPresenter.this.updateDefaultButton();
        }

        public void componentMoved(ComponentEvent componentEvent) {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("enabled".equals(propertyChangeEvent.getPropertyName())) {
                NbPresenter.this.updateDefaultButton();
            }
        }
    }

    private final class HackTypeAhead
    implements Runnable {
        private RequestProcessor.Task task = RequestProcessor.getDefault().create((Runnable)this);

        public void activate() {
            if (markers != null) {
                this.task.schedule(1000);
            }
        }

        public void run() {
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(this);
                return;
            }
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            Collection collection = null;
            try {
                collection = (Collection)markers.get(keyboardFocusManager);
            }
            catch (Exception exception) {
                Logger.getLogger(NbPresenter.class.getName()).log(Level.WARNING, null, exception);
            }
            if (collection == null || collection.isEmpty()) {
                return;
            }
            LOG.warning("Symptoms of #50423: There is something in type ahead: " + collection + " requesting focus change");
            try {
                dequeue.invoke((Object)keyboardFocusManager, -1L, NbPresenter.this);
            }
            catch (Exception exception) {
                Logger.getLogger(NbPresenter.class.getName()).log(Level.WARNING, null, exception);
            }
        }
    }
}

