/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.io.CharConversionException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.core.output2.FindDialogPanel;
import org.netbeans.core.output2.IOEvent;
import org.netbeans.core.output2.NbIO;
import org.netbeans.core.output2.NbWriter;
import org.netbeans.core.output2.OutWriter;
import org.netbeans.core.output2.OutputPane;
import org.netbeans.core.output2.OutputTab;
import org.netbeans.core.output2.OutputWindow;
import org.netbeans.core.output2.ui.AbstractOutputTab;
import org.openide.actions.FindAction;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.WindowManager;
import org.openide.xml.XMLUtil;

public class Controller {
    private static final int ACTION_COPY = 0;
    private static final int ACTION_WRAP = 1;
    private static final int ACTION_SAVEAS = 2;
    private static final int ACTION_CLOSE = 3;
    private static final int ACTION_NEXTERROR = 4;
    private static final int ACTION_PREVERROR = 5;
    private static final int ACTION_SELECTALL = 6;
    private static final int ACTION_FIND = 7;
    private static final int ACTION_FINDNEXT = 8;
    private static final int ACTION_NAVTOLINE = 9;
    private static final int ACTION_POSTMENU = 10;
    private static final int ACTION_FINDPREVIOUS = 11;
    private static final int ACTION_CLEAR = 12;
    private static final int ACTION_NEXTTAB = 13;
    private static final int ACTION_PREVTAB = 14;
    Action copyAction = new ControllerAction(0, "ACTION_COPY");
    Action wrapAction = new ControllerAction(1, "ACTION_WRAP");
    Action saveAsAction = new ControllerAction(2, "ACTION_SAVEAS");
    Action closeAction = new ControllerAction(3, "ACTION_CLOSE");
    Action nextErrorAction = new ControllerAction(4, "ACTION_NEXT_ERROR");
    Action prevErrorAction = new ControllerAction(5, "ACTION_PREV_ERROR");
    Action selectAllAction = new ControllerAction(6, "ACTION_SELECT_ALL");
    Action findAction = new ControllerAction(7, "ACTION_FIND");
    Action findNextAction = new ControllerAction(8, "ACTION_FIND_NEXT");
    Action findPreviousAction = new ControllerAction(11, "ACTION_FIND_PREVIOUS");
    Action navToLineAction = new ControllerAction(9, "navToLine", KeyStroke.getKeyStroke(10, 0));
    Action postMenuAction = new ControllerAction(10, "postMenu", KeyStroke.getKeyStroke(121, 64));
    Action clearAction = new ControllerAction(12, "ACTION_CLEAR");
    Action nextTabAction = new ControllerAction(13, "NextViewAction", null);
    Action prevTabAction = new ControllerAction(14, "PreviousViewAction", null);
    private Object[] popupItems = new Object[]{this.copyAction, new JSeparator(), this.findAction, this.findNextAction, new JSeparator(), this.wrapAction, new JSeparator(), this.saveAsAction, this.clearAction, this.closeAction};
    private Action[] kbdActions = new Action[]{this.copyAction, this.selectAllAction, this.findAction, this.findNextAction, this.findPreviousAction, this.wrapAction, this.saveAsAction, this.closeAction, this.navToLineAction, this.postMenuAction, this.clearAction};
    private CoalescedNameUpdater nameUpdater = null;
    private static String lastDir = null;
    private boolean firstF12 = true;
    boolean ignoreCaretChanges = false;
    public static final boolean LOG = Boolean.getBoolean("nb.output.log") || Boolean.getBoolean("nb.output.log.verbose");
    public static final boolean VERBOSE = Boolean.getBoolean("nb.output.log.verbose");
    static final boolean logStdOut = Boolean.getBoolean("nb.output.log.stdout");
    private static OutputStream logStream = null;

    public static void ensureViewInDefault(final NbIO nbIO, final boolean bl) {
        Mutex.EVENT.readAccess(new Runnable(){

            public void run() {
                OutputWindow.findDefault();
                IOEvent iOEvent = new IOEvent(nbIO, 0, bl);
                NbIO.post(iOEvent);
            }
        });
    }

    Controller() {
    }

    private OutputTab createOutputTab(OutputWindow outputWindow, NbIO nbIO, boolean bl, boolean bl2) {
        AbstractOutputTab[] abstractOutputTabArray = outputWindow.getTabs();
        JComponent jComponent = null;
        if (LOG) {
            Controller.log("Find or create component for nbio " + nbIO);
        }
        for (int i = 0; i < abstractOutputTabArray.length; ++i) {
            OutputTab outputTab = (OutputTab)abstractOutputTabArray[i];
            if (outputTab.getIO() != nbIO) continue;
            if (LOG) {
                Controller.log("Found an existing tab");
            }
            jComponent = outputTab;
            break;
        }
        if (jComponent == null) {
            if (LOG) {
                Controller.log("Didn't find an existing open tab, checking hidden tabs");
            }
            OutputTab[] outputTabArray = outputWindow.getHiddenTabs();
            for (int i = 0; i < outputTabArray.length; ++i) {
                OutputTab outputTab = outputTabArray[i];
                if (outputTabArray[i].getIO() != nbIO) continue;
                if (LOG) {
                    Controller.log("Found a hidden tab with the same IO.  Unhiding it for reuse");
                }
                jComponent = outputTab;
                this.unhideHiddenView(outputWindow, (OutputTab)jComponent);
                break;
            }
        }
        if (LOG) {
            Controller.log("FindOrCreate: " + nbIO.getName() + " found=" + (jComponent != null) + " for io " + nbIO);
        }
        if (jComponent == null) {
            if (LOG) {
                Controller.log("Find or create creating " + nbIO.getName());
            }
            jComponent = this.createAndInstallView(outputWindow, nbIO);
        }
        if (jComponent != null) {
            jComponent.getActionMap().put("jumpPrev", this.prevErrorAction);
            jComponent.getActionMap().put("jumpNext", this.nextErrorAction);
            jComponent.getActionMap().put(FindAction.class.getName(), this.findAction);
            jComponent.getActionMap().put("copy-to-clipboard", this.copyAction);
        }
        if (jComponent != null) {
            outputWindow.setSelectedTab((AbstractOutputTab)jComponent);
        }
        return jComponent;
    }

    private OutputTab createAndInstallView(OutputWindow outputWindow, NbIO nbIO) {
        if (LOG) {
            Controller.log("Create and install a new tab for : " + nbIO.getName());
        }
        OutputTab outputTab = new OutputTab(nbIO);
        outputTab.setName(nbIO.getName() + " ");
        Action[] actionArray = nbIO.getToolbarActions();
        if (actionArray != null) {
            outputTab.setToolbarActions(actionArray);
        }
        for (int i = 0; i < this.kbdActions.length; ++i) {
            outputTab.installKeyboardAction(this.kbdActions[i]);
        }
        if (LOG) {
            Controller.log("Adding and selecting new tab " + outputTab);
        }
        outputWindow.add(outputTab);
        outputWindow.setSelectedTab(outputTab);
        AbstractOutputTab[] abstractOutputTabArray = outputWindow.getTabs();
        for (int i = 0; i < abstractOutputTabArray.length; ++i) {
            this.updateName(outputWindow, (OutputTab)abstractOutputTabArray[i]);
        }
        return outputTab;
    }

    private void unhideHiddenView(OutputWindow outputWindow, OutputTab outputTab) {
        if (LOG) {
            Controller.log("Unhiding hidden tab for " + outputTab.getIO());
        }
        outputWindow.add(outputTab);
        outputWindow.removeHiddenView(outputTab);
    }

    private void updateName(OutputWindow outputWindow, OutputTab outputTab) {
        if (this.nameUpdater == null) {
            if (LOG) {
                Controller.log("Update name for " + outputTab.getIO() + " dispatching a name updater");
            }
            this.nameUpdater = new CoalescedNameUpdater(outputWindow);
            SwingUtilities.invokeLater(this.nameUpdater);
        }
        this.nameUpdater.add(outputTab);
    }

    private void forceName(OutputWindow outputWindow, OutputTab outputTab) {
        if (LOG) {
            Controller.log("ForceName ensuring non-html tab name");
        }
        if (this.nameUpdater != null) {
            if (LOG) {
                Controller.log("  an update was queued, aborting it");
            }
            this.nameUpdater.remove(outputTab);
        }
        if (outputWindow.isAncestorOf(outputTab)) {
            String string;
            try {
                string = XMLUtil.toAttributeValue((String)(outputTab.getIO().getName() + " "));
            }
            catch (CharConversionException charConversionException) {
                string = outputTab.getIO().getName() + " ";
            }
            if (LOG) {
                Controller.log("  setting non-html name " + string);
            }
            outputWindow.setTabTitle(outputTab, string.replace("&apos;", "'"));
        }
    }

    public void actionPerformed(OutputWindow outputWindow, OutputTab outputTab, int n) {
        switch (n) {
            case 0: {
                outputTab.getOutputPane().copy();
                break;
            }
            case 1: {
                boolean bl = outputTab.getOutputPane().isWrapped();
                outputTab.getOutputPane().setWrapped(!bl);
                break;
            }
            case 2: {
                this.saveAs(outputTab);
                break;
            }
            case 3: {
                this.close(outputWindow, outputTab, false);
                break;
            }
            case 4: {
                this.sendCaretToError(outputWindow, outputTab, false);
                break;
            }
            case 5: {
                this.sendCaretToError(outputWindow, outputTab, true);
                break;
            }
            case 6: {
                outputTab.getOutputPane().selectAll();
                break;
            }
            case 7: {
                int n2 = outputTab.getOutputPane().getSelectionStart();
                int n3 = outputTab.getOutputPane().getSelectionEnd();
                String string = null;
                if (n2 > 0 && n3 > n2) {
                    try {
                        string = outputTab.getOutputPane().getDocument().getText(n2, n3 - n2);
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                    }
                }
                FindDialogPanel.showFindDialog(outputTab.getFindActionListener(this.findNextAction, this.findPreviousAction, this.copyAction), string);
                break;
            }
            case 8: {
                this.findNext(outputTab);
                break;
            }
            case 11: {
                this.findPrevious(outputTab);
                break;
            }
            case 9: {
                if (LOG) {
                    Controller.log("Action NAVTOLINE received");
                }
                this.openLineIfError(outputTab);
                break;
            }
            case 10: {
                if (LOG) {
                    Controller.log("Action POSTMENU received");
                }
                this.postPopupMenu(outputWindow, outputTab, new Point(0, 0), outputTab);
                break;
            }
            case 12: {
                NbIO nbIO;
                if (LOG) {
                    Controller.log("Action CLEAR receieved");
                }
                if ((nbIO = outputTab.getIO()) != null) {
                    NbWriter nbWriter = nbIO.writer();
                    if (nbWriter != null) {
                        try {
                            if (LOG) {
                                Controller.log("Resetting the writer for Clear");
                            }
                            nbWriter.reset();
                            this.forceName(outputWindow, outputTab);
                        }
                        catch (IOException iOException) {
                            Exceptions.printStackTrace((Throwable)iOException);
                        }
                        break;
                    }
                    if (!LOG) break;
                    Controller.log("IO's NbWriter is null");
                    break;
                }
                if (!LOG) break;
                Controller.log("Clear on a tab with no IO");
                break;
            }
            case 13: {
                if (LOG) {
                    Controller.log("Action NEXTTAB received");
                }
                outputWindow.selectNextTab(outputTab);
                break;
            }
            case 14: {
                if (LOG) {
                    Controller.log("Action PREVTAB received");
                }
                outputWindow.selectPreviousTab(outputTab);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    private void openLineIfError(OutputTab outputTab) {
        OutWriter outWriter = outputTab.getIO().out();
        if (outWriter != null) {
            int n = outputTab.getOutputPane().getCaretLine();
            OutputListener outputListener = outWriter.getLines().getListenerForLine(n);
            if (outputListener != null) {
                if (LOG) {
                    Controller.log(" Sending action for getLine " + n);
                }
                this.ignoreCaretChanges = true;
                outputTab.getOutputPane().sendCaretToLine(n, true);
                this.ignoreCaretChanges = false;
                ControllerOutputEvent controllerOutputEvent = new ControllerOutputEvent(outputTab.getIO(), n);
                outputListener.outputLineAction((OutputEvent)controllerOutputEvent);
            }
        }
    }

    private void findNext(OutputTab outputTab) {
        OutWriter outWriter = outputTab.getIO().out();
        if (outWriter != null) {
            String string = FindDialogPanel.getPanel().getPattern();
            if (string != null) {
                outWriter.getLines().find(string);
            }
            Matcher matcher = outWriter.getLines().getForwardMatcher();
            int n = outputTab.getOutputPane().getCaretPos();
            if (n >= outputTab.getOutputPane().getLength() || n < 0) {
                n = 0;
            }
            if (matcher != null && matcher.find(n)) {
                outputTab.getOutputPane().setSelection(matcher.start(), matcher.end());
                this.copyAction.setEnabled(true);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    private void findPrevious(OutputTab outputTab) {
        OutWriter outWriter = outputTab.getIO().out();
        if (outWriter != null) {
            String string = FindDialogPanel.getPanel().getPattern();
            if (string != null) {
                outWriter.getLines().find(string);
            }
            Matcher matcher = outWriter.getLines().getReverseMatcher();
            int n = outputTab.getOutputPane().getLength();
            int n2 = n - outputTab.getOutputPane().getSelectionStart();
            if (n2 >= outputTab.getOutputPane().getLength() - 1 || n2 < 0) {
                n2 = 0;
            }
            if (LOG) {
                Controller.log("Reverse search from " + n2);
            }
            if (matcher != null && matcher.find(n2)) {
                int n3 = n - matcher.end();
                int n4 = n - matcher.start();
                outputTab.getOutputPane().setSelection(n3, n4);
                this.copyAction.setEnabled(true);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    private void updateActions(OutputWindow outputWindow, OutputTab outputTab) {
        if (outputTab == outputWindow.getSelectedTab()) {
            OutputPane outputPane = (OutputPane)outputTab.getOutputPane();
            int n = outputPane.getLength();
            boolean bl = n > 0;
            this.findAction.setEnabled(bl);
            OutWriter outWriter = outputTab.getIO().out();
            this.saveAsAction.setEnabled(bl);
            this.selectAllAction.setEnabled(bl);
            this.copyAction.setEnabled(outputPane.hasSelection());
            boolean bl2 = outWriter == null ? false : outWriter.getLines().firstListenerLine() != -1;
            this.nextErrorAction.setEnabled(bl2);
            this.prevErrorAction.setEnabled(bl2);
        }
    }

    public void close(OutputWindow outputWindow, OutputTab outputTab, boolean bl) {
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
        boolean bl2 = component != null && (component == outputWindow || outputWindow.isAncestorOf(component));
        outputWindow.remove(outputTab);
        boolean bl3 = false;
        if (!bl && outputWindow.getTabs().length == 0) {
            if (LOG) {
                Controller.log("Last tab closed by user, closing output window.");
            }
            outputWindow.close();
            bl3 = true;
        }
        if (bl2 && !bl3 && outputWindow.getSelectedTab() != null) {
            if (LOG) {
                Controller.log("Trying to send focus to the newly selected tab");
            }
            outputWindow.getSelectedTab().requestFocus();
        }
        if (LOG) {
            Controller.log("Close received, removing " + outputTab + " from component");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveAs(OutputTab outputTab) {
        OutWriter outWriter = outputTab.getIO().out();
        if (outWriter == null) {
            return;
        }
        File file = Controller.showFileChooser(outputTab);
        if (file != null) {
            try {
                OutWriter outWriter2 = outWriter;
                synchronized (outWriter2) {
                    outWriter.getLines().saveAs(file.getPath());
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    private static File showFileChooser(JComponent jComponent) {
        Object object;
        Object object2;
        File file = null;
        String string = NbBundle.getMessage(Controller.class, (String)"TITLE_SAVE_DLG");
        boolean bl = "Aqua".equals(UIManager.getLookAndFeel().getID());
        if (bl) {
            object2 = new FileDialog((Frame)jComponent.getTopLevelAncestor(), string, 1);
            if (lastDir != null && new File(lastDir).exists()) {
                ((FileDialog)object2).setDirectory(lastDir);
            }
            ((Dialog)object2).setModal(true);
            ((Dialog)object2).setVisible(true);
            object = ((FileDialog)object2).getDirectory() + ((FileDialog)object2).getFile();
            file = new File((String)object);
            if (file.exists() && file.isDirectory()) {
                file = null;
            }
        } else {
            object2 = new JFileChooser();
            if (lastDir != null && new File(lastDir).exists() && ((File)(object = new File(lastDir))).exists()) {
                ((JFileChooser)object2).setCurrentDirectory((File)object);
            }
            ((Component)object2).setName(string);
            ((JFileChooser)object2).setDialogTitle(string);
            if (((JFileChooser)object2).showSaveDialog(jComponent.getTopLevelAncestor()) == 0) {
                file = ((JFileChooser)object2).getSelectedFile();
            }
        }
        if (file != null && file.exists() && !bl) {
            object2 = NbBundle.getMessage(Controller.class, (String)"FMT_FILE_EXISTS", (Object[])new Object[]{file.getName()});
            object = NbBundle.getMessage(Controller.class, (String)"TITLE_FILE_EXISTS");
            if (JOptionPane.showConfirmDialog(jComponent.getTopLevelAncestor(), object2, (String)object, 2) != 0) {
                file = null;
            }
        }
        if (file != null) {
            lastDir = file.getParent();
        }
        return file;
    }

    public void selectionChanged(OutputWindow outputWindow, OutputTab outputTab, OutputTab outputTab2) {
        if (outputTab != null) {
            outputTab.updateTimestamp();
        }
        if (outputTab2 != null) {
            outputTab2.updateTimestamp();
            this.updateActions(outputWindow, outputTab2);
        }
    }

    public void notifyActivated(OutputWindow outputWindow) {
        OutputTab outputTab = (OutputTab)outputWindow.getSelectedTab();
        if (outputTab != null) {
            this.updateActions(outputWindow, outputTab);
        }
    }

    private void sendCaretToError(OutputWindow outputWindow, OutputTab outputTab, boolean bl) {
        if (outputTab == null && (outputTab = (OutputTab)outputWindow.getSelectedTab()) == null) {
            return;
        }
        OutWriter outWriter = outputTab.getIO().out();
        if (outWriter != null) {
            int n;
            int n2 = n = this.firstF12 ? 0 : Math.max(0, outputTab.getOutputPane().getCaretLine());
            if (n >= outputTab.getOutputPane().getLineCount() - 1) {
                n = 0;
            }
            int n3 = outWriter.getLines().nearestListenerLine(n, bl);
            if (LOG) {
                Controller.log("sendCaretToError - caret line: " + n + " nearest listener line " + n3);
            }
            if (n3 == n) {
                if (!bl && n != outputTab.getOutputPane().getLineCount()) {
                    n3 = outWriter.getLines().nearestListenerLine(n + 1, bl);
                } else if (bl && n > 0) {
                    n3 = outWriter.getLines().nearestListenerLine(n - 1, bl);
                } else {
                    return;
                }
            }
            if (n3 != -1) {
                if (LOG) {
                    Controller.log("Sending caret to error line " + n3);
                }
                outputTab.getOutputPane().sendCaretToLine(n3, true);
                if (!outputWindow.isActivated()) {
                    OutputListener outputListener = outWriter.getLines().getListenerForLine(n3);
                    ControllerOutputEvent controllerOutputEvent = new ControllerOutputEvent(outputTab.getIO(), n3);
                    outputListener.outputLineAction((OutputEvent)controllerOutputEvent);
                }
            }
            this.firstF12 = false;
        }
    }

    public void notifyRemoved(OutputTab outputTab) {
        NbWriter nbWriter;
        NbIO nbIO;
        assert (SwingUtilities.isEventDispatchThread());
        if (LOG) {
            Controller.log("Tab " + outputTab + " has been CLOSED.  Disposing its IO.");
        }
        if ((nbIO = outputTab.getIO()) != null) {
            nbIO.setClosed(true);
        }
        if ((nbWriter = nbIO.writer()) != null && nbWriter.isClosed()) {
            outputTab.setDocument(null);
        } else if (nbWriter != null) {
            outputTab.getDocument().disposeQuietly();
        }
    }

    public void notifyInput(OutputWindow outputWindow, OutputTab outputTab, String string) {
        NbIO.IOReader iOReader;
        NbIO nbIO;
        if (LOG) {
            Controller.log("Notify input on " + outputTab + " - " + string);
        }
        if ((nbIO = outputTab.getIO()) != null && (iOReader = nbIO.in()) != null) {
            if (LOG) {
                Controller.log("Sending input to " + iOReader);
            }
            iOReader.pushText(string + "\n");
            nbIO.getOut().println(string);
        }
    }

    private OutputListener listenerForLine(OutputTab outputTab, int n) {
        OutWriter outWriter = outputTab.getIO().out();
        if (outWriter != null) {
            return outWriter.getLines().getListenerForLine(n);
        }
        return null;
    }

    public void lineClicked(OutputWindow outputWindow, OutputTab outputTab, int n) {
        OutputListener outputListener = this.listenerForLine(outputTab, n);
        if (outputListener != null) {
            ControllerOutputEvent controllerOutputEvent = new ControllerOutputEvent(outputTab.getIO(), n);
            outputListener.outputLineAction((OutputEvent)controllerOutputEvent);
            outputTab.getOutputPane().sendCaretToLine(n, true);
        }
    }

    public void postPopupMenu(OutputWindow outputWindow, OutputTab outputTab, Point point, Component component) {
        int n;
        if (LOG) {
            Controller.log("post popup menu for " + outputTab.getName());
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.putClientProperty("container", outputWindow);
        jPopupMenu.putClientProperty("component", outputTab);
        Action[] actionArray = outputTab.getToolbarActions();
        if (actionArray.length > 0) {
            n = 0;
            for (int i = 0; i < actionArray.length; ++i) {
                if (actionArray[i].getValue("Name") == null) continue;
                jPopupMenu.add(new ProxyAction(actionArray[i]));
                n = 1;
            }
            if (n != 0) {
                jPopupMenu.add(new JSeparator());
            }
        }
        for (n = 0; n < this.popupItems.length; ++n) {
            if (this.popupItems[n] instanceof JSeparator) {
                jPopupMenu.add((JSeparator)this.popupItems[n]);
                continue;
            }
            if (this.popupItems[n] != this.wrapAction) {
                jPopupMenu.add((Action)this.popupItems[n]);
                continue;
            }
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem((Action)this.popupItems[n]);
            jCheckBoxMenuItem.setSelected(outputTab.getOutputPane().isWrapped());
            jPopupMenu.add(jCheckBoxMenuItem);
        }
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        JTextComponent jTextComponent = outputTab.getOutputPane().getTextView();
        Object object = jTextComponent.getInputMap().get(keyStroke);
        jTextComponent.getInputMap().remove(keyStroke);
        outputTab.getInputMap(1).remove(keyStroke);
        jPopupMenu.addPopupMenuListener(new PMListener(this.popupItems, object));
        jPopupMenu.show(component, point.x, point.y);
    }

    public void caretEnteredLine(OutputTab outputTab, int n) {
        if (!this.ignoreCaretChanges) {
            OutputListener outputListener = this.listenerForLine(outputTab, n);
            if (LOG) {
                Controller.log("Caret entered line " + n + " notifying listener " + outputListener);
            }
            if (outputListener != null) {
                ControllerOutputEvent controllerOutputEvent = new ControllerOutputEvent(outputTab.getIO(), n);
                outputListener.outputLineSelected((OutputEvent)controllerOutputEvent);
            }
        } else if (LOG) {
            Controller.log("Caret entered line " + n + " which has no listener");
        }
    }

    public void documentChanged(OutputWindow outputWindow, OutputTab outputTab) {
        if (outputTab.getIO().isFocusTaken()) {
            outputWindow.setSelectedTab(outputTab);
            outputWindow.requestVisible();
        }
        this.updateName(outputWindow, outputTab);
        if (outputTab == outputWindow.getSelectedTab() && outputWindow.isActivated()) {
            this.updateActions(outputWindow, outputTab);
        }
    }

    public void performCommand(OutputWindow outputWindow, OutputTab outputTab, NbIO nbIO, int n, boolean bl, Object object) {
        if (LOG) {
            Controller.log("PERFORMING: " + IOEvent.cmdToString(n) + " value=" + bl + " on " + nbIO + " tob " + outputTab);
        }
        OutWriter outWriter = nbIO.out();
        switch (n) {
            case 0: {
                this.createOutputTab(outputWindow, nbIO, nbIO.isFocusTaken(), bl);
                break;
            }
            case 2: {
                if (bl && outputTab == null) {
                    outputTab = this.createOutputTab(outputWindow, nbIO, nbIO.isFocusTaken(), bl);
                }
                if (outputTab == null) break;
                outputTab.setInputVisible(bl);
                outputWindow.setSelectedTab(outputTab);
                break;
            }
            case 6: {
                if (outputTab == null) {
                    outputTab = this.createOutputTab(outputWindow, nbIO, nbIO.isFocusTaken(), bl);
                }
                if (!outputWindow.isOpened()) {
                    outputWindow.open();
                }
                if (!nbIO.isFocusTaken()) {
                    outputWindow.requestVisibleForNewTab();
                } else {
                    outputWindow.requestActiveForNewTab();
                }
                if (outputWindow.getSelectedTab() == outputTab) break;
                if (outputTab.getParent() == null) {
                    outputWindow.add(outputTab);
                }
                outputWindow.setSelectedTab(outputTab);
                this.updateName(outputWindow, outputTab);
                break;
            }
            case 10: {
                if (outputTab == null && object != null) {
                    outputTab = this.createOutputTab(outputWindow, nbIO, nbIO.isFocusTaken(), bl);
                }
                Action[] actionArray = (Action[])object;
                outputTab.setToolbarActions(actionArray);
                break;
            }
            case 7: {
                if (outputTab != null) {
                    this.close(outputWindow, outputTab, true);
                    outputWindow.revalidate();
                    outputWindow.repaint();
                    break;
                }
                nbIO.dispose();
                break;
            }
            case 8: {
                if (bl) {
                    if (outputTab == null) {
                        if (nbIO.out() == null) break;
                        nbIO.out().dispose();
                        break;
                    }
                    if (outputTab.getParent() != null) {
                        this.updateName(outputWindow, outputTab);
                        if (outputTab.getIO().out() != null && outputTab.getIO().out().getLines().firstListenerLine() == -1) {
                            outputTab.getOutputPane().ensureCaretPosition();
                        }
                        if (outputTab != outputWindow.getSelectedTab()) break;
                        this.updateActions(outputWindow, outputTab);
                        break;
                    }
                    outputWindow.removeHiddenView(outputTab);
                    if (nbIO.out() == null) break;
                    nbIO.out().dispose();
                    break;
                }
                if (outputTab == null || outputTab.getParent() == null) break;
                this.updateName(outputWindow, outputTab);
                break;
            }
            case 9: {
                this.firstF12 = true;
                if (outputTab == null) {
                    if (LOG) {
                        Controller.log("Got a reset on an io with no tab.  Creating a tab.");
                    }
                    this.performCommand(outputWindow, null, nbIO, 0, bl, object);
                    outputWindow.requestVisible();
                    return;
                }
                if (LOG) {
                    Controller.log("Setting io " + nbIO + " on tab " + outputTab);
                }
                outputTab.setIO(nbIO);
                outputWindow.setSelectedTab(outputTab);
                this.updateName(outputWindow, outputTab);
                if (!LOG) break;
                Controller.log("Reset on " + outputTab + " tab displayable " + outputTab.isDisplayable() + " io " + nbIO + " io.out " + nbIO.out());
                break;
            }
            case 12: {
                outputWindow.setTabIcon(outputTab, nbIO.getIcon());
            }
        }
    }

    private void navigateToFirstErrorLine(OutputTab outputTab) {
        OutWriter outWriter = outputTab.getIO().out();
        if (outWriter != null) {
            int n = outputTab.getFirstNavigableListenerLine();
            if (LOG) {
                Controller.log("NAV TO FIRST LISTENER LINE: " + n);
            }
            if (n > 0) {
                outputTab.getOutputPane().sendCaretToLine(n, false);
                if (Controller.isSDI(outputTab)) {
                    outputTab.requestActive();
                }
            }
        }
    }

    private static boolean isSDI(OutputTab outputTab) {
        Container container = outputTab.getTopLevelAncestor();
        return container != WindowManager.getDefault().getMainWindow();
    }

    void hasSelectionChanged(OutputWindow outputWindow, OutputTab outputTab, boolean bl) {
        if (outputTab == outputWindow.getSelectedTab()) {
            this.copyAction.setEnabled(bl);
            this.selectAllAction.setEnabled(!outputTab.getOutputPane().isAllSelected());
        }
    }

    void hasOutputListenersChanged(OutputWindow outputWindow, OutputTab outputTab, boolean bl) {
        if (bl && outputWindow.getSelectedTab() == outputTab && outputTab.isShowing()) {
            this.navigateToFirstErrorLine(outputTab);
        }
    }

    public static void log(String string) {
        string = Long.toString(System.currentTimeMillis()) + ":" + string + "(" + Thread.currentThread() + ")  ";
        if (logStdOut) {
            System.out.println(string);
            return;
        }
        OutputStream outputStream = Controller.getLogStream();
        byte[] byArray = new byte[string.length() + 1];
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            byArray[i] = (byte)cArray[i];
        }
        byArray[byArray.length - 1] = 10;
        try {
            outputStream.write(byArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(string);
        }
        try {
            outputStream.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void logStack() {
        if (logStdOut) {
            new Exception().printStackTrace();
            return;
        }
        Exception exception = new Exception();
        exception.fillInStackTrace();
        StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
        for (int i = 1; i < Math.min(22, stackTraceElementArray.length); ++i) {
            Controller.log("   *   " + stackTraceElementArray[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static OutputStream getLogStream() {
        if (logStream != null) return logStream;
        String string = System.getProperty("java.io.tmpdir") + File.separator + "outlog.txt";
        Class<Controller> clazz = Controller.class;
        synchronized (Controller.class) {
            try {
                File file = new File(string);
                if (file.exists()) {
                    file.delete();
                }
                file.createNewFile();
                logStream = new FileOutputStream(file);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                logStream = System.err;
            }
            return logStream;
        }
    }

    void inputEof(OutputTab outputTab) {
        NbIO nbIO;
        NbIO.IOReader iOReader;
        if (LOG) {
            Controller.log("Input EOF");
        }
        if ((iOReader = (nbIO = outputTab.getIO()).in()) != null) {
            iOReader.eof();
        }
    }

    private class CoalescedNameUpdater
    implements Runnable {
        private Set<OutputTab> components = new HashSet<OutputTab>();
        private OutputWindow win;

        CoalescedNameUpdater(OutputWindow outputWindow) {
            this.win = outputWindow;
        }

        public void add(OutputTab outputTab) {
            this.components.add(outputTab);
        }

        public void remove(OutputTab outputTab) {
            this.components.remove(outputTab);
        }

        public void run() {
            for (OutputTab outputTab : this.components) {
                String string;
                String string2;
                NbIO nbIO = outputTab.getIO();
                if (LOG) {
                    Controller.log("Update name for " + nbIO.getName() + " stream " + "closed is " + nbIO.isStreamClosed());
                }
                if (!this.win.isAncestorOf(outputTab)) continue;
                try {
                    string2 = XMLUtil.toAttributeValue((String)nbIO.getName());
                }
                catch (CharConversionException charConversionException) {
                    string2 = nbIO.getName();
                }
                boolean bl = nbIO.checkReset();
                boolean bl2 = nbIO.isStreamClosed() && !bl;
                String string3 = string = bl2 ? nbIO.getName() + " " : "<html><b>" + string2 + " </b>&nbsp;</html>";
                if (LOG) {
                    Controller.log("  set name to " + string);
                }
                this.win.setTabTitle(outputTab, string.replace("&apos;", "'"));
            }
            Controller.this.nameUpdater = null;
        }
    }

    private static class ControllerAction
    extends AbstractAction {
        private int id;

        ControllerAction(int n, String string) {
            if (string != null) {
                String string2 = NbBundle.getMessage(Controller.class, (String)string);
                KeyStroke keyStroke = ControllerAction.getAcceleratorFor(string);
                this.id = n;
                this.putValue("Name", string2);
                this.putValue("AcceleratorKey", keyStroke);
            }
        }

        ControllerAction(int n, String string, KeyStroke keyStroke) {
            this.id = n;
            this.putValue("Name", string);
            this.putValue("AcceleratorKey", keyStroke);
        }

        void clearListeners() {
            PropertyChangeListener[] propertyChangeListenerArray = this.changeSupport.getPropertyChangeListeners();
            for (int i = 0; i < propertyChangeListenerArray.length; ++i) {
                this.removePropertyChangeListener(propertyChangeListenerArray[i]);
            }
        }

        private static KeyStroke getAcceleratorFor(String string) {
            String string2 = string + ".accel";
            if (Utilities.isMac()) {
                string2 = string2 + ".mac";
            }
            return Utilities.stringToKey((String)NbBundle.getMessage(Controller.class, (String)string2));
        }

        public int getID() {
            return this.id;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            OutputWindow outputWindow;
            Component component;
            if (LOG) {
                Controller.log("ACTION PERFORMED: " + this.getValue("Name"));
            }
            OutputTab outputTab = (component = (Component)actionEvent.getSource()) instanceof OutputTab ? (OutputTab)component : (component instanceof OutputWindow ? null : (OutputTab)SwingUtilities.getAncestorOfClass(OutputTab.class, component));
            OutputWindow outputWindow2 = outputWindow = component instanceof OutputWindow ? (OutputWindow)((Object)component) : (OutputWindow)((Object)SwingUtilities.getAncestorOfClass(OutputWindow.class, outputTab));
            if (outputWindow == null) {
                outputWindow = OutputWindow.findDefault();
            }
            if (outputTab == null && outputWindow != null) {
                outputTab = (OutputTab)outputWindow.getSelectedTab();
            }
            if (outputWindow == null && outputTab == null && (object = (JPopupMenu)SwingUtilities.getAncestorOfClass(JPopupMenu.class, component)) != null) {
                outputWindow = (OutputWindow)((JComponent)object).getClientProperty("win");
                outputTab = (OutputTab)((JComponent)object).getClientProperty("component");
            }
            if ((object = outputWindow.getController()) != null) {
                ((Controller)object).actionPerformed(outputWindow, outputTab, this.getID());
            }
        }
    }

    static class ControllerOutputEvent
    extends OutputEvent {
        private int line;

        ControllerOutputEvent(NbIO nbIO, int n) {
            super((InputOutput)nbIO);
            this.line = n;
        }

        void setLine(int n) {
            this.line = n;
        }

        public String getLine() {
            NbIO nbIO = (NbIO)this.getSource();
            OutWriter outWriter = nbIO.out();
            try {
                if (outWriter != null) {
                    String string = outWriter.getLines().getLine(this.line);
                    if (string.endsWith("\n")) {
                        string = string.substring(0, string.length() - 1);
                    }
                    if (string.endsWith("\r")) {
                        string = string.substring(0, string.length() - 1);
                    }
                    return string;
                }
            }
            catch (IOException iOException) {
                IOException iOException2 = new IOException("Could not fetch line " + this.line + " on " + nbIO.getName());
                iOException2.initCause(iOException);
                Exceptions.printStackTrace((Throwable)iOException);
            }
            return null;
        }
    }

    private static class PMListener
    implements PopupMenuListener {
        private Object[] popupItems;
        private Object handle;

        PMListener(Object[] objectArray, Object object) {
            this.popupItems = objectArray;
            this.handle = object;
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            JPopupMenu jPopupMenu = (JPopupMenu)popupMenuEvent.getSource();
            jPopupMenu.removeAll();
            jPopupMenu.setInvoker(null);
            AbstractOutputTab abstractOutputTab = (AbstractOutputTab)jPopupMenu.getClientProperty("component");
            KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
            JTextComponent jTextComponent = abstractOutputTab.getOutputPane().getTextView();
            jTextComponent.getInputMap().put(keyStroke, this.handle);
            abstractOutputTab.getInputMap(1).put(keyStroke, this.handle);
            jPopupMenu.putClientProperty("container", null);
            jPopupMenu.putClientProperty("component", null);
            jPopupMenu.removePopupMenuListener(this);
            for (int i = 0; i < this.popupItems.length; ++i) {
                if (!(this.popupItems[i] instanceof ControllerAction)) continue;
                ((ControllerAction)this.popupItems[i]).clearListeners();
            }
        }

        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            this.popupMenuWillBecomeInvisible(popupMenuEvent);
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        }
    }

    private static class ProxyAction
    implements Action {
        private Action orig;

        ProxyAction(Action action) {
            this.orig = action;
        }

        public Object getValue(String string) {
            if ("SmallIcon".equals(string)) {
                return null;
            }
            return this.orig.getValue(string);
        }

        public void putValue(String string, Object object) {
            this.orig.putValue(string, object);
        }

        public void setEnabled(boolean bl) {
            this.orig.setEnabled(bl);
        }

        public boolean isEnabled() {
            return this.orig.isEnabled();
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.orig.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.orig.removePropertyChangeListener(propertyChangeListener);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.orig.actionPerformed(actionEvent);
        }
    }
}

